/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public class BX509ExtensionPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BX509ExtensionPane.class);
    private static final List<String> OID_READONLY_LIST = Arrays.asList("2.5.29.19", "2.5.29.37", "2.5.29.15", "2.5.29.14", "1.3.6.1.4.1.4131.2");
    private BCheckBox[] selected;
    private NX509Extension[] extensions = null;
    private boolean selectable = false;

    public Type getType() {
        return TYPE;
    }

    public BX509ExtensionPane() {
    }

    public BX509ExtensionPane(NX509Extension[] extensions) {
        this.extensions = extensions;
        this.buildExtensions();
    }

    public BX509ExtensionPane(NX509Extension[] extensions, boolean selectable) {
        this.extensions = extensions;
        this.selectable = selectable;
        this.buildExtensions();
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public int getExtensionCount() {
        if (this.extensions == null) {
            return 0;
        }
        return this.extensions.length;
    }

    public boolean isSelected(int index) {
        if (this.extensions == null) {
            return false;
        }
        if (index > this.extensions.length - 1) {
            return false;
        }
        if (this.selected == null) {
            return false;
        }
        if (index > this.selected.length - 1) {
            return false;
        }
        return this.selected[index].getSelected();
    }

    public NX509Extension getExtension(int index) {
        return this.extensions[index];
    }

    public void setExtensions(NX509Extension[] extensions, boolean selectable) {
        this.extensions = extensions;
        this.selectable = selectable;
        this.buildExtensions();
    }

    protected BWidget createPaddedLabel(String text) {
        BLabel label = new BLabel(text, BHalign.left);
        label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        return new BBorderPane((BWidget)label, 0.0, 5.0, 0.0, 5.0);
    }

    private void buildExtensions() {
        BGridPane grid;
        if (this.selectable) {
            grid = new BGridPane(2);
            grid.setStretchColumn(1);
        } else {
            grid = new BGridPane(1);
            grid.setStretchColumn(0);
        }
        grid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)grid, (String)"scrolled");
        grid.setColumnAlign(BHalign.fill);
        grid.setHalign(BHalign.left);
        ArrayList<BCheckBox> checks = new ArrayList<BCheckBox>();
        for (NX509Extension extension : this.extensions) {
            if (this.selectable) {
                BCheckBox checkbox = new BCheckBox("", true);
                if (this.checkReadOnlyExtension(extension)) {
                    checkbox.setEnabled(false);
                }
                checks.add(checkbox);
                BBorderPane paddedCheck = new BBorderPane((BWidget)checkbox, 0.0, 10.0, 0.0, 10.0);
                grid.add(null, (BValue)paddedCheck);
            }
            BEdgePane extDataPane = new BEdgePane();
            extDataPane.setTop(this.createPaddedLabel("Identifier: " + extension.getIdentifier()));
            String[] extData = extension.getExtensionText();
            StringBuilder buf = new StringBuilder("isCritical: " + (extension.isCritical() ? "true" : "false"));
            for (String data : extData) {
                buf.append("\n");
                buf.append(data);
            }
            extDataPane.setCenter(this.createPaddedLabel(buf.toString()));
            BConstrainedPane spacer = new BConstrainedPane();
            spacer.setMinWidth(15.0);
            extDataPane.setLeft((BWidget)spacer);
            grid.add(null, (BValue)extDataPane);
        }
        this.selected = checks.toArray(new BCheckBox[checks.size()]);
        this.setCenter((BWidget)grid);
    }

    private boolean checkReadOnlyExtension(NX509Extension ext) {
        if (OID_READONLY_LIST.contains(ext.getOid().getId())) {
            return true;
        }
        try {
            if (ext.getOid().getId().equals("2.5.29.18")) {
                if (ext.getObject().getType() == ASN1ObjectIdentifier.class && ext.getObject().getValue().equals("tridiumHostId")) {
                    return true;
                }
                if (this.checkForTridiumHostId(ext.getObject())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkForTridiumHostId(NX509Extension.NASN1Primitive child) {
        NX509Extension.NASN1Primitive[] objs;
        if ("tridiumHostId".equals(child.getValue())) {
            return true;
        }
        for (NX509Extension.NASN1Primitive obj : objs = child.getChildren()) {
            if (!this.checkForTridiumHostId(obj)) continue;
            return true;
        }
        return false;
    }
}

