/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;

public class BX509ExtensionChangedPane
extends BEdgePane {
    public static final Type TYPE = Sys.loadType(BX509ExtensionChangedPane.class);
    private NX509Extension[] oldExtensions = null;
    private NX509Extension[] extensions = null;

    public Type getType() {
        return TYPE;
    }

    public BX509ExtensionChangedPane() {
    }

    public BX509ExtensionChangedPane(NX509Extension[] oldExtensions, NX509Extension[] extensions) {
        this.oldExtensions = oldExtensions;
        this.extensions = extensions;
        this.buildExtensions();
    }

    protected BWidget createPaddedLabel(String text, boolean changed) {
        BLabel label = new BLabel(text, BHalign.left);
        label.setFont(Theme.label().getFixedWidthFont((IStylable)label));
        if (changed) {
            StyleUtils.addStyleClass((IStylable)label, (String)"warning emphasized");
        }
        BBorderPane pane = new BBorderPane((BWidget)label, 0.0, 5.0, 0.0, 5.0);
        return pane;
    }

    private void buildExtensions() {
        int j;
        boolean found;
        int i;
        BGridPane grid = new BGridPane(1);
        grid.setStretchColumn(0);
        grid.setColorRows(true);
        StyleUtils.addStyleClass((IStylable)grid, (String)"scrolled");
        grid.setColumnAlign(BHalign.fill);
        grid.setHalign(BHalign.left);
        for (i = 0; i < this.oldExtensions.length; ++i) {
            found = false;
            for (j = 0; j < this.extensions.length; ++j) {
                if (!this.oldExtensions[i].getOid().equals((Object)this.extensions[j].getOid())) continue;
                found = true;
                if (this.oldExtensions[i].equals((Object)this.extensions[j])) {
                    grid.add(null, (BValue)this.getExtensionWidget(this.oldExtensions[i], "", false));
                    break;
                }
                BEdgePane pane = new BEdgePane();
                pane.setTop(this.getExtensionWidget(this.oldExtensions[i], "(-) ", false));
                pane.setBottom(this.getExtensionWidget(this.extensions[j], "(+) ", true));
                grid.add(null, (BValue)pane);
                break;
            }
            if (found) continue;
            grid.add(null, (BValue)this.getExtensionWidget(this.oldExtensions[i], "(-) ", false));
        }
        for (i = 0; i < this.extensions.length; ++i) {
            found = false;
            for (j = 0; j < this.oldExtensions.length; ++j) {
                if (!this.extensions[i].getOid().equals((Object)this.oldExtensions[j].getOid())) continue;
                found = true;
                break;
            }
            if (found) continue;
            grid.add(null, (BValue)this.getExtensionWidget(this.extensions[i], "(+) ", true));
        }
        this.setCenter((BWidget)grid);
    }

    private BWidget getExtensionWidget(NX509Extension ext, String sym, boolean changed) {
        BEdgePane extDataPane = new BEdgePane();
        extDataPane.setTop(this.createPaddedLabel(sym + "Identifier: " + ext.getIdentifier(), changed));
        String[] extData = ext.getExtensionText();
        StringBuffer buf = new StringBuffer("isCritical: " + (ext.isCritical() ? "true" : "false"));
        for (int j = 0; j < extData.length; ++j) {
            buf.append("\n");
            buf.append(extData[j]);
        }
        extDataPane.setCenter(this.createPaddedLabel(buf.toString(), changed));
        BConstrainedPane spacer = new BConstrainedPane();
        spacer.setMinWidth(15.0);
        extDataPane.setLeft((BWidget)spacer);
        return extDataPane;
    }
}

