/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.platcrypto.ui.BPasswordField;
import javax.baja.gx.BImage;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

public class BPrivateKeyPasswordDialog
extends BDialog {
    public static final Action okButtonPressed = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BPrivateKeyPasswordDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BPrivateKeyPasswordDialog.class);
    private static Lexicon lex = Lexicon.make((String)"platCrypto");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected BButton okButton;
    protected BButton cancelButton;
    private BPassword password = null;
    private BPasswordField passwordField = null;
    private BPasswordField confirmField = null;

    public void okButtonPressed(BWidgetEvent event) {
        this.invoke(okButtonPressed, (BValue)event, null);
    }

    public void cancelButtonPressed(BWidgetEvent event) {
        this.invoke(cancelButtonPressed, (BValue)event, null);
    }

    public void setModified(BWidgetEvent event) {
        this.invoke(setModified, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BPassword open(BWidget owner) {
        BPrivateKeyPasswordDialog dialog = new BPrivateKeyPasswordDialog(owner);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    private BPrivateKeyPasswordDialog(BWidget owner) {
        super(owner, "Private Key Password", true);
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        this.okButton.setEnabled(true);
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), lex.get("cert.export.privatekey.title"));
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.center);
        contentPane.setColumnAlign(BHalign.center);
        contentPane.add(null, (BValue)new BLabel(lex.get("cert.export.password.prompt"), BHalign.left));
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 7.0, 7.0, 7.0);
    }

    private BWidget buildBody() {
        BGridPane grid = new BGridPane(2);
        grid.setRowGap(5.0);
        grid.setColumnGap(5.0);
        grid.setColumnAlign(BHalign.left);
        grid.setStretchColumn(1);
        grid.add(null, (BValue)new BLabel(lex.get("password.field.password")));
        this.passwordField = new BPasswordField();
        grid.add(null, (BValue)this.passwordField);
        grid.add(null, (BValue)new BLabel(lex.get("password.field.confirm")));
        this.confirmField = new BPasswordField();
        grid.add(null, (BValue)this.confirmField);
        this.linkTo(null, (BComponent)this.passwordField, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.confirmField, (Slot)BPasswordField.textModified, (Slot)setModified);
        return grid;
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(3);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public BPassword getPassword() {
        return this.password;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        try {
            BPasswordStrength.DEFAULT.isPasswordValid(this.confirmField.getText());
            this.password = BPassword.make((String)this.confirmField.getText());
            this.close();
        }
        catch (Exception e) {
            Lexicon bajaLex = Lexicon.make((String)"baja");
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)bajaLex.get("user.strongPassword.invalid"), (Throwable)e);
        }
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        try {
            if (this.passwordField.getText().equals(this.confirmField.getText())) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

