/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.util.FriendlyPemReader;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.ui.PrivateKeyPasswordFinder;
import com.tridium.platcrypto.util.BPemFile;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.baja.gx.BImage;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;

public class BPemFileView
extends BWbView {
    public static final Type TYPE = Sys.loadType(BPemFileView.class);
    public BTextEditorPane pane = new BTextEditorPane("", 80, 40, true);
    public BTextEditor editor = this.pane.getEditor();
    protected static Lexicon lex = Lexicon.make((String)"platCrypto");
    protected static BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://crypto/icons/x32/cert.png"));

    public Type getType() {
        return TYPE;
    }

    public BPemFileView() {
        this.setContent((BWidget)this.pane);
    }

    protected BWidget buildHeader() {
        return new BWizardHeader(logo, lex.getText("pem.file.viewer.title"));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        StringBuffer buf = new StringBuffer();
        BPemFile file = (BPemFile)value;
        InputStream is = file.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        FriendlyPemReader fpr = new FriendlyPemReader((Reader)isr);
        PEMParser pr = new PEMParser((Reader)fpr);
        int count = 0;
        while (count < 50) {
            try {
                JcaPEMKeyConverter converter;
                KeyPair pair;
                Object cert;
                Object obj = pr.readObject();
                if (obj == null) break;
                if (obj instanceof X509Certificate) {
                    cert = NX509Certificate.make((X509Certificate)((X509Certificate)obj));
                    buf.append(cert.toString());
                } else if (obj instanceof X509CertificateHolder) {
                    cert = new JcaX509CertificateConverter().getCertificate((X509CertificateHolder)obj);
                    buf.append(((Certificate)cert).toString());
                } else if (obj instanceof PKCS10CertificationRequest) {
                    JcaPKCS10CertificationRequest jcacsr = new JcaPKCS10CertificationRequest(((PKCS10CertificationRequest)obj).getEncoded());
                    NPKCS10CertificationRequest csr = NPKCS10CertificationRequest.make((JcaPKCS10CertificationRequest)jcacsr);
                    buf.append(csr.toString());
                } else if (obj instanceof Key) {
                    buf.append(NKey.toString((Key)((Key)obj)));
                } else if (obj instanceof KeyPair) {
                    pair = (KeyPair)obj;
                    buf.append(NKey.toString((Key)pair.getPrivate()));
                    buf.append(NKey.toString((Key)pair.getPublic()));
                } else if (obj instanceof PEMKeyPair) {
                    pair = (PEMKeyPair)obj;
                    converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    buf.append(NKey.toString((Key)converter.getPrivateKey(pair.getPrivateKeyInfo())));
                    buf.append(NKey.toString((Key)converter.getPublicKey(pair.getPublicKeyInfo())));
                } else if (obj instanceof PEMEncryptedKeyPair) {
                    JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    PEMDecryptorProvider decryptor = builder.build(new PrivateKeyPasswordFinder((BWidget)this).getPassword());
                    JcaPEMKeyConverter converter2 = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    PEMKeyPair pair2 = ((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor);
                    buf.append(NKey.toString((Key)converter2.getPrivateKey(pair2.getPrivateKeyInfo())));
                    buf.append(NKey.toString((Key)converter2.getPublicKey(pair2.getPublicKeyInfo())));
                } else if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
                    InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider()).build(new PrivateKeyPasswordFinder((BWidget)this).getPassword());
                    converter = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    PrivateKey privateKey = converter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo(pkcs8Prov));
                    buf.append(NKey.toString((Key)privateKey));
                } else if (obj instanceof PrivateKeyInfo) {
                    JcaPEMKeyConverter converter3 = new JcaPEMKeyConverter().setProvider(SecurityInitializer.getInstance().getCryptoProvider().getProvider());
                    PrivateKey privateKey = converter3.getPrivateKey((PrivateKeyInfo)obj);
                    buf.append(NKey.toString((Key)privateKey));
                } else {
                    buf.append("unrecognized object: " + obj.getClass().getName() + "\n");
                    buf.append(obj.toString());
                }
                buf.append("\n");
            }
            catch (Exception e) {
                ++count;
                buf.append("error parsing object: " + e.getLocalizedMessage()).append("\n");
            }
        }
        try {
            if (pr != null) {
                pr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.editor.setEditable(false);
        this.editor.setText(buf.toString());
    }

    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        return super.doSaveValue(value, cx);
    }
}

