/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NCertificateParameters;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.CoreKeyStore;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platcrypto.ui.BCertExportDialog;
import com.tridium.platcrypto.ui.BCertImportDialog;
import com.tridium.platcrypto.ui.BCertRequestDialog;
import com.tridium.platcrypto.ui.BCertsTable;
import com.tridium.platcrypto.ui.BExportResponse;
import com.tridium.platcrypto.ui.BPrivateKeyPasswordDialog;
import com.tridium.platcrypto.ui.BSelfSignedDialog;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.workbench.util.BPasswordPromptDialog;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.xml.XElem;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;

@NiagaraType
public class BLocalCertsTable
extends BCertsTable {
    public static final Type TYPE = Sys.loadType(BLocalCertsTable.class);
    private ICoreKeyStore keyStore;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BLocalCertsTable() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public BLocalCertsTable(ICoreCryptoManager mgr, ICoreKeyStore store) throws Exception {
        super(mgr, (ICoreTrustStore)store);
        this.keyStore = store;
    }

    @Override
    protected void initCommands() {
        this.getCommandBindings().setSupport((CommandBindings.Support)this);
        BCertsTable.ViewCommand view = new BCertsTable.ViewCommand();
        this.addCommand(view, BCommandEnablePolicy.singleSelection);
        this.setDoubleClickCommand(view);
        this.addCommand(new NewCommand(), BCommandEnablePolicy.always);
        this.addCommand(new CsrCommand(), BCommandEnablePolicy.singleSelection);
        this.addCommand(new BCertsTable.DeleteCommand(), BCommandEnablePolicy.anySelection);
        this.addCommand(new LocalImportCommand(), BCommandEnablePolicy.always);
        this.addCommand(new ExportCommand(), BCommandEnablePolicy.singleSelection);
        this.addCommand(new ResetCommand(), BCommandEnablePolicy.always);
        this.setCommandEnabledStates();
    }

    private void certGenRequest(BWidget owner) {
        BCertsTable.CertGenRequest request = BSelfSignedDialog.show(owner, this.mgr, this.keyStore);
        if (request != null) {
            this.certGenRequests.put(request.getRequestId(), request);
            this.checkCertMonitorThread();
            BDialog.info((BWidget)owner, (Object)lex.get("cert.generate.notify.msg"));
        }
    }

    protected class ResetCommand
    extends Command {
        public ResetCommand() {
            super((BWidget)BLocalCertsTable.this, BCertsTable.lex, "cert.button.reset");
        }

        public CommandArtifact doInvoke() {
            block14: {
                if (!BLocalCertsTable.this.mgr.canGenerateCertificate()) {
                    BDialog.open((BWidget)BLocalCertsTable.this.getParentWidget(), (String)BCertsTable.lex.getText("station.running.dialog.title"), (Object)BCertsTable.lex.getText("station.running.reset.dialog.message"), (int)1, (BImage)BDialog.WARNING_ICON, (String)null);
                    return null;
                }
                try {
                    String alias;
                    NCertificateParameters certParams;
                    int requestId;
                    BPlatCryptoManager daemonManager;
                    BDaemonSession daemonSession;
                    boolean requestServerRestart = false;
                    String dialogContentLexiconKey = "cert.reset.dialog.info";
                    if (BLocalCertsTable.this.mgr instanceof BPlatCryptoManager && (requestServerRestart = (daemonSession = (daemonManager = (BPlatCryptoManager)BLocalCertsTable.this.mgr).getDaemonSession()).getHostProperties().getSslSettings().getSslEnabled())) {
                        dialogContentLexiconKey = "cert.reset.dialog.daemonRestart.info";
                    }
                    if (4 != BDialog.open((BWidget)BLocalCertsTable.this, (String)BCertsTable.lex.getText("cert.reset.dialog.title"), (Object)BCertsTable.lex.getText(dialogContentLexiconKey), (int)12, (BImage)BImage.make((String)"module://icons/x32/warning.png"))) break block14;
                    Enumeration aliases = BLocalCertsTable.this.keyStore.aliases();
                    ArrayList aliasList = new ArrayList();
                    while (aliases.hasMoreElements()) {
                        aliasList.add(aliases.nextElement());
                    }
                    BLocalCertsTable.this.keyStore.deleteEntries(aliasList.toArray(new String[aliasList.size()]));
                    BLocalCertsTable.this.keyStore.save();
                    BLocalCertsTable.this.certModel().load();
                    Calendar cal = Calendar.getInstance();
                    Date notBefore = null;
                    Date notAfter = null;
                    try {
                        if (BLocalCertsTable.this.mgr instanceof BPlatCryptoManager) {
                            String utcMills;
                            BPlatCryptoManager daemonManager2 = (BPlatCryptoManager)BLocalCertsTable.this.mgr;
                            BDaemonSession daemonSession2 = daemonManager2.getDaemonSession();
                            XElem currentTimeElem = DaemonTimeUtil.getCurrentTimeElem((BDaemonSession)daemonSession2);
                            if (currentTimeElem != null && (utcMills = currentTimeElem.get("millis", null)) != null) {
                                cal.setTime(new Date(Long.valueOf(utcMills)));
                                notBefore = cal.getTime();
                                cal.set(1, cal.get(1) + 1);
                                notAfter = cal.getTime();
                            }
                            requestServerRestart = daemonSession2.getHostProperties().getSslSettings().getSslEnabled();
                        } else if (BLocalCertsTable.this.mgr instanceof ChannelCryptoManager) {
                            ChannelCryptoManager channelCryptoManager = (ChannelCryptoManager)BLocalCertsTable.this.mgr;
                            BFoxSession foxSession = channelCryptoManager.getFoxSession();
                            BSystemPlatformService systemPlatformService = (BSystemPlatformService)foxSession.getService(BSystemPlatformService.TYPE);
                            systemPlatformService.loadSlots();
                            systemPlatformService.poll();
                            cal.setTime(new Date(systemPlatformService.getSystemTime().getMillis()));
                            notBefore = cal.getTime();
                            cal.set(1, cal.get(1) + 1);
                            notAfter = cal.getTime();
                        }
                    }
                    catch (Exception e) {
                        notBefore = null;
                        notAfter = null;
                    }
                    if (notBefore == null) {
                        notBefore = cal.getTime();
                        cal.set(1, cal.get(1) + 1);
                        notAfter = cal.getTime();
                    }
                    if ((requestId = BLocalCertsTable.this.mgr.generateSelfSignedCert(certParams = new NCertificateParameters(alias = "tridium", "CN=Niagara4,O=Tridium,C=US", "CN=Niagara4,O=Tridium,C=US", notBefore, notAfter, 2048, KeyPurpose.SERVER_CERT, null, null, null))) != -1) {
                        BCertsTable.CertGenRequest request = new BCertsTable.CertGenRequest(requestId, alias, requestServerRestart);
                        BLocalCertsTable.this.certGenRequests.put(requestId, request);
                        BLocalCertsTable.this.checkCertMonitorThread();
                        BCertsTable.log.fine("cert generation submitted for '" + alias + "'");
                        BDialog.info((BWidget)this.getOwner(), (Object)BCertsTable.lex.get("cert.generate.notify.msg"));
                    } else {
                        BCertsTable.log.severe("cert generation failed for '" + alias + "'");
                        BLocalCertsTable.this.notify(BCertsTable.lex.get("cert.generate.title"), BCertsTable.failedIcon, BCertsTable.lex.get("cert.generate.failed"), BCertsTable.lex.getText("cert.generate.failed.msg", new Object[]{alias}));
                    }
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
            return null;
        }
    }

    protected class ExportCommand
    extends Command {
        public ExportCommand() {
            super((BWidget)BLocalCertsTable.this, BCertsTable.lex, "cert.button.export");
        }

        public CommandArtifact doInvoke() {
            try {
                int row = BLocalCertsTable.this.getSelection().getRow();
                try {
                    BICertificateFormatHandler certFormatHandler;
                    BExportResponse response;
                    String alias = BLocalCertsTable.this.certModel().cert(row).getAlias();
                    X509Certificate cert = BLocalCertsTable.this.certModel().cert(row).getCertificate(0).getCertificate();
                    NX509Certificate ncert = NX509Certificate.make((X509Certificate)cert);
                    X509Certificate[] certificateChain = BLocalCertsTable.this.trustStore.getCertificateChain(alias);
                    PrivateKey pkey = null;
                    int keyMode = 0;
                    if (BLocalCertsTable.this.trustStore.isKeyEntry(alias)) {
                        try {
                            pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, null);
                            keyMode = 1;
                        }
                        catch (Exception e) {
                            keyMode = 2;
                        }
                    }
                    if ((response = BCertExportDialog.show(this.getOwner(), ncert, keyMode)) == null) {
                        return null;
                    }
                    if (pkey == null && response.getExportPrivateKey()) {
                        try {
                            pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, AccessController.doPrivileged(() -> ((BPassword)response.getPrivateKeyPassword()).getValue()).toCharArray());
                        }
                        catch (Exception eke2) {
                            BDialog.error((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.invalid.password.title"), (Object)BCertsTable.lex.getText("cert.invalid.password.msg"));
                            return null;
                        }
                    }
                    if ((certFormatHandler = response.getCertFormatHandler()) == null) {
                        certFormatHandler = BPEMCertificateHandler.INSTANCE;
                    }
                    BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
                    String fileName = alias + "." + certFormatHandler.getDefaultFileExtension();
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.certsDirectoryPath)));
                    chooser.setDefaultFileName(fileName);
                    chooser.setTitle(BCertsTable.lex.getText("cert.export.dialog.title"));
                    chooser.addFilter((IFileFilter)new ExtFileFilter(certFormatHandler.getCertificateFormatFileTypeName(null), String.join((CharSequence)",", certFormatHandler.getSupportedFileExtensions())));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return null;
                    }
                    BAbstractFile target = (BAbstractFile)ord.get();
                    if (certificateChain == null) {
                        certificateChain = new X509Certificate[]{cert};
                    }
                    if (response.getExportPrivateKey() && response.getExportCert()) {
                        certFormatHandler.writeCertAndKeyToFile(pkey, response.getEncryptPrivateKey(), response.getReusePassword() ? response.getPrivateKeyPassword() : response.getPrivateKeySavedPassword(), certificateChain, target);
                    } else if (response.getExportPrivateKey()) {
                        certFormatHandler.writeKeyToFile(pkey, response.getEncryptPrivateKey(), response.getReusePassword() ? response.getPrivateKeyPassword() : response.getPrivateKeySavedPassword(), target);
                    } else if (response.getExportCert()) {
                        certFormatHandler.writeCertToFile(certificateChain, target);
                    }
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.export.error.title"), (Object)BCertsTable.lex.getText("cert.export.error.msg"), (Throwable)e);
                    e.printStackTrace();
                    return null;
                }
                BDialog.message((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.export.success.title"), (Object)BCertsTable.lex.getText("cert.export.success.msg"));
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class CsrCommand
    extends Command {
        public CsrCommand() {
            super((BWidget)BLocalCertsTable.this, BCertsTable.lex, "cert.button.csr");
        }

        public CommandArtifact doInvoke() {
            block18: {
                try {
                    int row = BLocalCertsTable.this.certModel().getSelection().getRow();
                    if (!BCertRequestDialog.request(this.getOwner(), BLocalCertsTable.this.certModel().cert(row).getCertificate(0))) break block18;
                    String alias = BLocalCertsTable.this.certModel().cert(row).getAlias();
                    String pass = null;
                    try {
                        PrivateKey privateKey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, null);
                    }
                    catch (UnrecoverableKeyException uke) {
                        BPassword response = BPasswordPromptDialog.open((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("cert.pkey.dialog.title"), (String)BCertsTable.lex.getText("cert.pkey.dialog.info"));
                        if (response == null) {
                            return null;
                        }
                        pass = AccessController.doPrivileged(() -> ((BPassword)response).getValue());
                    }
                    NPKCS10CertificationRequest csr = BLocalCertsTable.this.mgr.generateCSR(alias, pass);
                    if (csr == null) break block18;
                    BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
                    chooser.addFilter((IFileFilter)new ExtFileFilter(BCertsTable.lex.getText("csr.extension.info"), "csr"));
                    chooser.setTitle(BCertsTable.lex.getText(BCertsTable.lex.getText("csr.filechooser.dialog.title")));
                    chooser.setDefaultFileName(alias + ".csr");
                    chooser.setCurrentDirectory(BOrd.make((String)("file:/" + BCertsTable.getCertsDirectoryPath())));
                    BOrd ord = chooser.show();
                    if (ord == null) {
                        return null;
                    }
                    BIFile target = (BIFile)ord.get();
                    try (JcaPEMWriter pem = new JcaPEMWriter((Writer)new OutputStreamWriter(target.getOutputStream()));){
                        pem.writeObject((Object)new JcaPKCS10CertificationRequest(csr.getRequest().getEncoded()));
                    }
                    BConstrainedPane pane = new BConstrainedPane((BWidget)new BLabel(BCertsTable.lex.getText("csr.generate.complete")));
                    pane.setMinWidth(200.0);
                    BDialog.info((BWidget)this.getOwner(), (String)BCertsTable.lex.getText("csr.extension.info"), (Object)pane);
                }
                catch (Exception e) {
                    CommandUtil.error((Command)this, (Throwable)e);
                }
            }
            return null;
        }
    }

    protected class NewCommand
    extends Command {
        public NewCommand() {
            super((BWidget)BLocalCertsTable.this, BCertsTable.lex, "cert.button.new");
        }

        public CommandArtifact doInvoke() {
            if (!BLocalCertsTable.this.mgr.canGenerateCertificate()) {
                BDialog.open((BWidget)BLocalCertsTable.this.getParentWidget(), (String)BCertsTable.lex.getText("station.running.dialog.title"), (Object)BCertsTable.lex.getText("station.running.dialog.message"), (int)1, (BImage)BDialog.WARNING_ICON, (String)null);
            } else {
                BLocalCertsTable.this.certGenRequest(this.getOwner());
            }
            return null;
        }
    }

    protected class LocalImportCommand
    extends BCertsTable.ImportCommand {
        protected LocalImportCommand() {
        }

        @Override
        protected void importCertData(Array<X509Certificate> certs, PrivateKey pkey, String defaultAlias) throws Exception {
            X509Certificate[] chain = CertUtils.sortCertChain((List)certs.list()).toArray(new X509Certificate[0]);
            if (chain.length <= 0) {
                BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.certificate.missing.title"), (Object)BCertsTable.lex.get("cert.import.certificate.missing.msg"));
                return;
            }
            NX509Certificate ncert = NX509Certificate.make((X509Certificate)chain[0]);
            String alias = BLocalCertsTable.this.keyStore.findCertificate((X509Certificate)certs.get(0));
            if (alias != null) {
                alias = BCertImportDialog.prompt(this.getOwner(), ncert, alias, (ICoreTrustStore)BLocalCertsTable.this.keyStore, true);
                if (alias == null) {
                    return;
                }
                if (pkey == null && !BLocalCertsTable.this.keyStore.isKeyEntry(alias)) {
                    BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.privatekey.missing.title"), (Object)BCertsTable.lex.get("cert.import.privatekey.missing.msg"));
                    return;
                }
                if (CertUtils.isCACertificate((X509Certificate)ncert.getCertificate()) || CertUtils.isCodeSigningCertificate((X509Certificate)ncert.getCertificate())) {
                    BPassword pass = BPrivateKeyPasswordDialog.open(this.getOwner());
                    if (pass == null) {
                        return;
                    }
                    if (pkey == null) {
                        pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray());
                    }
                    if (BLocalCertsTable.this.keyStore instanceof CoreKeyStore) {
                        ((CoreKeyStore)BLocalCertsTable.this.keyStore).setKeyEntry(alias, (Key)pkey, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray(), chain, false);
                    } else {
                        BLocalCertsTable.this.keyStore.setKeyEntry(alias, (Key)pkey, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray(), chain);
                    }
                } else {
                    pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, null);
                    if (BLocalCertsTable.this.keyStore instanceof CoreKeyStore) {
                        ((CoreKeyStore)BLocalCertsTable.this.keyStore).setKeyEntry(alias, (Key)pkey, null, chain, false);
                    } else {
                        BLocalCertsTable.this.keyStore.setKeyEntry(alias, (Key)pkey, null, chain);
                    }
                }
            } else {
                alias = BCertImportDialog.prompt(this.getOwner(), ncert, defaultAlias, (ICoreTrustStore)BLocalCertsTable.this.keyStore, false);
                if (alias == null) {
                    return;
                }
                if (alias.trim().length() <= 0) {
                    BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.alias.missing.title"), (Object)BCertsTable.lex.get("cert.import.alias.missing.msg"));
                    return;
                }
                X509Certificate tcert = BLocalCertsTable.this.keyStore.getCertificate(alias);
                if (tcert != null && !tcert.getPublicKey().equals(ncert.getPublicKey())) {
                    BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.privatekey.mismatch.title"), (Object)BCertsTable.lex.get("cert.import.privatekey.mismatch.msg"));
                    return;
                }
                if (pkey == null && !BLocalCertsTable.this.keyStore.isKeyEntry(alias)) {
                    BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.privatekey.missing.title"), (Object)BCertsTable.lex.get("cert.import.privatekey.missing.msg"));
                    return;
                }
                if (CertUtils.isCACertificate((X509Certificate)ncert.getCertificate()) || CertUtils.isCodeSigningCertificate((X509Certificate)ncert.getCertificate())) {
                    BPassword pass = BPrivateKeyPasswordDialog.open(this.getOwner());
                    if (pass == null) {
                        return;
                    }
                    if (pkey == null) {
                        pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray());
                    }
                    if (BLocalCertsTable.this.keyStore instanceof CoreKeyStore) {
                        ((CoreKeyStore)BLocalCertsTable.this.keyStore).setKeyEntry(alias, (Key)pkey, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray(), chain, false);
                    } else {
                        BLocalCertsTable.this.keyStore.setKeyEntry(alias, (Key)pkey, AccessController.doPrivileged(() -> ((BPassword)pass).getValue()).toCharArray(), chain);
                    }
                } else {
                    if (pkey == null) {
                        try {
                            pkey = (PrivateKey)BLocalCertsTable.this.keyStore.getKey(alias, null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (pkey == null) {
                            BDialog.warning((BWidget)this.getOwner(), (String)BCertsTable.lex.get("cert.import.privatekey.missing.title"), (Object)BCertsTable.lex.get("cert.import.privatekey.missing.msg"));
                            return;
                        }
                    }
                    if (BLocalCertsTable.this.keyStore instanceof CoreKeyStore) {
                        ((CoreKeyStore)BLocalCertsTable.this.keyStore).setKeyEntry(alias, (Key)pkey, null, chain, false);
                    } else {
                        BLocalCertsTable.this.keyStore.setKeyEntry(alias, (Key)pkey, null, chain);
                    }
                }
            }
        }
    }
}

