/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.cert.NX509Extension;
import com.tridium.platcrypto.ui.BCertificateExtension;
import com.tridium.platcrypto.ui.BCertificateExtensionFolder;
import java.util.Arrays;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="filename", type="BString", defaultValue=""), @NiagaraProperty(name="subject", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="subjectDN", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="keyAlgorithm", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="keySize", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="signatureAlgorithm", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="signatureSize", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="verify", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="notBefore", type="BAbsTime", defaultValue="BAbsTime.now()"), @NiagaraProperty(name="notAfter", type="BAbsTime", defaultValue="BAbsTime.make(Clock.millis() + 2L * 365L * 24L * 60L * 60L * 1000L)"), @NiagaraProperty(name="extensions", type="BCertificateExtensionFolder", defaultValue="new BCertificateExtensionFolder()", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"platCrypto:CertificateExtensionFolderFE\")")}), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=5)})
public final class BCertificateSigningRequest
extends BComponent
implements BIStatus {
    public static final Property filename = BCertificateSigningRequest.newProperty((int)0, (String)"", null);
    public static final Property subject = BCertificateSigningRequest.newProperty((int)1, (String)"", null);
    public static final Property subjectDN = BCertificateSigningRequest.newProperty((int)1, (String)"", null);
    public static final Property keyAlgorithm = BCertificateSigningRequest.newProperty((int)1, (String)"", null);
    public static final Property keySize = BCertificateSigningRequest.newProperty((int)1, (int)0, null);
    public static final Property signatureAlgorithm = BCertificateSigningRequest.newProperty((int)1, (String)"", null);
    public static final Property signatureSize = BCertificateSigningRequest.newProperty((int)1, (int)0, null);
    public static final Property verify = BCertificateSigningRequest.newProperty((int)1, (boolean)false, null);
    public static final Property notBefore = BCertificateSigningRequest.newProperty((int)0, (BValue)BAbsTime.now(), null);
    public static final Property notAfter = BCertificateSigningRequest.newProperty((int)0, (BValue)BAbsTime.make((long)(Clock.millis() + 63072000000L)), null);
    public static final Property extensions = BCertificateSigningRequest.newProperty((int)0, (BValue)new BCertificateExtensionFolder(), (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platCrypto:CertificateExtensionFolderFE")));
    public static final Property status = BCertificateSigningRequest.newProperty((int)5, (BValue)BStatus.ok, null);
    public static final Type TYPE = Sys.loadType(BCertificateSigningRequest.class);
    private static final BIcon icon = BIcon.std((String)"files/certificate.png");
    private static final BIcon warningIcon = BIcon.std((String)"warning.png");
    public static final String SUBJECT_ALTERNATIVE_NAME_OID = "2.5.29.17";
    public static final String ISSUER_ALTERNATIVE_NAME_OID = "2.5.29.18";
    public static final String TRIDIUM_HOST_ID = "tridiumHostId";
    public static final List<String> OID_READONLY_LIST = Arrays.asList("2.5.29.19", "2.5.29.37", "2.5.29.15", "2.5.29.14", "1.3.6.1.4.1.4131.2");
    private final BAbstractFile csrFile;
    private final NPKCS10CertificationRequest certificationRequest;

    public String getFilename() {
        return this.getString(filename);
    }

    public void setFilename(String v) {
        this.setString(filename, v, null);
    }

    public String getSubject() {
        return this.getString(subject);
    }

    public void setSubject(String v) {
        this.setString(subject, v, null);
    }

    public String getSubjectDN() {
        return this.getString(subjectDN);
    }

    public void setSubjectDN(String v) {
        this.setString(subjectDN, v, null);
    }

    public String getKeyAlgorithm() {
        return this.getString(keyAlgorithm);
    }

    public void setKeyAlgorithm(String v) {
        this.setString(keyAlgorithm, v, null);
    }

    public int getKeySize() {
        return this.getInt(keySize);
    }

    public void setKeySize(int v) {
        this.setInt(keySize, v, null);
    }

    public String getSignatureAlgorithm() {
        return this.getString(signatureAlgorithm);
    }

    public void setSignatureAlgorithm(String v) {
        this.setString(signatureAlgorithm, v, null);
    }

    public int getSignatureSize() {
        return this.getInt(signatureSize);
    }

    public void setSignatureSize(int v) {
        this.setInt(signatureSize, v, null);
    }

    public boolean getVerify() {
        return this.getBoolean(verify);
    }

    public void setVerify(boolean v) {
        this.setBoolean(verify, v, null);
    }

    public BAbsTime getNotBefore() {
        return (BAbsTime)this.get(notBefore);
    }

    public void setNotBefore(BAbsTime v) {
        this.set(notBefore, (BValue)v, null);
    }

    public BAbsTime getNotAfter() {
        return (BAbsTime)this.get(notAfter);
    }

    public void setNotAfter(BAbsTime v) {
        this.set(notAfter, (BValue)v, null);
    }

    public BCertificateExtensionFolder getExtensions() {
        return (BCertificateExtensionFolder)this.get(extensions);
    }

    public void setExtensions(BCertificateExtensionFolder v) {
        this.set(extensions, (BValue)v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BCertificateSigningRequest(BAbstractFile csrFile, NPKCS10CertificationRequest certificationRequest) throws Exception {
        this.csrFile = csrFile;
        this.certificationRequest = certificationRequest;
        this.setSubject(certificationRequest.getSubject());
        this.setSubjectDN(certificationRequest.getSubjectDN().toString());
        this.setKeyAlgorithm(certificationRequest.getKeyAlgorithm());
        this.setKeySize(certificationRequest.getKeySize());
        this.setSignatureAlgorithm(certificationRequest.getSignatureAlgorithm());
        this.setSignatureSize(certificationRequest.getSignatureSize());
        this.setVerify(certificationRequest.verify());
        for (NX509Extension nx509Extension : certificationRequest.getExtensions()) {
            BCertificateExtension certificateExtension = new BCertificateExtension(nx509Extension);
            if (!this.checkReadOnlyExtension(certificateExtension.getNx509Extension())) {
                Slot include = certificateExtension.getSlot("include");
                certificateExtension.setFlags(include, include.getDefaultFlags() & 0xFFFFFFFE);
            }
            this.getExtensions().add(SlotPath.escape((String)certificateExtension.getIdentifier()), (BValue)certificateExtension, 0, null, null);
        }
    }

    public BIcon getIcon() {
        return this.getStatus().isOk() ? icon : warningIcon;
    }

    private boolean checkReadOnlyExtension(NX509Extension ext) {
        if (OID_READONLY_LIST.contains(ext.getOid().getId())) {
            return true;
        }
        try {
            if (ISSUER_ALTERNATIVE_NAME_OID.equals(ext.getOid().getId())) {
                if (ext.getObject().getType() == ASN1ObjectIdentifier.class && TRIDIUM_HOST_ID.equals(ext.getObject().getValue())) {
                    return true;
                }
                if (this.checkForTridiumHostId(ext.getObject())) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean checkForTridiumHostId(NX509Extension.NASN1Primitive child) {
        NX509Extension.NASN1Primitive[] objs;
        if (TRIDIUM_HOST_ID.equals(child.getValue())) {
            return true;
        }
        for (NX509Extension.NASN1Primitive obj : objs = child.getChildren()) {
            if (!this.checkForTridiumHostId(obj)) continue;
            return true;
        }
        return false;
    }

    public NPKCS10CertificationRequest getCertificationRequest() {
        return this.certificationRequest;
    }

    public String getCertificationRequestFileName() {
        String fileName = this.csrFile.getFileName();
        int lastIndexOfDot = fileName.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            fileName = fileName.substring(0, lastIndexOfDot);
        }
        return fileName;
    }
}

