/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platcrypto.ui.BCertViewDialog;
import java.security.cert.X509Certificate;
import javax.baja.gx.BImage;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;

public class BCertImportDialog
extends BCertViewDialog {
    public static final Action cancelButtonPressed = BCertImportDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action setModified = BCertImportDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BCertImportDialog.class);
    static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    private BButton cancelButton;
    private BTextField aliasTextField;
    private String alias = null;
    private boolean readonly;
    private ICoreTrustStore store;

    public void cancelButtonPressed(BWidgetEvent event) {
        this.invoke(cancelButtonPressed, (BValue)event, null);
    }

    public void setModified(BWidgetEvent event) {
        this.invoke(setModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static String prompt(BWidget owner, NX509Certificate cert, String alias, ICoreTrustStore store, boolean readonly) throws Exception {
        BCertImportDialog dialog = new BCertImportDialog(owner, cert, alias, store, readonly);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getAlias();
    }

    private BCertImportDialog(BWidget parent, NX509Certificate cert, String alias, ICoreTrustStore store, boolean readonly) throws Exception {
        super(parent, lex.getText("cert.import.dialog.title"));
        this.cert = cert;
        this.alias = alias;
        this.store = store;
        this.readonly = readonly;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        if (this.aliasTextField.getText().length() > 0) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.getTitle(), lex.getText("cert.import.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildContent() throws Exception {
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop(this.buildAliasPrompt());
        edgePane.setCenter(super.buildContent());
        return edgePane;
    }

    private BWidget buildAliasPrompt() {
        BEdgePane pane = new BEdgePane();
        pane.setLeft(BCertImportDialog.createPaddedLabel(lex.getText("cert.field.aliasPrompt")));
        this.aliasTextField = new BTextField(this.alias == null ? "" : this.alias, 30, true);
        pane.setCenter((BWidget)this.aliasTextField);
        this.aliasTextField.setEditable(!this.readonly);
        this.linkTo(null, (BComponent)this.aliasTextField, (Slot)BTextField.textModified, (Slot)setModified);
        BBorderPane border = new BBorderPane((BWidget)pane, 20.0, 20.0, 20.0, 0.0);
        return border;
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        int replace;
        X509Certificate match = null;
        try {
            match = this.store.getCertificate(this.aliasTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (match != null && !this.readonly && (replace = BDialog.open((BWidget)this, (String)lex.getText("cert.generate.warning.matchingAlias"), (Object)lex.getText("cert.generate.warning.matchingAlias.description", new Object[]{this.aliasTextField.getText()}), (int)12, (BImage)BDialog.WARNING_ICON)) == 8) {
            return;
        }
        this.close();
        this.alias = this.aliasTextField.getText();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
        this.alias = null;
    }

    public void doSetModified(BWidgetEvent event) {
        try {
            if (this.aliasTextField.getText().length() > 0) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

