/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.platcrypto.ui.BExportResponse;
import com.tridium.platcrypto.ui.BPasswordField;
import java.util.List;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platCrypto.certs.BICertificateFormatHandler;
import javax.baja.platCrypto.certs.BPEMCertificateHandler;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Localizable;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="formatHandlerChanged", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BCertExportDialog
extends BCertViewDialog {
    public static final Action setModified = BCertExportDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action cancelButtonPressed = BCertExportDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Action formatHandlerChanged = BCertExportDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType(BCertExportDialog.class);
    protected BTextDropDown exportFormatDropDown;
    protected BCheckBox exportCertCheckBox;
    protected BCheckBox exportPkCheckBox;
    protected BLabel caPasswordLbl;
    protected BPasswordField caPassword;
    protected BCheckBox reusePasswordCheckBox;
    protected BCheckBox encryptPrivateKeyCheckBox;
    protected BPasswordField exportedPassword;
    protected BPasswordField exportedConfirmPassword;
    protected BLabel exportedPasswordLbl;
    protected BLabel exportedConfirmPasswordLbl;
    protected BLabel errorMessageLabel;
    protected BButton cancelButton;
    protected BExportResponse closeResult = null;
    protected int keyMode = 0;
    public static final int KEY_MODE_NONE = 0;
    public static final int KEY_MODE_SERVER = 1;
    public static final int KEY_MODE_CA = 2;
    protected static BImage pkLogo = BImage.make((String)lex.get("key.x32.icon", "module://icons/x32/lock.png"));

    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    public void formatHandlerChanged(BWidgetEvent parameter) {
        this.invoke(formatHandlerChanged, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BExportResponse show(BWidget owner, NX509Certificate cert, int keyMode) throws Exception {
        BCertExportDialog dialog = new BCertExportDialog(owner, cert, keyMode);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    protected BCertExportDialog(BWidget parent, NX509Certificate cert, int keyMode) throws Exception {
        super(parent, lex.getText("cert.export.dialog.title"));
        this.cert = cert;
        this.keyMode = keyMode;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildDialog() throws Exception {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildCertPane());
        if (this.keyMode != 0) {
            dialogPane.setCenter(this.buildKeyPane());
        }
        dialogPane.setBottom(this.buildButtons());
        this.linkTo((BComponent)this.exportFormatDropDown, (Slot)BDropDown.valueModified, (Slot)formatHandlerChanged);
        this.exportFormatDropDown.setText(BPEMCertificateHandler.INSTANCE.getCertificateFormatName(null));
        return dialogPane;
    }

    protected BWidget buildCertPane() throws Exception {
        BEdgePane certPane = new BEdgePane();
        certPane.setTop((BWidget)new BWizardHeader(logo, lex.getText("cert.export.dialog.certificate"), ""));
        BGridPane certBody = new BGridPane(1);
        certBody.setHalign(BHalign.fill);
        certBody.add(null, (BValue)this.buildExportFormatRow());
        this.exportCertCheckBox = new BCheckBox(lex.getText("cert.export.cert.exportcert"), true);
        certBody.add(null, (BValue)this.exportCertCheckBox);
        this.linkTo("linkA", (BComponent)this.exportCertCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        certBody.add(null, (BValue)super.buildBody());
        if (this.keyMode == 0) {
            certPane.setCenter((BWidget)new BBorderPane((BWidget)certBody, 7.0, 7.0, 0.0, 17.0));
            this.exportCertCheckBox.setEnabled(false);
        } else {
            certPane.setCenter((BWidget)new BBorderPane((BWidget)certBody, 7.0, 7.0, 14.0, 17.0));
        }
        return certPane;
    }

    protected BWidget buildExportFormatRow() {
        BGridPane exportFormatPane = new BGridPane(2);
        BLabel exportFormatLabel = new BLabel(lex.getText("cert.export.cert.certFormat"));
        List exportFormatNames = BICertificateFormatHandler.getCertificateFormatHandlers().stream().map(handler -> handler.getCertificateFormatName(null)).collect(Collectors.toList());
        this.exportFormatDropDown = new BTextDropDown(exportFormatNames, 8, false);
        exportFormatPane.add(null, (BValue)exportFormatLabel);
        exportFormatPane.add(null, (BValue)this.exportFormatDropDown);
        return exportFormatPane;
    }

    @Override
    protected Size getCertViewSize() {
        return new Size(450.0, 170.0);
    }

    protected BWidget buildKeyPane() throws Exception {
        BEdgePane keyPane = new BEdgePane();
        keyPane.setTop((BWidget)new BWizardHeader(pkLogo, lex.getText("cert.export.dialog.privatekey"), ""));
        BGridPane keyBody = new BGridPane(1);
        keyBody.setHalign(BHalign.fill);
        this.exportPkCheckBox = new BCheckBox(lex.getText("cert.export.cert.exportprivatekey"), false);
        keyBody.add(null, (BValue)this.exportPkCheckBox);
        this.linkTo("linkB", (BComponent)this.exportPkCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        if (this.keyMode == 2) {
            BEdgePane caPasswordPane = new BEdgePane();
            this.caPasswordLbl = new BLabel(lex.getText("cert.export.password.prompt"), BHalign.left);
            caPasswordPane.setLeft((BWidget)this.caPasswordLbl);
            this.caPasswordLbl.setEnabled(false);
            this.caPassword = new BPasswordField();
            caPasswordPane.setCenter((BWidget)new BBorderPane((BWidget)this.caPassword, 0.0, 0.0, 0.0, 5.0));
            this.caPassword.setEnabled(false);
            keyBody.add(null, (BValue)caPasswordPane);
        }
        BEdgePane exportPasswordPane = new BEdgePane();
        this.encryptPrivateKeyCheckBox = new BCheckBox(lex.getText("cert.export.encryptprivatekey"), true);
        exportPasswordPane.setTop((BWidget)this.encryptPrivateKeyCheckBox);
        this.encryptPrivateKeyCheckBox.setEnabled(false);
        this.linkTo("linkC", (BComponent)this.encryptPrivateKeyCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        exportPasswordPane.setLeft((BWidget)new BLabel("       "));
        BGridPane passwordChoicePane = new BGridPane(1);
        this.reusePasswordCheckBox = new BCheckBox(lex.getText("cert.export.reuse"), true);
        if (this.keyMode == 2) {
            passwordChoicePane.add(null, (BValue)this.reusePasswordCheckBox);
            this.reusePasswordCheckBox.setEnabled(false);
            this.linkTo("linkD", (BComponent)this.reusePasswordCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
        } else {
            this.reusePasswordCheckBox.setVisible(false);
            this.reusePasswordCheckBox.setSelected(false);
        }
        BGridPane exportPasswordPrompt = new BGridPane(2);
        exportPasswordPrompt.setRowGap(5.0);
        exportPasswordPrompt.setColumnGap(5.0);
        exportPasswordPrompt.setColumnAlign(BHalign.left);
        exportPasswordPrompt.setStretchColumn(1);
        this.exportedPasswordLbl = new BLabel(lex.get("password.field.password"), BHalign.left);
        exportPasswordPrompt.add(null, (BValue)this.exportedPasswordLbl);
        this.exportedPasswordLbl.setEnabled(false);
        this.exportedPassword = new BPasswordField();
        exportPasswordPrompt.add(null, (BValue)this.exportedPassword);
        this.exportedPassword.setEnabled(false);
        this.linkTo("linkE", (BComponent)this.exportedPassword, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.exportedConfirmPasswordLbl = new BLabel(lex.get("password.field.confirm"), BHalign.left);
        exportPasswordPrompt.add(null, (BValue)this.exportedConfirmPasswordLbl);
        this.exportedConfirmPasswordLbl.setEnabled(false);
        this.exportedConfirmPassword = new BPasswordField();
        exportPasswordPrompt.add(null, (BValue)this.exportedConfirmPassword);
        this.exportedConfirmPassword.setEnabled(false);
        this.linkTo("linkF", (BComponent)this.exportedConfirmPassword, (Slot)BPasswordField.textModified, (Slot)setModified);
        passwordChoicePane.add(null, (BValue)exportPasswordPrompt);
        this.errorMessageLabel = new BLabel();
        this.errorMessageLabel.setHalign(BHalign.left);
        this.errorMessageLabel.setForeground(BBrush.makeSolid((BColor)BColor.green));
        passwordChoicePane.add(null, (BValue)this.errorMessageLabel);
        exportPasswordPane.setCenter((BWidget)passwordChoicePane);
        keyBody.add(null, (BValue)new BBorderPane((BWidget)exportPasswordPane, 4.0, 0.0, 0.0, 0.0));
        keyPane.setCenter((BWidget)new BBorderPane((BWidget)keyBody, 7.0, 7.0, 7.0, 17.0));
        return keyPane;
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkY", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkZ", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 7.0, 10.0, 7.0);
    }

    public void doFormatHandlerChanged(BWidgetEvent event) {
        BICertificateFormatHandler handler = BICertificateFormatHandler.getHandlerFromFormatName((String)this.exportFormatDropDown.getText(), null);
        if (!handler.supportsPrivateKey()) {
            this.exportPkCheckBox.setSelected(false);
            this.exportPkCheckBox.setEnabled(false);
            BWidgetEvent pkEvent = new BWidgetEvent(2, (BWidget)this.exportPkCheckBox);
            this.setModified(pkEvent);
            this.encryptPrivateKeyCheckBox.setSelected(false);
            this.encryptPrivateKeyCheckBox.setEnabled(false);
            BWidgetEvent encryptPkEvent = new BWidgetEvent(2, (BWidget)this.encryptPrivateKeyCheckBox);
            this.setModified(encryptPkEvent);
        } else {
            this.exportPkCheckBox.setEnabled(true);
            this.encryptPrivateKeyCheckBox.setEnabled(true);
        }
    }

    public void doSetModified(BWidgetEvent event) {
        if (this.exportPkCheckBox.getSelected()) {
            if (this.keyMode == 2) {
                this.caPasswordLbl.setEnabled(true);
                this.caPassword.setEnabled(true);
            }
            this.encryptPrivateKeyCheckBox.setEnabled(true);
            if (this.encryptPrivateKeyCheckBox.getSelected()) {
                if (this.keyMode == 2) {
                    this.reusePasswordCheckBox.setEnabled(true);
                }
                if (this.reusePasswordCheckBox.getSelected()) {
                    this.exportedPassword.setEnabled(false);
                    this.exportedPasswordLbl.setEnabled(false);
                    this.exportedConfirmPassword.setEnabled(false);
                    this.exportedConfirmPasswordLbl.setEnabled(false);
                    this.okButton.setEnabled(true);
                } else {
                    this.exportedPassword.setEnabled(true);
                    this.exportedPasswordLbl.setEnabled(true);
                    this.exportedConfirmPassword.setEnabled(true);
                    this.exportedConfirmPasswordLbl.setEnabled(true);
                    if (this.exportedPassword.getText().length() == 0 || this.exportedConfirmPassword.getText().length() == 0) {
                        this.okButton.setEnabled(false);
                    } else if (this.exportedPassword.getText().equals(this.exportedConfirmPassword.getText())) {
                        this.okButton.setEnabled(true);
                    } else {
                        this.okButton.setEnabled(false);
                    }
                }
            } else {
                this.reusePasswordCheckBox.setEnabled(false);
                this.exportedPassword.setEnabled(false);
                this.exportedPasswordLbl.setEnabled(false);
                this.exportedConfirmPassword.setEnabled(false);
                this.exportedConfirmPasswordLbl.setEnabled(false);
                this.okButton.setEnabled(true);
            }
        } else {
            if (this.keyMode == 2) {
                this.caPasswordLbl.setEnabled(false);
                this.caPassword.setEnabled(false);
            }
            this.reusePasswordCheckBox.setEnabled(false);
            this.encryptPrivateKeyCheckBox.setEnabled(false);
            this.exportedPassword.setEnabled(false);
            this.exportedPasswordLbl.setEnabled(false);
            this.exportedConfirmPassword.setEnabled(false);
            this.exportedConfirmPasswordLbl.setEnabled(false);
            this.okButton.setEnabled(true);
        }
        this.processPasswordErrorMessage();
        if (!this.exportPkCheckBox.getSelected() && !this.exportCertCheckBox.getSelected()) {
            this.okButton.setEnabled(false);
        }
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        switch (this.keyMode) {
            case 2: {
                this.closeResult = BExportResponse.make(this.exportCertCheckBox.getSelected(), this.exportPkCheckBox.getSelected(), BPassword.make((String)this.caPassword.getText()), this.encryptPrivateKeyCheckBox.getSelected(), this.reusePasswordCheckBox.getSelected(), BPassword.make((String)this.exportedPassword.getText()), BICertificateFormatHandler.getHandlerFromFormatName((String)this.exportFormatDropDown.getText(), null));
                break;
            }
            case 1: {
                this.closeResult = BExportResponse.make(this.exportCertCheckBox.getSelected(), this.exportPkCheckBox.getSelected(), BPassword.DEFAULT, this.encryptPrivateKeyCheckBox.getSelected(), this.reusePasswordCheckBox.getSelected(), BPassword.make((String)this.exportedPassword.getText()), BICertificateFormatHandler.getHandlerFromFormatName((String)this.exportFormatDropDown.getText(), null));
                break;
            }
            default: {
                this.closeResult = BExportResponse.make(this.exportCertCheckBox.getSelected(), false, BPassword.DEFAULT, false, false, BPassword.DEFAULT, BICertificateFormatHandler.getHandlerFromFormatName((String)this.exportFormatDropDown.getText(), null));
            }
        }
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.closeResult = null;
        this.close();
    }

    private void processPasswordErrorMessage() {
        boolean enable = true;
        StringJoiner error = new StringJoiner("\n");
        if (this.exportedPassword.getEnabled()) {
            boolean passwordsMatch = this.exportedPassword.getText().equals(this.exportedConfirmPassword.getText());
            AtomicReference messageReference = new AtomicReference();
            boolean passwordIsValid = BPasswordStrength.DEFAULT.isPasswordValid(this.exportedPassword.getText().toCharArray(), messageReference::set);
            if (!passwordsMatch || !passwordIsValid) {
                enable = false;
                if (!passwordsMatch) {
                    error.add(lex.getText("cert.export.passwordNotConfirmed"));
                }
                if (!passwordIsValid) {
                    error.add(((Localizable)messageReference.get()).toString(null));
                }
            }
        }
        this.errorMessageLabel.setText(error.toString());
        this.errorMessageLabel.setVisible(!error.toString().isEmpty());
        this.setScreenSizeToPreferredSize();
        this.okButton.setEnabled(enable);
    }

    public BExportResponse getResult() {
        return this.closeResult;
    }
}

