/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.auth;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.workbench.auth.BCredentialsEditor;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BCertificateAliasCredential;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbShell;

@NiagaraType(agent={@AgentOn(types={"baja:CertificateAliasCredential"})})
public class BCertificateAliasCredentialFE
extends BCredentialsEditor {
    public static final Type TYPE = Sys.loadType(BCertificateAliasCredentialFE.class);
    private BCertificateAliasCredential credential;
    private BTextDropDown certField = new BTextDropDown();
    private BTextField usernameField = new BTextField();
    private ICoreCryptoManager coreCryptoManager;

    public Type getType() {
        return TYPE;
    }

    public BCertificateAliasCredentialFE() {
        BGridPane mainPane = new BGridPane(1);
        mainPane.add(null, (BValue)this.usernameField);
        mainPane.add(null, (BValue)this.certField);
        this.setContent((BWidget)mainPane);
        this.linkTo("lk0", (BComponent)this.usernameField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.certField, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk2", (BComponent)this.certField, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.usernameField.setEnabled(!readonly);
        this.certField.getDisplayWidget().setEnabled(!readonly);
        this.certField.getDropDownWidget().setEnabled(!readonly);
        this.certField.setDropDownEnabled(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.credential = (BCertificateAliasCredential)value;
        this.certField.getList().removeAllItems();
        this.usernameField.setText(this.credential.getUsername());
        BWbShell shell = BWbShell.getWbShell((BWidget)this);
        if (shell == null) {
            throw new BajaException("Widget is not mounted in a shell or the shell isn't an instanceof BWbShell");
        }
        BOrd ord = shell.getActiveOrd();
        BComponent component = (BComponent)ord.get();
        BISession session = component.getSession();
        if (session == null) {
            throw new BajaException("Unable to retrieve session");
        }
        if (!(session instanceof BFoxSession)) {
            throw new BajaException("Fox session not available");
        }
        this.coreCryptoManager = new ChannelCryptoManager(component);
        ICoreKeyStore keyStore = this.coreCryptoManager.getKeyStore();
        Enumeration aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = (String)aliases.nextElement();
            if (!CertUtils.isClientCert((X509Certificate)keyStore.getCertificate(alias))) continue;
            this.certField.getList().addItem((Object)alias);
        }
        int index = this.certField.getList().indexOfItem((Object)this.credential.getCertificateAlias());
        if (index != -1) {
            this.certField.getList().setSelectedIndex(index);
            this.certField.setText(this.credential.getCertificateAlias());
        }
    }

    protected BObject doSaveValue(BObject v, Context cx) {
        BCertificateAliasCredential certCredential = (BCertificateAliasCredential)v;
        BString username = BString.make((String)this.usernameField.getText());
        BString alias = BString.make((String)this.certField.getText());
        Property[] properties = new Property[]{BCertificateAliasCredential.username, BCertificateAliasCredential.certificateAlias};
        BValue[] values = new BValue[]{username, alias};
        certCredential.set(properties, values, cx);
        return certCredential;
    }
}

