/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.export.ui.impl.destination;

import com.tridium.export.impl.destination.BLaunchExternalApplicationDestinationType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.baja.export.BIExportDestinationType;
import javax.baja.export.BITransformOperation;
import javax.baja.export.ExportException;
import javax.baja.file.BajaFileUtil;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;

@NiagaraType
@NiagaraSingleton
public final class BViewInExternalApplicationDestinationType
extends BSingleton
implements BIExportDestinationType<Context> {
    public static final BViewInExternalApplicationDestinationType INSTANCE = new BViewInExternalApplicationDestinationType();
    public static final Type TYPE = Sys.loadType(BViewInExternalApplicationDestinationType.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"bajaui");

    public Type getType() {
        return TYPE;
    }

    private BViewInExternalApplicationDestinationType() {
    }

    public void checkValid(Context cx) throws ExportException {
        if (Sys.getStation() != null) {
            throw new ExportException("Only valid in Workbench");
        }
    }

    public String getDisplayName(Context cx) {
        return LEX.get("exporter.action.viewExternal.label", cx);
    }

    public <T, X extends Context> void transform(BITransformOperation<T, ? super X> transformOperation, X cx) throws IOException, ExportException {
        String fileExtension = BViewInExternalApplicationDestinationType.getFileExtension(cx);
        try (InputStream data = transformOperation.doTransform(cx);){
            File tempFile = BajaFileUtil.createTempFile((String)fileExtension);
            Files.copy(data, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            BLaunchExternalApplicationDestinationType.launchExternal((File)tempFile);
        }
    }

    private static String getFileExtension(Context cx) throws ExportException {
        BObject ext = cx.getFacet("fileExtension");
        if (ext == null) {
            throw new ExportException("fileExtension facet required");
        }
        return ext.toString();
    }
}

