/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScanXpr;

import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BEthernetPort;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.sys.Nre;
import java.util.Vector;
import javax.baja.nre.util.Array;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.Lexicon;

public class BNpmXprBoard
extends BBaseBoard {
    public static final Property LAN1 = BNpmXprBoard.newProperty((int)1, (BValue)new BEthernetPort("en0"), null);
    public static final Property LAN2 = BNpmXprBoard.newProperty((int)1, (BValue)new BEthernetPort("en1"), null);
    public static final Property COM1 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs232, "tridium:serial", "COM"), null);
    public static final Property COM2 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.rs485, "tridium:serial", "COM"), null);
    public static final Property COM3 = BNpmXprBoard.newProperty((int)1, (BValue)new BPort(BPortTypeEnum.nrio, "tridium:nrio", "COM", BHwScanStatusEnum.dedicated), null);
    public static final Property optionSlot1 = BNpmXprBoard.newProperty((int)1, (BValue)new BOptionSlot(1), null);
    public static final Type TYPE = Sys.loadType(BNpmXprBoard.class);
    private static final Lexicon lex = Lexicon.make(BNpmXprBoard.class);
    private static final String BASE_BOARD_CODE = "05";
    private static final String VIEW = "pxView";
    private static final String IMAGES_DIR = "imageDir";
    private static final int BASE_LAN_PORT = 3;
    private static final int BASE_LON_PORT = 1;
    private static final int BASE_SERIAL_PORT = 7;
    private static final int HARDWARE_REF_COUNT = 8;

    public BEthernetPort getLAN1() {
        return (BEthernetPort)this.get(LAN1);
    }

    public void setLAN1(BEthernetPort v) {
        this.set(LAN1, (BValue)v, null);
    }

    public BEthernetPort getLAN2() {
        return (BEthernetPort)this.get(LAN2);
    }

    public void setLAN2(BEthernetPort v) {
        this.set(LAN2, (BValue)v, null);
    }

    public BPort getCOM1() {
        return (BPort)this.get(COM1);
    }

    public void setCOM1(BPort v) {
        this.set(COM1, (BValue)v, null);
    }

    public BPort getCOM2() {
        return (BPort)this.get(COM2);
    }

    public void setCOM2(BPort v) {
        this.set(COM2, (BValue)v, null);
    }

    public BPort getCOM3() {
        return (BPort)this.get(COM3);
    }

    public void setCOM3(BPort v) {
        this.set(COM3, (BValue)v, null);
    }

    public BOptionSlot getOptionSlot1() {
        return (BOptionSlot)this.get(optionSlot1);
    }

    public void setOptionSlot1(BOptionSlot v) {
        this.set(optionSlot1, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> optCardCodes, boolean simulation) {
        this.setSimulation(simulation);
        this.setProductModel(lex.getText(Nre.getHostModel().toUpperCase()));
        this.initializeStandardPorts();
        this.nextSerialPort = 7;
        this.nextLonPort = 1;
        this.nextLanPort = 3;
        this.configureOptionSlot(this.getOptionSlot1(), (String)optCardCodes.get(0), (String)optCardCodes.get(1));
        this.scanFactoryOptions(optCardCodes);
    }

    public String getBoardCode() {
        return BASE_BOARD_CODE;
    }

    public String getImagesDirectory() {
        return lex.getText(IMAGES_DIR);
    }

    public String getView(BObject v) {
        return lex.getText(VIEW);
    }

    public void configureOptionSlot(BOptionSlot slot, String functionCode1, String functionCode2) {
        slot.removeAll();
        if (!functionCode1.equalsIgnoreCase("FF") || !functionCode2.equalsIgnoreCase("FF")) {
            BOptionCard cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2));
            if (cardTemplate == null) {
                slot.addCard(new BOptionCard(BHardwareScanService.lex.getText("unknownOptionCard", new Object[]{functionCode1, functionCode2}), functionCode1 + " " + functionCode2));
            } else {
                BOptionCard optionCard = (BOptionCard)cardTemplate.newCopy(true);
                slot.addCard(optionCard);
                BPort[] ports = optionCard.getPorts();
                for (int i = 0; i < ports.length; ++i) {
                    if (ports[i] == null) continue;
                    BPort port = ports[i];
                    if (optionCard.getUsesCom()) {
                        optionCard.rename(optionCard.getProperty("Port" + (i + 1)), port.getPrefix() + 1, null);
                        if (this.getCOM1().getStatus().equals((Object)BHwScanStatusEnum.serialShell)) {
                            port.setStatus(BHwScanStatusEnum.unavailable);
                            continue;
                        }
                        this.getCOM1().setStatus(BHwScanStatusEnum.unavailable);
                        if (this.simulation) continue;
                        port.initOwnerAndStatus();
                        continue;
                    }
                    optionCard.rename(optionCard.getProperty("Port" + (i + 1)), this.makePortName(i + 1, port.getPrefix()), null);
                    if (this.simulation) continue;
                    port.initOwnerAndStatus();
                }
            }
        }
        if (slot.isEmpty()) {
            slot.add("Contents", (BValue)BHwScanStatusEnum.empty, 3);
        }
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        Vector<BHardwareRef> v = new Vector<BHardwareRef>();
        block10: for (int i = 1; i <= 8; ++i) {
            switch (i) {
                case 1: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN1()));
                    continue block10;
                }
                case 2: {
                    v.addElement(this.makeBaseboardCommRef(i, (BPort)this.getLAN2()));
                    continue block10;
                }
                case 3: {
                    v.addElement(this.makeJumperRef(i));
                    continue block10;
                }
                case 4: {
                    v.addElement(new BHardwareRef(i, this.getBaseUnitText(), lex.getText("HardwareRef.factoryOptions")));
                    BOptionCard[] optionCards = (BOptionCard[])this.getChildren(BOptionCard.class);
                    for (int j = 1; j <= optionCards.length; ++j) {
                        String ref = String.valueOf(i) + Character.forDigit(9 + j, 16);
                        BOptionCard optionCard = optionCards[j - 1];
                        v.addElement(new BHardwareRef(ref, this.getBaseUnitText(), optionCard.getDescription()));
                        BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                        for (int k = 0; k < cardPorts.length; ++k) {
                            v.addElement(this.makePortRef(ref, k + 1, cardPorts[k]));
                        }
                    }
                    continue block10;
                }
                case 5: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM3()));
                    continue block10;
                }
                case 6: {
                    BOptionSlot slot = this.getOptionSlot1();
                    v.addElement(this.makeSlotRef(i, slot));
                    if (slot.isEmpty()) continue block10;
                    BOptionCard optionCard = (BOptionCard)slot.getContents();
                    optionCard.lease(1);
                    BPort[] cardPorts = (BPort[])optionCard.getChildren(BPort.class);
                    for (int j = 0; j < cardPorts.length; ++j) {
                        v.addElement(this.makePortRef(i, j + 1, cardPorts[j]));
                    }
                    continue block10;
                }
                case 7: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM1()));
                    continue block10;
                }
                case 8: {
                    v.addElement(this.makeBaseboardCommRef(i, this.getCOM2()));
                }
            }
        }
        return v;
    }

    private void initializeStandardPorts() {
        this.setDisplayName(COM1, BFormat.make((String)("COM".toUpperCase() + "1")), null);
        this.setDisplayName(COM2, BFormat.make((String)("COM".toUpperCase() + "2")), null);
        this.setDisplayName(COM3, BFormat.make((String)("COM".toUpperCase() + "3")), null);
        this.setDisplayName(LAN1, BFormat.make((String)("LAN".toUpperCase() + "1")), null);
        this.setDisplayName(LAN2, BFormat.make((String)("LAN".toUpperCase() + "2")), null);
        if (!this.simulation) {
            this.getCOM1().initOwnerAndStatus();
            this.getCOM2().initOwnerAndStatus();
            this.getCOM3().initOwnerAndStatus();
            this.getLAN1().initStatus();
            this.getLAN2().initStatus();
        }
    }

    public void scanFactoryOptions(Array<String> optCardCodes) {
        BOptionCard optionCard;
        BOptionCard cardTemplate;
        String functionCode1 = (String)optCardCodes.get(4);
        String functionCode2 = (String)optCardCodes.get(5);
        if (((String)optCardCodes.get(5)).equalsIgnoreCase("8A") && (cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2))) != null) {
            optionCard = (BOptionCard)cardTemplate.newCopy(true);
            this.add("WIRELESS8A", (BValue)optionCard);
            optionCard.rename(optionCard.getProperty("Port1"), "COM4", null);
        }
        functionCode1 = (String)optCardCodes.get(6);
        functionCode2 = (String)optCardCodes.get(7);
        if (functionCode1.equalsIgnoreCase("62") && (cardTemplate = BOptionCard.lookup((String)(functionCode1 + " " + functionCode2))) != null) {
            optionCard = (BOptionCard)cardTemplate.newCopy(true);
            this.add("GPRS", (BValue)optionCard);
            optionCard.rename(optionCard.getProperty("Port1"), "COM5", null);
            optionCard.rename(optionCard.getProperty("Port2"), "COM6", null);
        }
    }
}

