/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.user;

import com.tridium.bql.filter.BBooleanFilter;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenantCache;
import com.tridiumx.entsec.securityUtil.query.BColumnsProvider;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.user.BEntsecUserConfig;
import com.tridiumx.entsec.user.BIEntsecProfile;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.web.BWebProfileConfig;

public class BUserColumnsProvider
extends BColumnsProvider {
    public static final Type TYPE = Sys.loadType(BUserColumnsProvider.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public TypeSpecPath[] getDefaultColumns(BQuery query) {
        Array a = new Array(TypeSpecPath.class);
        a.add((Object)new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName", lex.getText("userName")));
        a.add((Object)new TypeSpecPath(BUser.fullName));
        a.add((Object)new TypeSpecPath(BUser.roles));
        BFunctionExpression function = Funcs.make((String)(TYPE.toString() + ".getTenants"), (Type)BInteger.TYPE, (BExpression)Exprs.simple((BSimple)new BTenantCache()));
        TypeSpecPath getTenants = new TypeSpecPath(BTenantCache.TYPE.getTypeSpec(), "tenants", null, (BExpression)function);
        a.add((Object)getTenants);
        return (TypeSpecPath[])a.trim();
    }

    @Override
    public TypeSpecPath[] getHiddenColumns(BQuery query) {
        Array a = new Array((Object[])super.getHiddenColumns(query));
        BFunctionExpression function = Funcs.make((String)(TYPE.toString() + ".isSecurityUser"), (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)BString.DEFAULT));
        TypeSpecPath isSecurityUser = new TypeSpecPath(BBoolean.TYPE.getTypeSpec(), "isSecurityUser", null, (BExpression)function);
        BBooleanFilter filter = new BBooleanFilter();
        filter.setValue(true);
        isSecurityUser.defaultFilter = filter;
        a.add(0, (Object)isSecurityUser);
        return (TypeSpecPath[])a.trim();
    }

    public static BBoolean isSecurityUser(BObject target, BString name) {
        if (!(target instanceof BUser) || name == null) {
            return null;
        }
        BUser ext = (BUser)target;
        BWebProfileConfig config = (BWebProfileConfig)ext.getMixIn(BWebProfileConfig.TYPE);
        return BBoolean.make((boolean)config.getTypeSpec().getResolvedType().is(BIEntsecProfile.TYPE));
    }

    public static BString getTenants(BObject target, BTenantCache tenantCache) {
        if (!(target instanceof BUser) || tenantCache == null) {
            return null;
        }
        BUser user = (BUser)target;
        BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
        BRefList tenants = config.getTenants();
        return BString.make((String)tenantCache.getDisplayString(tenants));
    }
}

