/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.user;

import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BOrionDatabase;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

public class BEntsecUserConfig
extends BComponent
implements BIMixIn,
BIOrionDatabaseObject {
    public static final Property tenants = BEntsecUserConfig.newProperty((int)0, (BValue)BRefList.make(BTenant.TYPE.toString()), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"trim", (boolean)true), (BFacets)BFacets.make((String)"suTenantRequired", (boolean)false)), (BFacets)BFacets.make((String)"userTenants", (boolean)true)));
    public static final Property home = BEntsecUserConfig.newProperty((int)0, (String)"/", (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:EntsecNavChooserFE"));
    public static final Property roles = BEntsecUserConfig.newProperty((int)5, (String)"", null);
    public static final Type TYPE = Sys.loadType(BEntsecUserConfig.class);
    public static BOrd MEMORY_NAV = BOrd.make((String)"entsecnav:homeNavOrd");
    public static BOrd DEFAULT_ENTSEC_HOME = BOrd.make((String)"module://entsec/rc/entsecHome.nav");
    private RolesSubscriber subscriber;
    private static final String N4_ROLE_DELIMITER = ",";
    private static final String AX_ROLE_DELIMITER = ";";
    private static final String AX_ADMIN_ROLE = "Admin";
    private static final String N4_ADMIN_ROLE = "admin";

    public BRefList getTenants() {
        return (BRefList)this.get(tenants);
    }

    public void setTenants(BRefList v) {
        this.set(tenants, (BValue)v, null);
    }

    public String getHome() {
        return this.getString(home);
    }

    public void setHome(String v) {
        this.setString(home, v, null);
    }

    public String getRoles() {
        return this.getString(roles);
    }

    public void setRoles(String v) {
        this.setString(roles, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return "Security Configuration";
    }

    public void started() throws Exception {
        BUser user = (BUser)this.getParent();
        String axRolesMap = user.getRoles();
        axRolesMap = axRolesMap.replaceAll(N4_ROLE_DELIMITER, AX_ROLE_DELIMITER);
        this.setRoles(axRolesMap);
        if (Sys.isStationStarted()) {
            this.subscriber = new RolesSubscriber();
            this.subscriber.subscribe((BComponent)((BUser)this.getParent()));
        }
    }

    public void stopped() {
        if (Sys.getStation().isRunning()) {
            this.subscriber.unsubscribe((BComponent)((BUser)this.getParent()));
            this.subscriber = null;
        }
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(home)) {
            BUser user = (BUser)this.getParent();
            BOrd navOrd = user.getNavFile();
            BOrd newNavOrd = null;
            newNavOrd = this.getHome().equals("/") ? DEFAULT_ENTSEC_HOME : BOrd.make((String)(MEMORY_NAV + SlotPath.escape((String)this.getHome())));
            if (newNavOrd != navOrd) {
                user.setNavFile(newNavOrd);
            }
        }
    }

    public BOrionDatabase getOrionDatabase() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        return service.getOrionDatabase();
    }

    public String convertAdminRoleToAXAdminRole(String roles) {
        if (roles.indexOf(AX_ROLE_DELIMITER) < 0) {
            if (roles.equalsIgnoreCase(N4_ADMIN_ROLE)) {
                roles = roles.replaceAll(N4_ADMIN_ROLE, AX_ADMIN_ROLE);
                return roles;
            }
        } else {
            String[] rolesNames = roles.split(AX_ROLE_DELIMITER);
            for (int i = 0; i < rolesNames.length; ++i) {
                if (!rolesNames[i].equalsIgnoreCase(N4_ADMIN_ROLE)) continue;
                rolesNames[i] = AX_ADMIN_ROLE;
            }
            roles = TextUtil.join((String[])rolesNames, (char)';');
        }
        return roles;
    }

    class RolesSubscriber
    extends Subscriber {
        RolesSubscriber() {
        }

        public void event(BComponentEvent event) {
            if (event.getSourceComponent() instanceof BUser) {
                BUser userSrc = (BUser)event.getSourceComponent();
                if (event.getId() == 0 && event.getSlotName().equals(BUser.roles.getName())) {
                    String roles = userSrc.getRoles();
                    roles = roles.replaceAll(BEntsecUserConfig.N4_ROLE_DELIMITER, BEntsecUserConfig.AX_ROLE_DELIMITER);
                    roles = BEntsecUserConfig.this.convertAdminRoleToAXAdminRole(roles);
                    BEntsecUserConfig.this.setRoles(roles);
                }
            }
        }
    }
}

