/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class ThreatLevelUtil {
    public static final String NO_THREAT_LEVEL_REPLICATION_REQUIRED = "noThreatRequired";
    private static final Lexicon lex = Lexicon.make(ThreatLevelUtil.class);
    public static final int THREAT_LEVEL_MAX_DEPTH = 5;
    public static final int OLD_THREAT_LEVEL_MAX_NAME_SIZE = 64;
    public static final int THREAT_LEVEL_MAX_NAME_SIZE = 49;
    public static final int THREAT_LEVEL_MAX = 255;
    public static final int THREAT_LEVEL_MIN = 0;
    public static final int NO_THREAT_LEVEL_ASSIGNMENT = -1;
    public static final int NO_THREAT_LEVEL_JOIN_ASSIGNMENT = -1;
    public static final int THREAT_LEVEL_DEFAULT = 5;
    public static final BEnumRange DEFAULT_RANGE = BEnumRange.make((int[])new int[]{0, 5, 10}, (String[])new String[]{SlotPath.escape((String)lex.getText("threatLevelLow.displayName")), SlotPath.escape((String)lex.getText("threatLevelNormal.displayName")), SlotPath.escape((String)lex.getText("threatLevelHigh.displayName"))});

    public static void checkRename(BComponent c, Property p, String newName, Context cx) {
        if (!c.isRunning()) {
            return;
        }
        if (c.get(p) instanceof BThreatLevelGroup) {
            ThreatLevelUtil.checkName(newName);
            ThreatLevelUtil.checkPath(c, newName);
        }
    }

    public static void checkPath(BComponent parent, String newName) {
        int startIndex;
        String parentPath = MappingSupport.getDisplayPath((BObject)parent);
        String predictedDisplayPath = parentPath + "/" + SlotPath.unescape((String)newName);
        String predictedPath = predictedDisplayPath.substring(startIndex = "/Services/EnterpriseSecurityService/threatLevelGroups".length()) + "/";
        if (predictedPath.length() > BThreatLevelGroupRec.MAX_PATH_LENGTH) {
            throw new IllegalStateException("Illegal Path: Threat Level Group path of " + predictedPath.length() + " is longer than " + BThreatLevelGroupRec.MAX_PATH_LENGTH + ".");
        }
    }

    public static void checkName(String name) {
        if (name.indexOf(SlotPath.escape((String)"/")) > -1) {
            throw new IllegalStateException("Illegal Name: Threat Level Group Names cannot contain '/'");
        }
        if (name.indexOf("threatLevelGroups") > -1) {
            throw new IllegalStateException("Illegal Name: Threat Level Group cannot be named 'threatLevelGroups'");
        }
        if (name.length() > 49) {
            throw new IllegalStateException("Illegal Name: Threat Level Group Name length of " + name.length() + " cannot be longer than " + 49 + " characters");
        }
    }

    public static int getChildDepth(BThreatLevelGroup group, int depth) {
        Object[] children = group.getChildren(BThreatLevelGroup.class);
        if (children.length == 0) {
            return depth;
        }
        int maxDepth = ++depth;
        for (int i = 0; i < children.length; ++i) {
            int childDepth = ThreatLevelUtil.getChildDepth((BThreatLevelGroup)((Object)children[i]), depth);
            if (childDepth <= maxDepth) continue;
            maxDepth = childDepth;
        }
        return maxDepth;
    }

    public static void checkAdd(BComponent c, String name, BValue value, int flags, BFacets facets, Context context) {
        if (!c.isRunning()) {
            return;
        }
        if (value instanceof BThreatLevelGroup) {
            BComponent services;
            ThreatLevelUtil.checkName(name);
            ThreatLevelUtil.checkPath(c, name);
            int count = 2;
            count = ThreatLevelUtil.getChildDepth((BThreatLevelGroup)value, count);
            BComplex parent = c.getParent();
            while (parent instanceof BThreatLevelGroup) {
                ++count;
                parent = parent.getParent();
            }
            if (count > 5) {
                throw new IllegalStateException("Threat Level Groups cannot be nested more than 5 deep.");
            }
            Feature entsecFeature = Sys.getLicenseManager().checkFeature("tridium", "entSecurity");
            String threatGroupLimit = entsecFeature.get("threatGroup.limit");
            if (threatGroupLimit == null) {
                if (context == Context.decoding) {
                    Logger.getLogger("entsec").warning("Threat Level Groups are not licensed");
                } else {
                    throw new LocalizableRuntimeException("entsec", "Threat Level Groups are not licensed");
                }
            }
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            if (((BThreatLevelGroup)value).service == null) {
                int currentThreatGroups = (Integer)service.fw(503, "threatGroup.limit", null, null, null);
                if (!threatGroupLimit.equals("none") && currentThreatGroups >= Integer.parseInt(threatGroupLimit)) {
                    if (context == Context.decoding) {
                        BEnterpriseSecurityService.LOG.warning("Threat Group Limit (" + threatGroupLimit + ") exceeded");
                    } else {
                        throw new LocalizableRuntimeException("entsec", "Threat Group Limit (" + threatGroupLimit + ") exceeded");
                    }
                }
            }
            if (!service.getName().equals("EnterpriseSecurityService")) {
                service.getParent().asComponent().rename(service.getPropertyInParent(), "EnterpriseSecurityService");
            }
            if (!(services = (BComponent)service.getParent()).getName().equals("Services")) {
                services.getParent().asComponent().rename(services.getPropertyInParent(), "Services");
            }
        }
    }
}

