/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.ThreatLevelUtil;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;

public class BThreatLevelSetup
extends BComponent
implements BIAlarmSource,
BIService {
    public static final Property activationInitiatedAlert = BThreatLevelSetup.newProperty((int)0, (BValue)BThreatLevelSetup.initAlarmSourceInfo(), null);
    public static final Property activationFailureAlert = BThreatLevelSetup.newProperty((int)0, (BValue)BThreatLevelSetup.initAlarmSourceInfo(), null);
    public static final Property activationCompleteAlert = BThreatLevelSetup.newProperty((int)0, (BValue)BThreatLevelSetup.initAlarmSourceInfo(), null);
    public static final Property activationMismatchAlert = BThreatLevelSetup.newProperty((int)0, (BValue)BThreatLevelSetup.initAlarmSourceInfo(), null);
    public static final Property threatLevelRange = BThreatLevelSetup.newProperty((int)8, (BValue)ThreatLevelUtil.DEFAULT_RANGE, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ThreatLevelRangeFE"));
    public static final Property threatReplicationRequired = BThreatLevelSetup.newProperty((int)7, (boolean)true, null);
    public static final Action ackAlarm = BThreatLevelSetup.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action submit = BThreatLevelSetup.newAction((int)2052, (BValue)new BThreatLevelActivationJob(), null);
    public static final Type TYPE = Sys.loadType(BThreatLevelSetup.class);
    public static final BIcon ICON = BThreatLevelGroupRec.ICON;
    private BUuid lastJobUuid = BUuid.DEFAULT;
    private Object lock = new Object();
    private AlarmSupport activationInitiatedSupport;
    private AlarmSupport activationFailureSupport;
    private AlarmSupport activationCompleteSupport;
    private AlarmSupport activationMismatchSupport;

    public BAlarmSourceInfo getActivationInitiatedAlert() {
        return (BAlarmSourceInfo)this.get(activationInitiatedAlert);
    }

    public void setActivationInitiatedAlert(BAlarmSourceInfo v) {
        this.set(activationInitiatedAlert, (BValue)v, null);
    }

    public BAlarmSourceInfo getActivationFailureAlert() {
        return (BAlarmSourceInfo)this.get(activationFailureAlert);
    }

    public void setActivationFailureAlert(BAlarmSourceInfo v) {
        this.set(activationFailureAlert, (BValue)v, null);
    }

    public BAlarmSourceInfo getActivationCompleteAlert() {
        return (BAlarmSourceInfo)this.get(activationCompleteAlert);
    }

    public void setActivationCompleteAlert(BAlarmSourceInfo v) {
        this.set(activationCompleteAlert, (BValue)v, null);
    }

    public BAlarmSourceInfo getActivationMismatchAlert() {
        return (BAlarmSourceInfo)this.get(activationMismatchAlert);
    }

    public void setActivationMismatchAlert(BAlarmSourceInfo v) {
        this.set(activationMismatchAlert, (BValue)v, null);
    }

    public BEnumRange getThreatLevelRange() {
        return (BEnumRange)this.get(threatLevelRange);
    }

    public void setThreatLevelRange(BEnumRange v) {
        this.set(threatLevelRange, (BValue)v, null);
    }

    public boolean getThreatReplicationRequired() {
        return this.getBoolean(threatReplicationRequired);
    }

    public void setThreatReplicationRequired(boolean v) {
        this.setBoolean(threatReplicationRequired, v, null);
    }

    public BBoolean ackAlarm(BAlarmRecord arg) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)arg, null);
    }

    public BOrd submit(BThreatLevelActivationJob arg) {
        return (BOrd)this.invoke(submit, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void started() throws Exception {
        super.started();
        this.activationInitiatedSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationInitiatedAlert());
        this.activationFailureSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationFailureAlert());
        this.activationCompleteSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationCompleteAlert());
        this.activationMismatchSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationMismatchAlert());
    }

    public Type[] getServiceTypes() {
        if (BEnterpriseSecurityService.isThreatAvailable()) {
            return new Type[]{TYPE};
        }
        return new Type[0];
    }

    public void serviceStarted() {
    }

    public void serviceStopped() {
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(threatLevelRange)) {
            if (RemoteUtil.isSupervisor()) {
                BReplicationService service = (BReplicationService)Sys.getService((Type)BReplicationService.TYPE);
                service.schedule(BBoolean.make((boolean)false));
            }
        } else if (p.equals(activationInitiatedAlert)) {
            this.activationInitiatedSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationInitiatedAlert());
        } else if (p.equals(activationFailureAlert)) {
            this.activationFailureSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationFailureAlert());
        } else if (p.equals(activationCompleteAlert)) {
            this.activationCompleteSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationCompleteAlert());
        } else if (p.equals(activationMismatchAlert)) {
            this.activationMismatchSupport = new AlarmSupport((BIAlarmSource)this, this.getActivationMismatchAlert());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrd doSubmit(BThreatLevelActivationJob remoteJob, Context cx) {
        Object object = this.lock;
        synchronized (object) {
            if (!remoteJob.getJobUuid().equals((Object)BUuid.DEFAULT)) {
                if (remoteJob.getJobUuid().equals((Object)this.lastJobUuid)) {
                    return null;
                }
                this.lastJobUuid = remoteJob.getJobUuid();
            }
        }
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        return jobService.submit((BJob)remoteJob, null);
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toNormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.sourceName, 4);
        asi.setSourceName(BFormat.make((String)"%parent.displayName%"));
        return asi;
    }

    public BBoolean doAckAlarm(BAlarmRecord rec) {
        try {
            return BBoolean.make((this.activationInitiatedSupport.ackAlarm(rec) || this.activationFailureSupport.ackAlarm(rec) || this.activationCompleteSupport.ackAlarm(rec) || this.activationMismatchSupport.ackAlarm(rec) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void generateActivationInitiatedAlert(String sourceName, String msg) {
        try {
            this.activationInitiatedSupport.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)sourceName)));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void generateActivationFailureAlert(String sourceName, String msg) {
        try {
            this.activationFailureSupport.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)sourceName)));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void generateActivationCompleteAlert(String sourceName, String msg) {
        try {
            this.activationCompleteSupport.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)sourceName)));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void generateActivationMismatchAlert(String sourceName, String msg) {
        try {
            this.activationMismatchSupport.newAlert(BFacets.make((String)"msgText", (BIDataValue)BString.make((String)msg), (String)"sourceName", (BIDataValue)BString.make((String)sourceName)));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void setLastJobUuid(BUuid uuid) {
        this.lastJobUuid = uuid;
    }
}

