/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.Index;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BSubSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.orionTools.BIHierarchyObject;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.EntsecTenantUtil;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.threat.BMappedThreatLevelGroupExt;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelGroupRecs;
import com.tridiumx.entsec.threat.BThreatLevelStationJoin;
import java.io.Serializable;
import java.util.Comparator;
import java.util.logging.Level;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BProjection;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BBinaryExpression;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Predicates;
import javax.baja.rdb.ddl.BClustered;
import javax.baja.space.Mark;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

public class BThreatLevelGroupRec
extends BReplicableObject
implements BITenantObject,
BIOrdMappable,
BIHierarchyObject {
    public static final int OLD_MAX_PATH_LENGTH = 326;
    public static final int MAX_PATH_LENGTH = Integer.getInteger("niagara.entsec.threadLevelGroupRec.maxPathLength", 255);
    public static final Property uuid = BThreatLevelGroupRec.newProperty((int)1, (BValue)BUuid.DEFAULT, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property stationName = BThreatLevelGroupRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property threatLevelGroupName = BThreatLevelGroupRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)49), (BFacets)BFacets.make((String)"displayId", (boolean)true)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property path = BThreatLevelGroupRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)MAX_PATH_LENGTH), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property threatLevelGroupDisplayPath = BThreatLevelGroupRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)390));
    public static final Property activeLevel = BThreatLevelGroupRec.newProperty((int)9, (BValue)BThreatLevelEntry.DEFAULT, (BFacets)BFacets.make((String)"indexed", (boolean)true));
    public static final Property defaultAccessRightThreatLevel = BThreatLevelGroupRec.newProperty((int)9, (BValue)BThreatLevelEntry.DEFAULT, null);
    public static final Property tenant = BThreatLevelGroupRec.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)), (BFacets)BFacets.make((String)"dbSourced", (boolean)true)));
    private static final Index[] INDEXES = new Index[]{new Index("PathIndex", false, BClustered.unspecified, new Property[]{threatLevelGroupName, path}, new boolean[2])};
    public static final Type TYPE = Sys.loadType(BThreatLevelGroupRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.std((String)"warning.png");
    static Lexicon lex = Lexicon.make(BThreatLevelGroupRec.class);
    BThreatLevelGroupRec reliableInstance;

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    @Override
    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getThreatLevelGroupName() {
        return this.getString(threatLevelGroupName);
    }

    public void setThreatLevelGroupName(String v) {
        this.setString(threatLevelGroupName, v, null);
    }

    public String getPath() {
        return this.getString(path);
    }

    public void setPath(String v) {
        this.setString(path, v, null);
    }

    public String getThreatLevelGroupDisplayPath() {
        return this.getString(threatLevelGroupDisplayPath);
    }

    public void setThreatLevelGroupDisplayPath(String v) {
        this.setString(threatLevelGroupDisplayPath, v, null);
    }

    public BThreatLevelEntry getActiveLevel() {
        return (BThreatLevelEntry)this.get(activeLevel);
    }

    public void setActiveLevel(BThreatLevelEntry v) {
        this.set(activeLevel, (BValue)v, null);
    }

    public BThreatLevelEntry getDefaultAccessRightThreatLevel() {
        return (BThreatLevelEntry)this.get(defaultAccessRightThreatLevel);
    }

    public void setDefaultAccessRightThreatLevel(BThreatLevelEntry v) {
        this.set(defaultAccessRightThreatLevel, (BValue)v, null);
    }

    @Override
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    public StationsCursor getStations(OrionSession session) {
        return new StationsCursor(session.select(BThreatLevelStationJoin.ORION_TYPE, new PropertyValue(BThreatLevelStationJoin.threatLevelGroup, (BValue)BRef.make((BIOrionObject)this))));
    }

    public Index[] getIndexes() {
        return INDEXES;
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        if (!session.getFacets().getb(Replicator.REPLICATING, false) && !BEnterpriseSecurityService.isWorkstation()) {
            BThreatLevelStationJoin stationJoin = new BThreatLevelStationJoin();
            stationJoin.setThreatLevelGroup(BRef.make((BIOrionObject)this));
            stationJoin.setStationName(Sys.getStation().getStationName());
            session.insert((BIOrionObject)stationJoin);
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertThreatLevelGroupRec(this);
        BThreatLevelGroupRec.ensureHierarchy(this, session);
        BEnterpriseSecurityService.threatReplicationRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureHierarchy(BThreatLevelGroupRec rec, OrionSession session) {
        if (!session.getFacets().getb(Replicator.REPLICATING, false)) {
            return;
        }
        BAccessControlService.LOG.fine("ensureHierarchy" + rec.getPath());
        try {
            BThreatLevelGroup group = (BThreatLevelGroup)rec.getMappedOrd().get();
            BUuid uuid = MappingSupport.getMappedUuid(group);
            if (!rec.getUuid().equals((Object)uuid)) {
                BAccessControlService.LOG.fine("fix uuid:" + rec.getUuid() + " != " + uuid);
                MappingSupport.setMappedUuid(group, rec.getUuid());
                BThreatLevelGroupRec deleteRec = new BThreatLevelGroupRec();
                deleteRec.setUuid(uuid);
                session.delete((BIOrionObject)deleteRec);
            }
            if (group.getDefaultAccessRightThreatLevel() != rec.getDefaultAccessRightThreatLevel()) {
                group.setDefaultAccessRightThreatLevel(rec.getDefaultAccessRightThreatLevel());
            }
            BAccessControlService.LOG.fine("group is available: " + rec.getPath());
            return;
        }
        catch (Exception e) {
            BAccessControlService.LOG.fine("Group does not exist: " + rec.getPath());
            String parentPath = rec.getParentPath();
            if (parentPath.equals("/")) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                BThreatLevelGroupRecs parent = service.getThreatLevelGroups();
                parent.add(SlotPath.escape((String)rec.getThreatLevelGroupName()), (BValue)rec.mapToNewComponent());
                return;
            }
            BThreatLevelGroupRec parentRec = rec.getParentRec(session);
            BAccessControlService.LOG.fine("ensureHierarchy.parentRec: " + (parentRec != null));
            if (parentRec != null) {
                try {
                    BComponent parent = (BComponent)rec.getMappedParentOrd().get();
                    parent.add(rec.getThreatLevelGroupName(), (BValue)rec.mapToNewComponent());
                }
                catch (Exception e2) {
                    BAccessControlService.LOG.log(Level.FINE, "parent group does not exist" + parentPath, e2);
                    BThreatLevelGroupRec.ensureHierarchy(parentRec, session);
                }
            } else if (RemoteUtil.isSubordinate()) {
                BNiagaraStation supervisor = RemoteUtil.getSupervisorStation();
                BFoxSession foxSession = RemoteUtil.getFoxSession(supervisor);
                try {
                    foxSession.engageNoRetry(rec.getUuid().toString());
                    BEnterpriseSecurityService remoteService = (BEnterpriseSecurityService)foxSession.getService(BEnterpriseSecurityService.TYPE);
                    remoteService.lease();
                    OrionSession remoteSession = null;
                    try {
                        remoteSession = remoteService.createSession(null);
                        BThreatLevelGroupRec recCopy = (BThreatLevelGroupRec)rec.newCopy();
                        BAccessControlService.LOG.fine("ensureHierarchy.parentPath: " + parentPath);
                        if (!parentPath.equals("/")) {
                            parentRec = recCopy.getParentRec(remoteSession);
                            BThreatLevelGroupRec parentRecCopy = (BThreatLevelGroupRec)parentRec.newCopy();
                            BAccessControlService.LOG.fine("ensureHierarchy.insertParent: " + parentRecCopy.getPath());
                            session.persist((BIOrionObject)parentRecCopy);
                            try {
                                BComponent parent = (BComponent)rec.getMappedParentOrd().get();
                                parent.add(rec.getThreatLevelGroupName(), (BValue)rec.mapToNewComponent());
                            }
                            catch (Exception e3) {
                                BAccessControlService.LOG.fine("parent group does not exist on subordinate:" + parentRec.getPath());
                                BThreatLevelGroupRec.ensureHierarchy(parentRec, session);
                            }
                        }
                        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                        BThreatLevelGroupRecs parent = service.getThreatLevelGroups();
                        parent.add(rec.getThreatLevelGroupName(), (BValue)rec.mapToNewComponent());
                    }
                    finally {
                        if (remoteSession != null) {
                            remoteSession.close();
                            remoteSession = null;
                        }
                    }
                }
                catch (Exception e4) {
                    throw new BajaRuntimeException(e4.getMessage(), (Throwable)e4);
                }
                finally {
                    foxSession.disengage(rec.getUuid().toString());
                }
            } else {
                throw new BajaRuntimeException("Hierarchy Cannot be established for " + rec.getPath());
            }
            return;
        }
    }

    @Override
    public boolean beforeInsert(OrionSession session) {
        this.setStationName(Sys.getStation().getStationName());
        return super.beforeInsert(session);
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        if (session.getFacets().getb(Replicator.REPLICATING, false)) {
            BThreatLevelGroupRec databaseInstance = (BThreatLevelGroupRec)session.read((BIOrionObject)this.newCopy());
            if (databaseInstance == null) {
                return false;
            }
            this.reliableInstance = databaseInstance;
            if (!this.reliableInstance.getActiveLevel().equals((Object)this.getActiveLevel())) {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                service.getThreatLevelSetup().generateActivationMismatchAlert(this.toDisplayString(null), lex.getText("activationJob.activationMismatch", new Object[]{this.reliableInstance.getActiveLevel(), this.getActiveLevel()}));
                return false;
            }
        }
        this.setStationName(Sys.getStation().getStationName());
        return super.beforeUpdate(session);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        if (session.getFacets().getb(Replicator.REPLICATING, false) && !this.reliableInstance.getMappedOrd().equals((Object)this.getMappedOrd())) {
            BAccessControlService.LOG.fine("mapped ord mismatch: " + this.reliableInstance.getMappedOrd() + "!= " + this.getMappedOrd());
            try {
                BThreatLevelGroup reliableGroup = (BThreatLevelGroup)this.reliableInstance.getMappedOrd().get();
                BComponent reliableGroupParent = reliableGroup.getParent().asComponent();
                String mappedOrd = this.getMappedOrd().toString();
                String parentMappedOrd = mappedOrd.substring(0, mappedOrd.lastIndexOf(47));
                BComponent newParent = BOrd.make((String)parentMappedOrd).get().asComponent();
                if (newParent == reliableGroupParent) {
                    reliableGroupParent.asComponent().rename(reliableGroup.getPropertyInParent(), SlotPath.escape((String)this.getThreatLevelGroupName()));
                } else {
                    Mark mark = new Mark((BObject)reliableGroup);
                    mark.moveTo((BObject)newParent, null);
                    if (reliableGroupParent instanceof BThreatLevelGroup) {
                        BThreatLevelGroupRec reliableParent = (BThreatLevelGroupRec)session.mappedRead((BObject)reliableGroupParent);
                        reliableParent.deleteIfNoLongerValidOnSubordinate(session);
                    }
                }
            }
            catch (Exception e) {
                throw new BajaRuntimeException("Cannot rename/move " + this.reliableInstance.getMappedOrd() + " to " + this.getMappedOrd(), (Throwable)e);
            }
        }
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateThreatLevelGroupRec(this);
        BThreatLevelGroupRec.ensureHierarchy(this, session);
        BEnterpriseSecurityService.threatReplicationRequired();
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        OrionCursor c;
        if (!super.beforeDelete(session)) {
            return false;
        }
        BThreatLevelGroupRec databaseInstance = (BThreatLevelGroupRec)session.read((BIOrionObject)this.newCopy());
        if (databaseInstance == null) {
            return false;
        }
        this.reliableInstance = databaseInstance;
        BEnterpriseSecurityService.threatReplicationRequired();
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteThreatLevelGroupRec(session, this.reliableInstance);
        MergeSupport.setReferencesToNull((BIOrionObject)this, session);
        if (!BEnterpriseSecurityService.isWorkstation()) {
            c = session.select(BThreatLevelBadgeJoin.ORION_TYPE, new PropertyValue(BThreatLevelBadgeJoin.threatLevelGroup, (BValue)BRef.make((BIOrionObject)this)));
            while (c.next()) {
                session.delete((BIOrionObject)c.get());
            }
        }
        c = session.select(BThreatLevelStationJoin.ORION_TYPE, new PropertyValue(BThreatLevelStationJoin.threatLevelGroup, (BValue)BRef.make((BIOrionObject)this)));
        while (c.next()) {
            BThreatLevelStationJoin stationJoin = (BThreatLevelStationJoin)((Object)c.get());
            if (stationJoin.getStationName().equals(Sys.getStation().getStationName())) continue;
            session.delete((BIOrionObject)stationJoin);
        }
        return true;
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BOrd ord = this.reliableInstance.getMappedOrd();
        try {
            BThreatLevelGroup group = (BThreatLevelGroup)ord.get();
            group.getParent().asComponent().remove(group.getPropertyInParent());
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }

    public void mapFrom(BObject source) {
        BThreatLevelGroup threatLevelGroup = (BThreatLevelGroup)source;
        BMappedThreatLevelGroupExt ext = (BMappedThreatLevelGroupExt)threatLevelGroup.getMixIn(BMappedThreatLevelGroupExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setLastModified(BAbsTime.now());
        if (Sys.getStation() != null) {
            this.setStationName(Sys.getStation().getStationName());
        } else if (threatLevelGroup.getSession() instanceof BFoxSession) {
            this.setStationName(((BFoxSession)threatLevelGroup.getSession()).getStationName());
        }
        this.setActiveLevel(threatLevelGroup.getActiveLevel());
        this.setDefaultAccessRightThreatLevel(threatLevelGroup.getDefaultAccessRightThreatLevel());
        if (threatLevelGroup.isRunning() || threatLevelGroup.getSession() instanceof BFoxSession) {
            String displayName = threatLevelGroup.getName();
            if (displayName == null) {
                throw new IllegalStateException("need a name when is running");
            }
            this.setThreatLevelGroupName(SlotPath.unescape((String)displayName));
            this.setSlotPathOrd(source);
            int startIndex = "/Services/EnterpriseSecurityService/threatLevelGroups".length();
            this.setPath(this.getMappedDisplayPath().substring(startIndex) + "/");
        }
    }

    public BComponent mapToNewComponent() {
        BThreatLevelGroup group = new BThreatLevelGroup();
        group.setActiveLevel(this.getActiveLevel());
        group.setDefaultAccessRightThreatLevel(this.getDefaultAccessRightThreatLevel());
        MappingSupport.addMappedExt(group, this.getUuid());
        return group;
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setThreatLevelGroupDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getThreatLevelGroupDisplayPath();
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    public String toDisplayString(Context cx) {
        if (cx != null && cx.getFacets().getb("hierarchyDisplay", false)) {
            return this.getThreatLevelGroupName();
        }
        int length = this.getPath().length();
        if (length == 0) {
            return "";
        }
        return this.getPath().substring(1, length - 1);
    }

    @Override
    public BIOrionObject[] getParentObjects(OrionSession session) {
        try {
            BThreatLevelGroup group = (BThreatLevelGroup)this.getMappedOrd().get();
            Array a = new Array(BIOrionObject.class);
            while (group.getParent() instanceof BThreatLevelGroup) {
                a.add(0, (Object)session.mappedRead((BObject)group.getParent()));
                group = (BThreatLevelGroup)group.getParent();
            }
            return (BIOrionObject[])a.trim();
        }
        catch (Exception e) {
            return new BIOrionObject[0];
        }
    }

    @Override
    public BIOrionObject[] getChildObjects(OrionSession session) {
        try {
            BThreatLevelGroup group = (BThreatLevelGroup)this.getMappedOrd().get();
            BThreatLevelGroup[] children = (BThreatLevelGroup[])group.getChildren(BThreatLevelGroup.class);
            BIOrionObject[] os = new BIOrionObject[children.length];
            for (int i = 0; i < children.length; ++i) {
                os[i] = session.mappedRead((BObject)children[i]);
            }
            return os;
        }
        catch (Exception e) {
            return new BIOrionObject[0];
        }
    }

    @Override
    public BIOrionObject[] getTopLevelHierarchyObjects(OrionSession session) {
        BEnterpriseSecurityService service = null;
        BThreatLevelGroupRecs groups = null;
        if (session instanceof DbOrionSession) {
            service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            groups = service.getThreatLevelGroups();
        } else if (session instanceof FoxOrionSession) {
            BFoxOrionDatabase db = (BFoxOrionDatabase)session.getOrionDatabase();
            service = (BEnterpriseSecurityService)((BFoxOrionSpace)db.getOrionSpace()).getFoxSession().getService(BEnterpriseSecurityService.TYPE);
            service.lease();
            groups = service.getThreatLevelGroups();
            groups.lease();
        }
        BThreatLevelGroup[] children = (BThreatLevelGroup[])groups.getChildren(BThreatLevelGroup.class);
        Array a = new Array(BIOrionObject.class);
        for (int i = 0; i < children.length; ++i) {
            BOrionObject read = (BOrionObject)session.mappedRead((BObject)children[i]);
            if (EntsecTenantUtil.isMissingTenant((BComponent)read, (Context)session)) continue;
            a.add((Object)read);
        }
        return (BIOrionObject[])a.trim();
    }

    public BOrd getMappedParentOrd() {
        String mappedOrd = this.getMappedOrd().toString();
        int index = mappedOrd.lastIndexOf("/" + SlotPath.escape((String)this.getThreatLevelGroupName()));
        if (index == -1) {
            throw new BajaRuntimeException("invalid mapped ord:" + mappedOrd);
        }
        return BOrd.make((String)mappedOrd.substring(0, index));
    }

    public String getParentPath() {
        String path = this.getPath();
        int index = path.lastIndexOf("/" + this.getThreatLevelGroupName() + "/");
        if (index == -1) {
            throw new BajaRuntimeException("invalid path: " + path);
        }
        return path.substring(0, index + 1);
    }

    public BThreatLevelGroupRec getParentRec(OrionSession session) {
        OrionCursor c = session.select(ORION_TYPE, new PropertyValue(path, (BValue)BString.make((String)this.getParentPath())));
        if (c.next()) {
            return (BThreatLevelGroupRec)c.get();
        }
        return null;
    }

    public String[] getParentPaths() {
        String[] paths = TextUtil.split((String)this.toDisplayString(null), (char)'/');
        String[] parentPaths = new String[paths.length - 1];
        String current = "/";
        for (int i = 0; i < parentPaths.length; ++i) {
            parentPaths[i] = current = current + paths[i] + "/";
        }
        return parentPaths;
    }

    public void deleteIfNoLongerValidOnSubordinate(OrionSession session) throws Exception {
        boolean validOnSubordinate = this.validOnSubordinate(session);
        BEnterpriseSecurityService.LOG.fine("checking " + this.toDisplayString(null) + " for validOnSubordiante:" + validOnSubordinate);
        if (!validOnSubordinate) {
            try {
                BThreatLevelGroup group = (BThreatLevelGroup)this.getMappedOrd().get();
                group.getParent().asComponent().remove(group.getPropertyInParent());
            }
            catch (Exception group) {
                // empty catch block
            }
            BThreatLevelGroupRec parent = this.getParentRec(session);
            if (parent != null) {
                parent.deleteIfNoLongerValidOnSubordinate(session);
            }
        }
    }

    public boolean validOnSubordinate(OrionSession session) throws Exception {
        BSqlQuery recsQuery = BSqlQuery.make((OrionType)ORION_TYPE);
        BSqlField field = new BSqlField(ORION_TYPE, path);
        BProjection projection = new BProjection();
        projection.add(SqlColumns.make((OrionType)ORION_TYPE, (Property)uuid));
        recsQuery.select(projection);
        recsQuery.where(Predicates.like((BExpression)field, (BString)BString.make((String)(this.getPath() + "%"))));
        BSqlQuery accessRightQuery = BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE);
        BSqlField field2 = new BSqlField(BAccessRight.ORION_TYPE, BAccessRight.threatLevelGroup);
        BListExpression listExpression = new BListExpression();
        listExpression.add((BExpression)new BSubSqlQuery(recsQuery));
        BBinaryExpression e = Exprs.binary((BExpression)field2, (String)"IN", (BExpression)listExpression);
        accessRightQuery.where((BExpression)e);
        int count = CountingUtil.getCount((BQuery)accessRightQuery, (OrionSession)session);
        if (count > 0) {
            BEnterpriseSecurityService.LOG.fine("cannot delete, has access right assignment:" + this.getThreatLevelGroupName());
            return true;
        }
        BSqlQuery stationQuery = BSqlQuery.make((OrionType)BThreatLevelStationJoin.ORION_TYPE);
        field2 = new BSqlField(BThreatLevelStationJoin.ORION_TYPE, BThreatLevelStationJoin.threatLevelGroup);
        listExpression = new BListExpression();
        listExpression.add((BExpression)new BSubSqlQuery((BSqlQuery)recsQuery.newCopy()));
        e = Exprs.binary((BExpression)field2, (String)"IN", (BExpression)listExpression);
        stationQuery.where((BExpression)e);
        count = CountingUtil.getCount((BQuery)stationQuery, (OrionSession)session);
        if (count > 0) {
            BEnterpriseSecurityService.LOG.fine("cannot delete, has station assignment:" + this.getThreatLevelGroupName());
            return true;
        }
        BEnterpriseSecurityService.LOG.fine("can be deleted" + this.getThreatLevelGroupName() + "!");
        return false;
    }

    public static class LastTimeFilter
    implements IFilter {
        BAbsTime time;

        public LastTimeFilter(BAbsTime time) {
            this.time = time;
        }

        public boolean accept(Object obj) {
            BThreatLevelGroupRec rec = (BThreatLevelGroupRec)obj;
            return rec.getLastModified().isAfter(this.time);
        }
    }

    public static class PathCompare
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        public int compare(Object o1, Object o2) {
            BThreatLevelGroupRec threat1 = (BThreatLevelGroupRec)o1;
            BThreatLevelGroupRec threat2 = (BThreatLevelGroupRec)o2;
            int i1 = threat1.getPath().length();
            int i2 = threat2.getPath().length();
            return i1 - i2;
        }
    }

    public static class StationsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private StationsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BThreatLevelStationJoin getThreatLevelStationJoin() {
            return (BThreatLevelStationJoin)((Object)this.cursor.get());
        }
    }
}

