/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroupRecs;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import com.tridiumx.entsec.threat.ThreatLevelUtil;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BThreatLevelGroup
extends BComponent {
    public static final Property status = BThreatLevelGroup.newProperty((int)7, (BValue)BStatus.ok, null);
    public static final Property activeLevel = BThreatLevelGroup.newProperty((int)9, (BValue)BThreatLevelEntry.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property defaultAccessRightThreatLevel = BThreatLevelGroup.newProperty((int)8, (BValue)BThreatLevelEntry.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE"));
    public static final Property activeOrdinal = BThreatLevelGroup.newProperty((int)3, (int)0, null);
    public static final Action activateThreatLevel = BThreatLevelGroup.newAction((int)0, (BValue)BThreatLevelEntry.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BThreatLevelGroup.class);
    public static final BIcon ICON = BIcon.std((String)"warning.png");
    BEnterpriseSecurityService service = null;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public BThreatLevelEntry getActiveLevel() {
        return (BThreatLevelEntry)this.get(activeLevel);
    }

    public void setActiveLevel(BThreatLevelEntry v) {
        this.set(activeLevel, (BValue)v, null);
    }

    public BThreatLevelEntry getDefaultAccessRightThreatLevel() {
        return (BThreatLevelEntry)this.get(defaultAccessRightThreatLevel);
    }

    public void setDefaultAccessRightThreatLevel(BThreatLevelEntry v) {
        this.set(defaultAccessRightThreatLevel, (BValue)v, null);
    }

    public int getActiveOrdinal() {
        return this.getInt(activeOrdinal);
    }

    public void setActiveOrdinal(int v) {
        this.setInt(activeOrdinal, v, null);
    }

    public BOrd activateThreatLevel(BThreatLevelEntry event) {
        return (BOrd)this.invoke(activateThreatLevel, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final void started() throws Exception {
        this.fwStarted();
        this.getService();
        this.setActiveOrdinal(this.getActiveLevel().getOrdinal());
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        ThreatLevelUtil.checkAdd(this, name, value, flags, facets, context);
    }

    public void checkRename(Property p, String newName, Context cx) {
        super.checkRename(p, newName, cx);
        ThreatLevelUtil.checkRename(this, p, newName, cx);
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(activeLevel)) {
            if (cx == null || !cx.getFacets().getb(BThreatLevelActivationJob.ACTIVATE_JOB, false)) {
                this.submitActivatationJob(this.getActiveLevel(), cx);
            }
            this.setActiveOrdinal(this.getActiveLevel().getOrdinal());
        }
    }

    public BOrd doActivateThreatLevel(BThreatLevelEntry entry, Context cx) {
        return this.submitActivatationJob(entry, cx);
    }

    public void setActiveLevelFromJob(BThreatLevelEntry entry) {
        this.set(activeLevel, (BValue)entry, (Context)BThreatLevelActivationJob.ACTIVATE_JOB_FACETS);
    }

    public BOrd submitActivatationJob(BThreatLevelEntry entry, Context cx) {
        BThreatLevelActivationJob job = new BThreatLevelActivationJob(this.getSlotPathOrd(), entry, Sys.getStation().getStationName());
        BThreatLevelSetup threatLevelSetup = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
        return (BOrd)threatLevelSetup.invoke(BThreatLevelSetup.submit, (BValue)job, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        if (parent instanceof BThreatLevelGroup) {
            return true;
        }
        return parent instanceof BThreatLevelGroupRecs;
    }

    public String toDisplayString(Context cx) {
        int index = this.toDisplayPathString(cx).indexOf("/threatLevelGroups/") + "/threatLevelGroups/".length();
        return this.toDisplayPathString(cx).substring(index);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public final BEnterpriseSecurityService getService() {
        if (this.service != null) {
            return this.service;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException("Exceeded license limit");
    }

    private void fwStarted() {
        if (this.service != null) {
            return;
        }
        BEnterpriseSecurityService s = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        String licenseFault = (String)s.fw(501, "threatGroup.limit", null, null, null);
        if (licenseFault != null) {
            this.setFlags((Slot)status, this.getFlags((Slot)status) & 0xFFFFFFFB);
            this.setStatus(BStatus.make((int)2, (BFacets)BFacets.make((String)"OverLicenseLimit", (boolean)true)));
            return;
        }
        this.setFlags((Slot)status, this.getFlags((Slot)status) | 4);
        this.service = s;
    }
}

