/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.threat;

import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.threat.BThreatLevelActivationJob;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroup;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BActivationLevelInput
extends BComponent
implements BIStatus {
    public static final Property out = BActivationLevelInput.newProperty((int)-2147483381, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("active")), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("inactive"))));
    public static final Property activeThreatLevel = BActivationLevelInput.newProperty((int)8, (BValue)BThreatLevelEntry.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE"));
    public static final Property in = BActivationLevelInput.newProperty((int)0, (BValue)new BStatusBoolean(), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("active")), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("inactive"))), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PointLinkChooserFE")));
    public static final Property inactiveState = BActivationLevelInput.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)BAccessNetwork.lex.getText("open")), (BFacets)BFacets.make((String)"falseText", (String)BAccessNetwork.lex.getText("closed"))));
    public static final Type TYPE = Sys.loadType(BActivationLevelInput.class);
    private boolean active = false;

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BThreatLevelEntry getActiveThreatLevel() {
        return (BThreatLevelEntry)this.get(activeThreatLevel);
    }

    public void setActiveThreatLevel(BThreatLevelEntry v) {
        this.set(activeThreatLevel, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public boolean getInactiveState() {
        return this.getBoolean(inactiveState);
    }

    public void setInactiveState(boolean v) {
        this.setBoolean(inactiveState, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.active = this.getIn().getValue() && this.getInactiveState() || !this.getIn().getValue() && !this.getInactiveState();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(in) || p.equals(inactiveState)) {
            boolean newActive;
            boolean bl = newActive = this.getIn().getValue() && this.getInactiveState() || !this.getIn().getValue() && !this.getInactiveState();
            if (newActive != this.active) {
                this.active = newActive;
                if (this.active && Sys.atSteadyState()) {
                    this.setActiveLevel(cx);
                }
            }
            if (this.getInactiveState()) {
                this.setOut((BStatusBoolean)this.getIn().newCopy());
            } else {
                BStatusBoolean statusBoolean;
                statusBoolean.setValue(!(statusBoolean = (BStatusBoolean)this.getIn().newCopy()).getValue());
                this.setOut(statusBoolean);
            }
        }
    }

    public void setActiveLevel(Context cx) {
        if (this.getParent() instanceof BThreatLevelGroup) {
            BThreatLevelGroup group = (BThreatLevelGroup)this.getParent();
            String auditString = BEnterpriseSecurityService.lex.getText("inputAuthorization", new Object[]{this.toDisplayPathString(null)});
            BThreatLevelSetup threatLevelSetup = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
            threatLevelSetup.invoke(BThreatLevelSetup.submit, (BValue)new BThreatLevelActivationJob(group.getSlotPathOrd(), this.getActiveThreatLevel(), Sys.getStation().getStationName(), auditString), cx);
        }
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }
}

