/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.ui.query;

import com.tridium.query.BProjCol;
import com.tridiumx.entsec.securityUtil.ui.query.BWbQueryConfig;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSubject;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public class BQueryColumnTable
extends BTable {
    public static final Type TYPE = Sys.loadType(BQueryColumnTable.class);

    public BQueryColumnTable(TableModel model) {
        super(model);
        this.setController(new Controller());
    }

    public CommandArtifact doDelete() {
        ((BWbQueryConfig.ColumnModel)this.getModel()).deleteSelection();
        return null;
    }

    public Type getType() {
        return TYPE;
    }

    private class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BQueryColumnTable.this, BWidget.TYPE.getModule(), "commands.delete");
        }

        public CommandArtifact doInvoke() {
            return BQueryColumnTable.this.doDelete();
        }
    }

    private class ConfigureCommand
    extends Command {
        public ConfigureCommand() {
            super((BWidget)BQueryColumnTable.this, TYPE.getModule(), "command.configureColumn");
        }

        public CommandArtifact doInvoke() {
            BQueryColumnTable table = BQueryColumnTable.this;
            int[] queryion = table.getSelection().getRows();
            BProjCol col = (BProjCol)table.getModel().getSubject(queryion[0]);
            BWbFieldEditor aliasEd = BWbFieldEditor.makeFor((BObject)BString.DEFAULT);
            aliasEd.loadValue((BObject)BString.make((String)col.getAlias()));
            BGridPane propsPane = new BGridPane(2);
            propsPane.setColumnGap(5.0);
            propsPane.add("l", (BValue)new BLabel("Display Name"));
            propsPane.add("f", (BValue)aliasEd);
            int rc = BDialog.open((BWidget)BQueryColumnTable.this, (String)"Edit Column", (Object)propsPane, (int)3);
            if (rc == 2) {
                return null;
            }
            try {
                if (aliasEd.isModified()) {
                    col.setAlias(aliasEd.saveValue().toString());
                }
            }
            catch (Exception ex) {
                BDialog.error((BWidget)BQueryColumnTable.this, (String)"Error", (Object)"Cannot modify display name.", (Throwable)ex);
            }
            BQueryColumnTable.this.repaint();
            BQueryColumnTable.this.fireTableModified(null);
            return null;
        }
    }

    private class Controller
    extends TableController {
        protected BMenu makePopup(TableSubject subject) {
            BMenu menu = new BMenu();
            if (subject.getRows().length == 1) {
                menu.add("configure", (Command)new ConfigureCommand());
            }
            menu.add("delete", (Command)new DeleteCommand()).setAccelerator(BAccelerator.NULL);
            return menu;
        }
    }
}

