/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.query;

import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NProperty;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.BIQueryFilter;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

public class TypeSpecPath {
    public BTypeSpec typeSpec;
    public String path;
    public String alias;
    public BIQueryFilter defaultFilter;
    public BExpression function;
    public boolean defaultFilterActive = true;
    public static final Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(TypeSpecPath.class).getModuleName());
    public static final TypeSpecPath NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "name");
    public static final TypeSpecPath DISPLAY_NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "displayName");
    public static final TypeSpecPath TO_DISPLAY_PATH_STRING = new TypeSpecPath(BString.TYPE.getTypeSpec(), "toDisplayPathString");
    public static final TypeSpecPath PARENT_TO_DISPLAY_PATH_STRING = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parent.toDisplayPathString");
    public static final TypeSpecPath STATUS = new TypeSpecPath(BStatus.TYPE.getTypeSpec(), "status");
    public static final TypeSpecPath SLOT_PATH = new TypeSpecPath(BString.TYPE.getTypeSpec(), "slotPath");
    public static final TypeSpecPath PARENT_COMPONENT_SLOT_PATH = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parentComponent.slotPath");
    public static final TypeSpecPath PARENT_NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "parent.name");
    public static final TypeSpecPath TYPE_DISPLAY_NAME = new TypeSpecPath(BString.TYPE.getTypeSpec(), "type.displayName");
    public static final TypeSpecPath[] statics = new TypeSpecPath[]{NAME, DISPLAY_NAME, TO_DISPLAY_PATH_STRING, PARENT_TO_DISPLAY_PATH_STRING, STATUS, SLOT_PATH, PARENT_COMPONENT_SLOT_PATH, PARENT_NAME, TYPE_DISPLAY_NAME};

    public TypeSpecPath(Property p) {
        this(p.getType().getTypeSpec(), p.getName(), p.getDefaultDisplayName(null));
    }

    public TypeSpecPath(String parentPath, Property p) {
        this(p.getType().getTypeSpec(), parentPath + "." + p.getName(), p.getDefaultDisplayName(null));
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path) {
        this.setTypeSpec(typeSpec);
        this.path = path;
        this.setDefaultDisplayName(path);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias) {
        this.setTypeSpec(typeSpec);
        this.path = path;
        this.setDefaultDisplayName(path, alias);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias, BExpression function) {
        this.setTypeSpec(typeSpec);
        this.function = function;
        this.path = path;
        this.setDefaultDisplayName(path, alias);
    }

    public TypeSpecPath(BTypeSpec typeSpec, String path, String alias, BIQueryFilter defaultFilter) {
        this.setTypeSpec(typeSpec);
        this.defaultFilter = defaultFilter;
        this.setDefaultDisplayName(path, alias);
    }

    public static TypeSpecPath make(BTypeSpec typeSpec, String path) {
        Type type = typeSpec.getResolvedType();
        Property prop = TypeSpecPath.getFrozenProperty(typeSpec, path);
        if (prop != null) {
            return new TypeSpecPath(prop);
        }
        for (int i = 0; i < statics.length; ++i) {
            if (!TypeSpecPath.statics[i].path.equals(path)) continue;
            return statics[i];
        }
        return new TypeSpecPath(typeSpec, path);
    }

    public static Property getFrozenProperty(BTypeSpec typeSpec, String path) {
        Type type = typeSpec.getResolvedType();
        if (type.isAbstract()) {
            if (type instanceof ComplexType) {
                ComplexType complexType = (ComplexType)type;
                NProperty[] props = complexType.getFrozenProperties();
                for (int i = 0; i < props.length; ++i) {
                    if (!props[i].getName().equals(path)) continue;
                    return props[i];
                }
            }
        } else {
            BObject instance = type.getInstance();
            if (instance instanceof BComplex) {
                return ((BComplex)instance).getProperty(path);
            }
        }
        return null;
    }

    public void setDefaultDisplayName(String path) {
        this.setDefaultDisplayName(path, null);
    }

    public void setDefaultDisplayName(String path, String alias) {
        this.alias = alias != null ? alias : lex.getText(path);
    }

    public void setTypeSpec(BTypeSpec typeSpec) {
        Type type = typeSpec.getResolvedType();
        this.typeSpec = type.isAbstract() || type.isInterface() ? BString.TYPE.getTypeSpec() : typeSpec;
    }

    public String toString() {
        if (this.alias == null) {
            throw new IllegalStateException("alias must not be null");
        }
        return this.alias;
    }

    public String encodeToString() {
        return this.typeSpec + "!" + this.path + "!" + this.alias;
    }

    public static TypeSpecPath decodeFromString(String encoded) {
        String[] split = TextUtil.split((String)encoded, (char)'!');
        TypeSpecPath typeSpecPath = new TypeSpecPath(BTypeSpec.make((String)split[0]), split[1], split[2]);
        return typeSpecPath;
    }
}

