/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.monitorSysDef;

import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BNiagaraSysDefDeviceExt;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDef;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefEvent;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefRole;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSourceType;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BMonitorSysDefSecurity
extends BComponent {
    public static final Property hasSecuritySupervisor = BMonitorSysDefSecurity.newProperty((int)1, (boolean)false, null);
    public static final Property hasSecuritySubordinate = BMonitorSysDefSecurity.newProperty((int)1, (boolean)false, null);
    public static final Topic monitorSysDefEvent = BMonitorSysDefSecurity.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BMonitorSysDefSecurity.class);
    private static final BIcon icon = BIcon.std((String)"remoteMgmt.png");

    public boolean getHasSecuritySupervisor() {
        return this.getBoolean(hasSecuritySupervisor);
    }

    public void setHasSecuritySupervisor(boolean v) {
        this.setBoolean(hasSecuritySupervisor, v, null);
    }

    public boolean getHasSecuritySubordinate() {
        return this.getBoolean(hasSecuritySubordinate);
    }

    public void setHasSecuritySubordinate(boolean v) {
        this.setBoolean(hasSecuritySubordinate, v, null);
    }

    public void fireMonitorSysDefEvent(BMonitorSysDefEvent event) {
        this.fire(monitorSysDefEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            this.setHasSecuritySupervisor(this.securitySupervisorExists());
            this.setHasSecuritySubordinate(this.securitySubordinateExists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BMonitorSysDefRole getRoleRecord(String stationName) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            this.lease();
            return (BMonitorSysDefRole)this.get(SlotPath.escape((String)stationName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BStationRole getStationCurrentRole(String stationName) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            return this.getStationCurrentRole(this.getRoleRecord(stationName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BStationRole getStationCurrentRole(BMonitorSysDefRole rec) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            if (rec != null) {
                rec.lease();
                return rec.getRole();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecuritySupervisor(String stationName) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BStationRole role = this.getStationCurrentRole(this.getRoleRecord(stationName));
            if (role != null) {
                return role.isSupervisor();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecuritySubordinate(String stationName) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BStationRole role = this.getStationCurrentRole(this.getRoleRecord(stationName));
            if (role != null) {
                return role.isSubordinate();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecurityPeer(String stationName) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BNiagaraStation station = this.findStation((BComponent)this.getNiagaraNetwork(), stationName);
            return this.isSecurityPeer(station);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecurityPeer(BNiagaraStation station) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            if (station == null) {
                return false;
            }
            BNiagaraSysDefDeviceExt sysDef = (BNiagaraSysDefDeviceExt)station.get("sysDef");
            if (sysDef == null) {
                return false;
            }
            return sysDef.getRoleManager().getActualRole() == BStationRole.peer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNiagaraStation[] getSecuritySupervisorStations() {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            this.lease();
            BNiagaraNetwork network = this.getNiagaraNetwork();
            Array stationsArr = new Array(BNiagaraStation.class);
            BMonitorSysDefRole[] roles = (BMonitorSysDefRole[])this.getChildren(BMonitorSysDefRole.class);
            for (int i = 0; i < roles.length; ++i) {
                BNiagaraStation station;
                if (!this.isSecuritySupervisor(roles[i].getName()) || (station = this.findStation((BComponent)network, roles[i].getName())) == null) continue;
                stationsArr.add((Object)station);
            }
            return (BNiagaraStation[])stationsArr.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNiagaraStation[] getSecuritySubordinateStations() {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            this.lease();
            BNiagaraNetwork network = this.getNiagaraNetwork();
            Array stationsArr = new Array(BNiagaraStation.class);
            BMonitorSysDefRole[] roles = (BMonitorSysDefRole[])this.getChildren(BMonitorSysDefRole.class);
            for (int i = 0; i < roles.length; ++i) {
                BNiagaraStation station;
                if (!this.isSecuritySubordinate(roles[i].getName()) || (station = this.findStation((BComponent)network, roles[i].getName())) == null) continue;
                stationsArr.add((Object)station);
            }
            return (BNiagaraStation[])stationsArr.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BNiagaraStation[] getSecurityPeerStations() {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            this.lease();
            BNiagaraNetwork network = this.getNiagaraNetwork();
            BNiagaraStation[] stations = (BNiagaraStation[])network.getChildren(BNiagaraStation.class);
            Array a = new Array(BNiagaraStation.class);
            for (int i = 0; i < stations.length; ++i) {
                if (!this.isSecurityPeer(stations[i])) continue;
                a.add((Object)stations[i]);
            }
            return (BNiagaraStation[])a.trim();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStationRole(String stationName, BStationRole role, BTypeSpec typeSpec, BOrd ord, int flags) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BMonitorSysDefRole rec = this.getRoleRecord(stationName);
            BStationRole currentRole = this.getStationCurrentRole(rec);
            if (currentRole != null) {
                if (currentRole.equivalent((Object)role)) {
                    this.addTypeSpec(rec, stationName, role, typeSpec, ord, flags);
                }
            } else {
                this.insertStationRole(rec, stationName, role, typeSpec, ord, flags);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStationRole(String stationName, BStationRole role, BTypeSpec typeSpec) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BMonitorSysDefRole rec = this.getRoleRecord(stationName);
            BStationRole currentRole = this.getStationCurrentRole(rec);
            if (currentRole != null && this.getRole(currentRole) != this.getRole(role)) {
                this.roleChanged(rec, stationName, currentRole, role, typeSpec);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStationRole(String stationName, BTypeSpec typeSpec) {
        BMonitorSysDefSecurity bMonitorSysDefSecurity = this;
        synchronized (bMonitorSysDefSecurity) {
            BMonitorSysDefRole rec = this.getRoleRecord(stationName);
            if (rec != null) {
                this.removeStationRole(rec, stationName, typeSpec);
            }
        }
    }

    private boolean securitySupervisorExists() {
        BMonitorSysDefRole[] kids = (BMonitorSysDefRole[])this.getChildren(BMonitorSysDefRole.class);
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].getRole().isSupervisor()) continue;
            return true;
        }
        return false;
    }

    private boolean securitySubordinateExists() {
        BMonitorSysDefRole[] kids = (BMonitorSysDefRole[])this.getChildren(BMonitorSysDefRole.class);
        for (int i = 0; i < kids.length; ++i) {
            if (!kids[i].getRole().isSubordinate()) continue;
            return true;
        }
        return false;
    }

    private void roleChanged(BMonitorSysDefRole rec, String stationName, BStationRole oldRole, BStationRole newRole, BTypeSpec typeSpec) {
        if (!newRole.isSupervisor() && !newRole.isSubordinate()) {
            this.fireMonitorRemoveAll(rec, stationName, oldRole, typeSpec);
            this.removeStationRole(stationName);
        } else {
            this.fireMonitorRemoveAll(rec, stationName, oldRole, typeSpec);
            this.updateStationRole(rec, newRole);
            this.fireMonitorInsertAll(rec, stationName, newRole, typeSpec);
        }
    }

    private void addTypeSpec(BMonitorSysDefRole rec, String stationName, BStationRole role, BTypeSpec typeSpec, BOrd ord, int flags) {
        BMonitorSysDefSourceType[] sourceRecs = (BMonitorSysDefSourceType[])rec.getChildren(BMonitorSysDefSourceType.class);
        for (int i = 0; i < sourceRecs.length; ++i) {
            if (!sourceRecs[i].getServiceTypeSpec().equivalent((Object)typeSpec)) continue;
            return;
        }
        BMonitorSysDefSourceType source = new BMonitorSysDefSourceType(typeSpec, ord);
        rec.add(typeSpec.getTypeName(), (BValue)source, flags);
        BMonitorSysDefEvent event = BMonitorSysDefEvent.makeInsert(this.getRole(role), stationName, typeSpec);
        if (sourceRecs.length == 0) {
            this.fireServiceEvent(event);
        }
        this.fireMonitorEvent(event, ord);
    }

    private void insertStationRole(BMonitorSysDefRole rec, String stationName, BStationRole role, BTypeSpec typeSpec, BOrd ord, int flags) {
        rec = new BMonitorSysDefRole(role);
        BMonitorSysDefSourceType source = new BMonitorSysDefSourceType(typeSpec, ord);
        rec.add(typeSpec.getTypeName(), (BValue)source, flags);
        this.add(SlotPath.escape((String)stationName), (BValue)rec, flags);
        this.setHasSecuritySupervisor(this.securitySupervisorExists());
        this.setHasSecuritySubordinate(this.securitySubordinateExists());
        BMonitorSysDefEvent event = BMonitorSysDefEvent.makeInsert(this.getRole(role), stationName, typeSpec);
        this.fireServiceEvent(event);
        this.fireMonitorEvent(event, ord);
    }

    private void updateStationRole(BMonitorSysDefRole rec, BStationRole role) {
        if (rec != null) {
            rec.setRole(role);
            this.setHasSecuritySupervisor(this.securitySupervisorExists());
            this.setHasSecuritySubordinate(this.securitySubordinateExists());
        }
    }

    private void removeStationRole(BMonitorSysDefRole rec, String stationName, BTypeSpec typeSpec) {
        BMonitorSysDefSourceType[] sourceRecs;
        if (rec.get(typeSpec.getTypeName()) != null) {
            BMonitorSysDefSourceType sourceType = (BMonitorSysDefSourceType)rec.get(typeSpec.getTypeName());
            if (sourceType != null) {
                this.fireMonitorEvent(BMonitorSysDefEvent.makeDelete(this.getRole(rec.getRole()), stationName, sourceType.getServiceTypeSpec()), sourceType.getMonitorOrd());
            }
            rec.remove(typeSpec.getTypeName());
        }
        if ((sourceRecs = (BMonitorSysDefSourceType[])rec.getChildren(BMonitorSysDefSourceType.class)).length == 0) {
            this.fireServiceEvent(BMonitorSysDefEvent.makeDelete(this.getRole(rec.getRole()), stationName, typeSpec));
            this.removeStationRole(stationName);
        }
    }

    private void removeStationRole(String stationName) {
        this.remove(SlotPath.escape((String)stationName));
        this.setHasSecuritySupervisor(this.securitySupervisorExists());
        this.setHasSecuritySubordinate(this.securitySubordinateExists());
    }

    private int getRole(BStationRole role) {
        if (role.isSupervisor()) {
            return 0;
        }
        if (role.isSubordinate()) {
            return 1;
        }
        return -1;
    }

    private void fireMonitorEvent(BMonitorSysDefEvent event, BOrd ord) {
        try {
            BMonitorSysDef monitorSysDef = (BMonitorSysDef)ord.resolve((BObject)this).get();
            monitorSysDef.fireMonitorSysDefEvent(event);
        }
        catch (UnresolvedException monitorSysDef) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fireMonitorRemoveAll(BMonitorSysDefRole rec, String stationName, BStationRole role, BTypeSpec typeSpec) {
        this.fireServiceEvent(BMonitorSysDefEvent.makeDelete(this.getRole(role), stationName, typeSpec));
        BMonitorSysDefSourceType[] sourceRecs = (BMonitorSysDefSourceType[])rec.getChildren(BMonitorSysDefSourceType.class);
        for (int i = 0; i < sourceRecs.length; ++i) {
            this.fireMonitorEvent(BMonitorSysDefEvent.makeDelete(this.getRole(role), stationName, sourceRecs[i].getServiceTypeSpec()), sourceRecs[i].getMonitorOrd());
        }
    }

    private void fireMonitorInsertAll(BMonitorSysDefRole rec, String stationName, BStationRole role, BTypeSpec typeSpec) {
        this.fireServiceEvent(BMonitorSysDefEvent.makeInsert(this.getRole(role), stationName, typeSpec));
        BMonitorSysDefSourceType[] sourceRecs = (BMonitorSysDefSourceType[])rec.getChildren(BMonitorSysDefSourceType.class);
        for (int i = 0; i < sourceRecs.length; ++i) {
            this.fireMonitorEvent(BMonitorSysDefEvent.makeInsert(this.getRole(role), stationName, sourceRecs[i].getServiceTypeSpec()), sourceRecs[i].getMonitorOrd());
        }
    }

    private void fireServiceEvent(BMonitorSysDefEvent event) {
        this.fireMonitorSysDefEvent(event);
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
    }

    private BNiagaraStation findStation(BComponent parent, String stationName) {
        if (parent == null) {
            return null;
        }
        parent.lease();
        BValue slot = parent.get(stationName);
        if (slot instanceof BNiagaraStation) {
            return (BNiagaraStation)slot;
        }
        BComponent[] children = parent.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            BNiagaraStation station = this.findStation(children[i], stationName);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    public static boolean isPlatformValidSupervisor() {
        return BEnterpriseSecurityService.isWorkstation();
    }

    public void spy(SpyWriter out) throws Exception {
        int i;
        super.spy(out);
        out.startTable(true);
        out.trTitle((Object)"Supervisor", 2);
        BNiagaraStation[] stations = this.getSecuritySupervisorStations();
        for (i = 0; i < stations.length; ++i) {
            out.tr((Object)stations[i].getStationName(), (Object)stations[i].getStatus());
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Subordinates", 2);
        stations = this.getSecuritySubordinateStations();
        for (i = 0; i < stations.length; ++i) {
            out.tr((Object)stations[i].getStationName(), (Object)stations[i].getStatus());
        }
        out.endTable();
        out.startTable(true);
        out.trTitle((Object)"Peers", 2);
        stations = this.getSecurityPeerStations();
        for (i = 0; i < stations.length; ++i) {
            out.tr((Object)stations[i].getStationName(), (Object)stations[i].getStatus());
        }
        out.endTable();
    }

    public BIcon getIcon() {
        return icon;
    }
}

