/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.bog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Flags;
import javax.baja.xml.XElem;

public class Entry {
    private static Map modules = new HashMap();
    private List kids = new ArrayList();
    public final Entry parent;
    public final String name;
    public final String handle;
    public final String module;
    public final String type;
    public final String value;
    public final int flags;
    public final boolean stub;
    public final BFacets facets;
    public final BCategoryMask catMask;

    public Entry(Entry parent, XElem elem) {
        this.parent = parent;
        String name = null;
        String handle = null;
        String type = null;
        String value = null;
        int flags = -1;
        boolean stub = false;
        BFacets facets = BFacets.NULL;
        BCategoryMask catMask = BCategoryMask.NULL;
        String ename = elem.name();
        if (ename != "p" && ename != "a" && ename != "t") {
            throw new IllegalStateException("Unknown element <" + ename + ">");
        }
        int attrSize = elem.attrSize();
        for (int i = 0; i < attrSize; ++i) {
            String attrName = elem.attrName(i);
            String attrVal = elem.attrValue(i);
            if (attrName.equals("n")) {
                name = attrVal;
                continue;
            }
            if (attrName.equals("h")) {
                handle = attrVal;
                continue;
            }
            if (attrName.equals("v")) {
                value = attrVal;
                continue;
            }
            if (attrName.equals("t")) {
                type = attrVal;
                continue;
            }
            if (attrName.equals("m")) {
                Entry.loadModule(attrVal);
                continue;
            }
            if (attrName.equals("f")) {
                flags = Entry.decodeFlags(attrVal);
                continue;
            }
            if (attrName.equals("x")) {
                facets = this.decodeFacets(attrVal);
                continue;
            }
            if (attrName.equals("c")) {
                catMask = this.decodeCategoryMask(attrVal);
                continue;
            }
            if (!attrName.equals("stub")) continue;
            stub = attrVal.equals("true");
        }
        if (type == null) {
            this.type = null;
            this.module = null;
        } else {
            String[] tokens = TextUtil.split(type, (char)':');
            this.module = (String)modules.get(tokens[0]);
            if (this.module == null) {
                throw new IllegalStateException();
            }
            this.type = tokens[1];
        }
        this.name = name;
        this.handle = handle;
        this.value = value;
        this.flags = flags;
        this.stub = stub;
        this.facets = facets;
        this.catMask = catMask;
    }

    private static void loadModule(String str) {
        String[] tokens = TextUtil.split((String)str, (char)'=');
        modules.put(tokens[0], tokens[1]);
    }

    private static int decodeFlags(String str) {
        if (str == null) {
            return 0;
        }
        return Flags.decodeFromString((String)str);
    }

    private BFacets decodeFacets(String str) {
        try {
            if (str == null) {
                return BFacets.NULL;
            }
            return BFacets.make((String)str);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private BCategoryMask decodeCategoryMask(String str) {
        if (str == null) {
            return BCategoryMask.NULL;
        }
        return BCategoryMask.make((String)str);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Entry: ");
        if (this.name != null) {
            sb.append("name:" + this.name + ", ");
        }
        if (this.handle != null) {
            sb.append("handle:" + this.handle + ", ");
        }
        if (this.module != null) {
            sb.append("module:" + this.module + ", ");
        }
        if (this.type != null) {
            sb.append("type:" + this.type + ", ");
        }
        if (this.value != null) {
            sb.append("value:" + this.value + ", ");
        }
        if (this.flags != -1) {
            sb.append("flags:" + this.flags + ", ");
        }
        if (this.stub) {
            sb.append("stub:" + this.flags + ", ");
        }
        if (!this.facets.equals((Object)BFacets.NULL)) {
            sb.append("facets:" + this.facets + ", ");
        }
        if (!this.catMask.equals((Object)BCategoryMask.NULL)) {
            sb.append("catMask:" + this.catMask + ", ");
        }
        return sb.toString();
    }

    void addChild(Entry child) {
        this.kids.add(child);
    }

    public Entry[] getChildren() {
        return this.kids.toArray(new Entry[this.kids.size()]);
    }
}

