/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.alarm;

import com.tridiumx.entsec.securityUtil.alarm.BLayoutOptions;
import com.tridiumx.entsec.securityUtil.alarm.BPopupOptions;
import com.tridiumx.entsec.securityUtil.alarm.BVideoAlarmAckOptions;
import com.tridiumx.entsec.securityUtil.alarm.BVideoViewingOptions;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSecurityAlarmConsoleOptions
extends BComponent
implements BIMixIn {
    public static final Property notesRequiredOnAck = BSecurityAlarmConsoleOptions.newProperty((int)0, (boolean)true, null);
    public static final Property showInstructions = BSecurityAlarmConsoleOptions.newProperty((int)5, (boolean)true, null);
    public static final Property useSourceTimezone = BSecurityAlarmConsoleOptions.newProperty((int)0, (boolean)false, null);
    public static final Property defaultAlarmConsole = BSecurityAlarmConsoleOptions.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"entsec:AlarmConsolePickerFE"), (String)"targetType", (BIDataValue)BString.make((String)"alarm:ConsoleRecipient")));
    public static final Property enableVideoSettings = BSecurityAlarmConsoleOptions.newProperty((int)0, (boolean)true, null);
    public static final Property layout = BSecurityAlarmConsoleOptions.newProperty((int)0, (BValue)BLayoutOptions.consoleAndPlayback, null);
    public static final Property alarmConsolePopup = BSecurityAlarmConsoleOptions.newProperty((int)0, (BValue)BPopupOptions.off, null);
    public static final Property alarmReceived = BSecurityAlarmConsoleOptions.newProperty((int)4, (boolean)false, null);
    public static final Property actionOnNewAlarm = BSecurityAlarmConsoleOptions.newProperty((int)0, (BValue)BVideoViewingOptions.loadNewestAlarm, null);
    public static final Property actionOnVideoAcknowledgement = BSecurityAlarmConsoleOptions.newProperty((int)0, (BValue)BVideoAlarmAckOptions.loadNewestAlarm, null);
    public static final Action signalAlarmReceived = BSecurityAlarmConsoleOptions.newAction((int)0, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSecurityAlarmConsoleOptions.class);

    public boolean getNotesRequiredOnAck() {
        return this.getBoolean(notesRequiredOnAck);
    }

    public void setNotesRequiredOnAck(boolean v) {
        this.setBoolean(notesRequiredOnAck, v, null);
    }

    public boolean getShowInstructions() {
        return this.getBoolean(showInstructions);
    }

    public void setShowInstructions(boolean v) {
        this.setBoolean(showInstructions, v, null);
    }

    public boolean getUseSourceTimezone() {
        return this.getBoolean(useSourceTimezone);
    }

    public void setUseSourceTimezone(boolean v) {
        this.setBoolean(useSourceTimezone, v, null);
    }

    public BOrd getDefaultAlarmConsole() {
        return (BOrd)this.get(defaultAlarmConsole);
    }

    public void setDefaultAlarmConsole(BOrd v) {
        this.set(defaultAlarmConsole, (BValue)v, null);
    }

    public boolean getEnableVideoSettings() {
        return this.getBoolean(enableVideoSettings);
    }

    public void setEnableVideoSettings(boolean v) {
        this.setBoolean(enableVideoSettings, v, null);
    }

    public BLayoutOptions getLayout() {
        return (BLayoutOptions)this.get(layout);
    }

    public void setLayout(BLayoutOptions v) {
        this.set(layout, (BValue)v, null);
    }

    public BPopupOptions getAlarmConsolePopup() {
        return (BPopupOptions)this.get(alarmConsolePopup);
    }

    public void setAlarmConsolePopup(BPopupOptions v) {
        this.set(alarmConsolePopup, (BValue)v, null);
    }

    public boolean getAlarmReceived() {
        return this.getBoolean(alarmReceived);
    }

    public void setAlarmReceived(boolean v) {
        this.setBoolean(alarmReceived, v, null);
    }

    public BVideoViewingOptions getActionOnNewAlarm() {
        return (BVideoViewingOptions)this.get(actionOnNewAlarm);
    }

    public void setActionOnNewAlarm(BVideoViewingOptions v) {
        this.set(actionOnNewAlarm, (BValue)v, null);
    }

    public BVideoAlarmAckOptions getActionOnVideoAcknowledgement() {
        return (BVideoAlarmAckOptions)this.get(actionOnVideoAcknowledgement);
    }

    public void setActionOnVideoAcknowledgement(BVideoAlarmAckOptions v) {
        this.set(actionOnVideoAcknowledgement, (BValue)v, null);
    }

    public void signalAlarmReceived(BAlarmRecord alarm) {
        this.invoke(signalAlarmReceived, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public String getDisplayNameInParent(Context cx) {
        return "AlarmConsoleOptions";
    }

    public void doSignalAlarmReceived(BAlarmRecord alarm) {
        if (!this.getEnableVideoSettings()) {
            return;
        }
        if (alarm.isAcknowledged() || alarm.isAckPending() || alarm.isNormal()) {
            return;
        }
        if (this.getAlarmConsolePopup().equals((Object)BPopupOptions.off)) {
            return;
        }
        if (this.getAlarmConsolePopup().equals((Object)BPopupOptions.videoAlarmsOnly) && !this.isVideoAlarm(alarm)) {
            return;
        }
        if (this.getAlarmReceived()) {
            return;
        }
        this.setAlarmReceived(true);
    }

    private boolean isVideoAlarm(BAlarmRecord alarm) {
        String alarmSourceExtCamera = alarm.getAlarmData().gets("cameraOrd", null);
        return alarmSourceExtCamera != null && !BOrd.make((String)alarmSourceExtCamera).isNull();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property == enableVideoSettings) {
            if (this.getEnableVideoSettings()) {
                this.unhideVideoSlots();
            } else {
                this.hideVideoSlots();
            }
        }
    }

    private void hideVideoSlots() {
        this.setFlags((Slot)layout, this.getFlags((Slot)layout) | 4);
        this.setFlags((Slot)alarmConsolePopup, this.getFlags((Slot)alarmConsolePopup) | 4);
        this.setFlags((Slot)actionOnNewAlarm, this.getFlags((Slot)actionOnNewAlarm) | 4);
        this.setFlags((Slot)actionOnVideoAcknowledgement, this.getFlags((Slot)actionOnVideoAcknowledgement) | 4);
    }

    private void unhideVideoSlots() {
        this.setFlags((Slot)layout, this.getFlags((Slot)layout) & 0xFFFFFFFB);
        this.setFlags((Slot)alarmConsolePopup, this.getFlags((Slot)alarmConsolePopup) & 0xFFFFFFFB);
        this.setFlags((Slot)actionOnNewAlarm, this.getFlags((Slot)actionOnNewAlarm) & 0xFFFFFFFB);
        this.setFlags((Slot)actionOnVideoAcknowledgement, this.getFlags((Slot)actionOnVideoAcknowledgement) & 0xFFFFFFFB);
    }
}

