/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil.alarm;

import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.NiagaraStation;
import com.tridiumx.entsec.securityUtil.alarm.AlarmClassSyncException;
import com.tridiumx.entsec.securityUtil.alarm.BNiagaraAlarmClassDeviceExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmClassFolder;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BIAlarmClassFolder;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BAlarmClassSyncChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BAlarmClassSyncChannel.class);
    public static Logger log = Logger.getLogger("niagara.alarmClasses");

    public BAlarmClassSyncChannel() {
        super("alarmClassSync");
    }

    public void checkProcess(FoxRequest req) throws Throwable {
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        if (command == "startSync") {
            return this.startSync(request);
        }
        if (command == "endSync") {
            return this.endSync(request);
        }
        if (command == "updateAlarmClasses") {
            return this.updateAlarmClasses(request);
        }
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        throw new InvalidCommandException(command);
    }

    public BNiagaraAlarmClassDeviceExt getAlarmClassDeviceExt() {
        BFoxConnection conn = this.getConnection();
        NiagaraStation station = conn.getConnectionTarget(NiagaraStation.class).orElse(null);
        if (station == null) {
            return null;
        }
        return (BNiagaraAlarmClassDeviceExt)((BComponent)station).get("entsec_NiagaraAlarmClassDeviceExt");
    }

    public void checkStatus(FoxResponse resp) throws Exception {
        String rc = resp.getString("status");
        if (!rc.equals("ok")) {
            throw new InvalidCommandException(resp.getString("msg"));
        }
    }

    public void startSync(boolean outgoing) throws Exception {
        if (!outgoing) {
            throw new InvalidCommandException("sync FROM server not supported");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("client.startSync: outgoing=" + outgoing);
        }
        FoxRequest req = this.makeRequest("startSync");
        req.add("outgoing", outgoing);
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse startSync(FoxRequest req) throws Exception {
        boolean outgoing = req.getBoolean("outgoing");
        if (log.isLoggable(Level.FINE)) {
            log.fine("server.startSync: outgoing=" + outgoing);
        }
        FoxResponse resp = new FoxResponse(req);
        BNiagaraAlarmClassDeviceExt ext = this.getAlarmClassDeviceExt();
        if (outgoing && !ext.getSyncInEnabled()) {
            resp.add("status", "error");
            resp.add("msg", "syncIn on remote station is disabled.");
        } else if (!outgoing && !ext.getSyncOutEnabled()) {
            resp.add("status", "error");
            resp.add("msg", "syncOut on remote is disabled.");
        } else if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", "AlarmClass synchronization is disabled.");
        } else {
            resp.add("status", "ok");
        }
        return resp;
    }

    public void endSync() throws Exception {
        FoxRequest req = this.makeRequest("endSync");
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
    }

    public FoxResponse endSync(FoxRequest req) throws Exception {
        FoxResponse resp = new FoxResponse(req);
        BNiagaraAlarmClassDeviceExt ext = this.getAlarmClassDeviceExt();
        if (ext.getStatus().isDisabled()) {
            resp.add("status", "error");
            resp.add("msg", "AlarmClass synchronization is disabled.");
        } else {
            ext.syncComplete();
            resp.add("status", "ok");
        }
        return resp;
    }

    public void updateAlarmClasses(BAlarmClass[] alarmClasses) throws Exception {
        int i;
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClassFolder batch = new BAlarmClassFolder();
        for (i = 0; i < alarmClasses.length; ++i) {
            BAlarmClass o = alarmClasses[i];
            Array path = new Array(String.class);
            while (!(o instanceof BAlarmService)) {
                path.add(0, (Object)o.getName());
                o = (BComponent)o.getParent();
            }
            BAlarmService c = service;
            BAlarmClassFolder current = batch;
            for (int p = 0; p < path.size(); ++p) {
                BComponent child = (BComponent)c.get(path.get(p).toString());
                if (current.get(child.getName()) == null) {
                    current.add(child.getName(), child.newCopy(true));
                }
                current = (BComponent)batch.get(child.getName());
                c = child;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            for (i = 0; i < alarmClasses.length; ++i) {
                log.fine("sending update for: " + alarmClasses[i].getName());
            }
        }
        FoxRequest req = this.makeRequest("updateAlarmClasses");
        req.add("bog", ValueDocEncoder.marshal((BValue)batch));
        FoxResponse resp = this.sendSync(req);
        this.checkStatus(resp);
        if (!resp.getString("status").equals("ok")) {
            throw new AlarmClassSyncException(resp.getString("msg"));
        }
    }

    public FoxResponse updateAlarmClasses(FoxRequest req) throws Exception {
        log.fine("update alarmClasses");
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BNiagaraAlarmClassDeviceExt deviceExt = this.getAlarmClassDeviceExt();
        String bog = req.getString("bog");
        if (log.isLoggable(Level.FINE)) {
            log.fine("alarmClasses to update:\n" + bog);
        }
        BComponent batch = (BComponent)ValueDocDecoder.unmarshal((String)bog);
        Array alarmClasses = new Array(BAlarmClass.class);
        deviceExt.syncAlarmClasses((BIAlarmClassFolder)batch);
        FoxResponse resp = new FoxResponse(req);
        resp.add("status", "ok");
        return resp;
    }

    public Type getType() {
        return TYPE;
    }
}

