/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSetPropertyJob
extends BJob {
    public static final Type TYPE = Sys.loadType(BSetPropertyJob.class);
    private static final int BATCH_SIZE = 20;
    BObject base;
    BVector extOrds;
    String property;
    BValue value;
    boolean canceled = false;
    JobThread thread;

    public Type getType() {
        return TYPE;
    }

    public BSetPropertyJob(BObject base, BVector extOrds, String property, BValue value) {
        this.base = base;
        this.extOrds = extOrds;
        this.value = value;
        this.property = property;
    }

    public BSetPropertyJob() {
    }

    public void doRun(Context cx) {
        this.thread = new JobThread(this.toPathString(), cx);
        this.thread.start();
    }

    public void run(Context cx) throws Exception {
        if (this.base == null) {
            throw new IllegalStateException("Must submit thru base");
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        boolean success = true;
        String enableText = "Setting";
        this.log().start(enableText + " Selected BComponents");
        int iteration = 0;
        int total = this.extOrds.getSlotCount();
        if (total <= 0) {
            total = 1;
        }
        SlotCursor c = this.extOrds.getProperties();
        while (c.next()) {
            if (iteration % 20 == 0) {
                this.progress((int)((float)iteration / (float)total * 100.0f));
            }
            ++iteration;
            BOrd extOrd = (BOrd)c.get();
            BComponent ext = null;
            try {
                ext = (BComponent)extOrd.resolve(this.base).get();
                if (ext.get(this.property) != null) {
                    ext.set(this.property, this.value);
                } else {
                    ext.add(this.property, this.value);
                }
            }
            catch (Exception ex) {
                this.log().failed("  Encountered Problem " + enableText + " " + (ext != null ? ext.getName() : "an unknown alarm extension.  "), (Throwable)ex);
                success = false;
            }
            if (!this.canceled) continue;
            break;
        }
        if (this.canceled) {
            throw new JobCancelException();
        }
        if (success) {
            this.log().success(enableText + " Selected Alarm Extensions Complete");
        } else {
            this.log().failed("Encountered Problems " + enableText + " Selected Alarm Extensions");
        }
    }

    public void doCancel(Context cx) {
        this.canceled = true;
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
    }

    class JobThread
    extends Thread {
        Context cx;

        JobThread(String name, Context cx) {
            super(name);
            this.cx = cx;
            this.setPriority(1);
        }

        @Override
        public void run() {
            try {
                BSetPropertyJob.this.run(this.cx);
                BSetPropertyJob.this.success();
            }
            catch (Throwable e) {
                BSetPropertyJob.this.failed(e);
            }
        }
    }
}

