/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BSafeSimpleJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BSafeSimpleJob.class);
    protected boolean safeToCancel = true;
    protected boolean cancelWhenSafe = false;

    public void doCancel(Context cx) {
        this.cancelWhenSafe = true;
    }

    public void preventCancel(Context cx) {
        this.safeToCancel = false;
    }

    public void allowCancel(Context cx) {
        if (this.cancelWhenSafe) {
            this.setJobState(BJobState.canceling);
            throw new JobCancelException("Job is canceled");
        }
    }

    public void checkCancel(Context cx) {
        this.allowCancel(cx);
        this.preventCancel(cx);
    }

    public Type getType() {
        return TYPE;
    }
}

