/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.securityUtil.BActivityRecordType;
import com.tridiumx.entsec.securityUtil.BIOutOfOrderHistoryRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.StringTokenizer;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.history.BHistoryRecord;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class BActivityRecord
extends BHistoryRecord
implements BIOutOfOrderHistoryRecord {
    private static final long serialVersionUID = 1L;
    public static final Property recordType = BActivityRecord.newProperty((int)0, (BValue)BActivityRecordType.unknown, null);
    public static final Property activity = BActivityRecord.newProperty((int)0, (String)"", null);
    public static final Property station = BActivityRecord.newProperty((int)0, (String)"", null);
    public static final Property authority = BActivityRecord.newProperty((int)0, (String)"", null);
    public static final Property object = BActivityRecord.newProperty((int)0, (String)"", null);
    public static final Property description = BActivityRecord.newProperty((int)0, (String)"", null);
    public static final Property sourceRecordType = BActivityRecord.newProperty((int)5, (BValue)BTypeSpec.NULL, null);
    public static final Property encodedSourceRecord = BActivityRecord.newProperty((int)5, (String)"", null);
    public static final Type TYPE = Sys.loadType(BActivityRecord.class);

    public BActivityRecordType getRecordType() {
        return (BActivityRecordType)this.get(recordType);
    }

    public void setRecordType(BActivityRecordType v) {
        this.set(recordType, (BValue)v, null);
    }

    public String getActivity() {
        return this.getString(activity);
    }

    public void setActivity(String v) {
        this.setString(activity, v, null);
    }

    public String getStation() {
        return this.getString(station);
    }

    public void setStation(String v) {
        this.setString(station, v, null);
    }

    public String getAuthority() {
        return this.getString(authority);
    }

    public void setAuthority(String v) {
        this.setString(authority, v, null);
    }

    public String getObject() {
        return this.getString(object);
    }

    public void setObject(String v) {
        this.setString(object, v, null);
    }

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public BTypeSpec getSourceRecordType() {
        return (BTypeSpec)this.get(sourceRecordType);
    }

    public void setSourceRecordType(BTypeSpec v) {
        this.set(sourceRecordType, (BValue)v, null);
    }

    public String getEncodedSourceRecord() {
        return this.getString(encodedSourceRecord);
    }

    public void setEncodedSourceRecord(String v) {
        this.setString(encodedSourceRecord, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BActivityRecord() {
    }

    public BActivityRecord(BAbsTime tStamp, BObject sourceRec, String act, String obj, String auth, String desc) {
        this.setTimestamp(tStamp);
        this.setRecordType(BActivityRecordType.getActivityRecordType(sourceRec));
        this.setStation(BActivityRecord.parseStationName(sourceRec));
        BTypeSpec recType = sourceRec.getType().getTypeSpec();
        this.setSourceRecordType(recType);
        this.setActivity(act);
        this.setObject(obj);
        this.setAuthority(auth);
        this.setDescription(desc);
        this.setEncodedSourceRecord(BActivityRecord.encodeSourceRecord(recType, sourceRec));
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.setRecordType((BActivityRecordType)BActivityRecordType.unknown.decode(in));
        this.setStation(in.readUTF());
        this.setSourceRecordType((BTypeSpec)BTypeSpec.DEFAULT.decode(in));
        this.setActivity(in.readUTF());
        this.setObject(in.readUTF());
        this.setAuthority(in.readUTF());
        this.setDescription(in.readUTF());
        this.setEncodedSourceRecord(in.readUTF());
    }

    protected void doWrite(DataOutput out) throws IOException {
        this.getRecordType().encode(out);
        out.writeUTF(this.getStation());
        this.getSourceRecordType().encode(out);
        out.writeUTF(this.getActivity());
        out.writeUTF(this.getObject());
        out.writeUTF(this.getAuthority());
        out.writeUTF(this.getDescription());
        out.writeUTF(this.getEncodedSourceRecord());
    }

    static String parseStationName(BObject rec) {
        BOrdList ordList;
        if (rec instanceof BOrionHistoryRecord) {
            return ((BOrionHistoryRecord)rec).getStationName();
        }
        if (rec instanceof BAlarmRecord && (ordList = ((BAlarmRecord)rec).getSource()).size() > 1) {
            BOrd ord = ordList.get(1);
            String slotPath = ord.encodeToString();
            int idx = slotPath.lastIndexOf(47);
            String trim = slotPath.substring(0, idx);
            idx = trim.lastIndexOf(47);
            return SlotPath.unescape((String)trim.substring(idx + 1, trim.length()));
        }
        return Sys.getStation().getStationName();
    }

    public static String encodeSourceRecord(BTypeSpec recType, BObject rec) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream dataOut = new ObjectOutputStream(bOut);
            recType.encode((DataOutput)dataOut);
            if (rec instanceof BAlarmRecord) {
                ((BAlarmRecord)rec).getUuid().encode((DataOutput)dataOut);
            } else if (rec instanceof BOrionHistoryRecord) {
                BOrionHistoryRecord oRec = (BOrionHistoryRecord)rec;
                dataOut.writeUTF(oRec.getOrionDatabase().getId());
                dataOut.writeInt(oRec.getId());
            } else if (rec instanceof Externalizable) {
                ((Externalizable)rec).writeExternal(dataOut);
            } else {
                return "";
            }
            dataOut.flush();
            dataOut.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BActivityRecord.bytesToString(bOut.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BObject decodeSourceRecord(String encodedRec) {
        try {
            byte[] bytes = BActivityRecord.stringToBytes(encodedRec);
            if (bytes == null) {
                return null;
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ObjectInputStream dataIn = new ObjectInputStream(bIn);
            Type t = ((BTypeSpec)BTypeSpec.DEFAULT.decode((DataInput)dataIn)).getResolvedType();
            if (t.is(BAlarmRecord.TYPE)) {
                BUuid uuid = (BUuid)BUuid.DEFAULT.decode((DataInput)dataIn);
                BAlarmService as = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                    BAlarmRecord bAlarmRecord = conn.getRecord(BUuid.make((String)uuid.toString()));
                    return bAlarmRecord;
                }
            }
            if (!t.is(BOrionHistoryRecord.TYPE)) {
                BObject rec = t.getInstance();
                if (!(rec instanceof Externalizable)) return null;
                ((Externalizable)rec).readExternal(dataIn);
                return rec;
            }
            OrionSession session = null;
            try {
                session = ((BOrionService)Sys.getService((Type)BOrionService.TYPE)).getOrionDatabase(dataIn.readUTF()).createSession(null);
                BObject as = (BObject)session.read((OrionType)t, new PropertyValue(BOrionHistoryRecord.id, (BValue)BInteger.make((int)dataIn.readInt())));
                return as;
            }
            catch (Exception e) {
                e.printStackTrace();
                BObject bObject = null;
                return bObject;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static String bytesToString(byte[] b) {
        if (b == null || b.length == 0) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        String s = TextUtil.byteToHexString((int)b[0]);
        if (s.length() == 1) {
            sb.append("0");
        }
        sb.append(s);
        for (int i = 1; i < b.length; ++i) {
            sb.append(" ");
            s = TextUtil.byteToHexString((int)b[i]);
            if (s.length() == 1) {
                sb.append("0");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static byte[] stringToBytes(String s) {
        byte[] a;
        if (s == null || s.equals("null")) {
            a = null;
        } else {
            StringTokenizer st = new StringTokenizer(s, " ");
            a = new byte[st.countTokens()];
            try {
                for (int i = 0; i < a.length; ++i) {
                    a[i] = (byte)Integer.parseInt(st.nextToken(), 16);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                a = null;
            }
        }
        return a;
    }

    @Override
    public Property getOutOfOrderStringProperty() {
        return description;
    }
}

