/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.securityUtil;

import com.tridium.bql.Range;
import com.tridium.bql.RangeSet;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.collection.BqlColumnList;
import com.tridium.bql.collection.PropertyColumn;
import com.tridiumx.entsec.securityUtil.ArrayTableCursor;
import com.tridiumx.entsec.securityUtil.BActivityMonitor;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import java.util.ArrayList;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BActivityQueryResult
extends BObject
implements BITable {
    public static final Type TYPE = Sys.loadType(BActivityQueryResult.class);
    private static Object staticLock = new Object();
    private BActivityMonitor monitor;
    private BqlQuery query;
    private ArrayList list;
    private ColumnList columns;
    private IFilter filter;
    private BFacets tableFacets;
    private Context cx;

    public Type getType() {
        return TYPE;
    }

    public BActivityQueryResult(BActivityMonitor monitor, BqlQuery query, Context cx) {
        this(monitor, query, cx, null);
    }

    private BActivityQueryResult(BActivityMonitor monitor, BqlQuery query, Context cx, IFilter filter) {
        this.monitor = monitor;
        this.query = query;
        this.cx = cx;
        this.filter = filter;
        this.tableFacets = BFacets.DEFAULT;
        if (query instanceof SelectQuery) {
            SelectQuery select = (SelectQuery)query;
            RangeSet range = null;
            if (select.hasPredicate() && !(range = select.getRange(BActivityRecord.timestamp.getName(), BAbsTime.TYPE, false)).isAll()) {
                range.sort();
                Range min = range.getRange(0);
                Range max = range.getRange(range.getCount() - 1);
                if (min.min != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"startTime", (BIDataValue)((BAbsTime)min.min)));
                }
                if (max.max != null) {
                    this.tableFacets = BFacets.make((BFacets)this.tableFacets, (BFacets)BFacets.make((String)"endTime", (BIDataValue)((BAbsTime)max.max)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableCursor cursor() {
        Object object = staticLock;
        synchronized (object) {
            ArrayTableCursor arrayTableCursor;
            block8: {
                BActivityMonitor.ConsolidatedCursor cursor = null;
                try {
                    cursor = (BActivityMonitor.ConsolidatedCursor)this.monitor.doBqlQuery(this.query, this.filter, this.cx);
                    Array a = new Array(BActivityRecord.class);
                    while (cursor.next()) {
                        a.add((Object)cursor.get());
                    }
                    arrayTableCursor = new ArrayTableCursor(this, a, cursor.getContext());
                    if (cursor == null) break block8;
                    cursor.close();
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
            }
            return arrayTableCursor;
        }
    }

    public BITable filter(IFilter filter) {
        return new BActivityQueryResult(this.monitor, this.query, this.cx, filter);
    }

    public int size() {
        this.load();
        return this.list.size();
    }

    public BObject get(int index) {
        this.load();
        return (BObject)this.list.get(index);
    }

    public BObject[] list() {
        this.load();
        return (BObject[])this.list.toArray((Object[])java.lang.reflect.Array.newInstance(BActivityRecord.class, this.list.size()));
    }

    public BObject[] list(BObject[] in) {
        this.load();
        return this.list.toArray(in);
    }

    public BITable toTable() {
        return this;
    }

    public ColumnList getColumns() {
        if (this.columns == null) {
            BActivityRecord rec = new BActivityRecord();
            Property[] props = rec.getPropertiesArray();
            BqlColumn[] cols = new BqlColumn[props.length];
            for (int i = 0; i < props.length; ++i) {
                Property prop = props[i];
                Object facets = null;
                cols[i] = new PropertyColumn(props[i]);
            }
            this.columns = new BqlColumnList((Column[])cols);
        }
        return this.columns;
    }

    public BObject get(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).get((BObject)this.list.get(row));
    }

    public String getString(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getString((BObject)this.list.get(row));
    }

    public double getDouble(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getDouble((BObject)this.list.get(row));
    }

    public float getFloat(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getFloat((BObject)this.list.get(row));
    }

    public int getInt(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getInt((BObject)this.list.get(row));
    }

    public long getLong(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getLong((BObject)this.list.get(row));
    }

    public boolean getBoolean(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getBoolean((BObject)this.list.get(row));
    }

    public int getFlags(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getFlags((BObject)this.list.get(row));
    }

    public BFacets getFacets(int row, Column column) {
        this.load();
        return ((PropertyColumn)column).getFacets((BObject)this.list.get(row));
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void load() {
        if (this.list != null) {
            return;
        }
        Object object = staticLock;
        synchronized (object) {
            try (BActivityMonitor.ConsolidatedCursor cursor = null;){
                cursor = (BActivityMonitor.ConsolidatedCursor)this.monitor.doBqlQuery(this.query, this.filter, this.cx);
                this.list = new ArrayList(128);
                while (cursor.next()) {
                    this.list.add(cursor.get());
                }
            }
        }
    }
}

