/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.data.BDataRow;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.query.BQueryEngine;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import com.tridium.workbench.util.CollectionTableModel;
import com.tridiumx.entsec.photoID.video.BAddCameraDialog;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsec.securityUtil.ui.query.BQueryTableOptions;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BPredicate;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.space.BSpace;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

public class BVideoCamerasQueryTableView
extends BWbView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType(BVideoCamerasQueryTableView.class);
    BEdgePane main;
    Command addCommand;
    Command closeCommand;
    Command filter;
    BTable table;
    private CommandBindings bindings;
    BAddCameraDialog addCamDlg;

    public Type getType() {
        return TYPE;
    }

    public BVideoCamerasQueryTableView(BAddCameraDialog addCamDlg) {
        this.addCamDlg = addCamDlg;
        this.bindings = this.getCommandBindings();
        this.table = new BCommandBoundTable((TableModel)new DefaultTableModel(), (CommandBindings.TableController)new ResultController());
        BTitlePane mainTable = BTitlePane.makePane((String)"", (BTable)this.table, (String)Lexicon.make((String)"workbench").getText("collectionTable.rows"));
        this.main = new BEdgePane();
        this.main.setCenter((BWidget)mainTable);
        this.setContent((BWidget)this.main);
    }

    public void doLoadValue(BObject value, Context cx) {
        BExpression exp;
        BQuery query = (BQuery)value;
        BQuery working = QueryUtil.getWorkingCopy(query, cx);
        BQueryTableOptions options = BQueryTableOptions.make();
        BFilterSet filterSet = options.getFilterSet(working);
        BPredicate queryPredicate = working.getPredicate();
        BExpression queryExp = null;
        if (queryPredicate != null) {
            queryExp = queryPredicate.getPredicateExpr();
        }
        if (QueryUtil.hasDefaultFilters(working) && filterSet == null) {
            filterSet = BQueryTableOptions.rebuildFilterSet(working, filterSet, cx);
        }
        ExpressionBuilder builder = new ExpressionBuilder(queryExp);
        if (filterSet != null && filterSet.getQueryPredicate() != null && filterSet.getQueryPredicate().getPredicateExpr() != null) {
            builder = builder.and((BExpression)filterSet.getQueryPredicate().getPredicateExpr().newCopy(true));
        }
        if ((exp = builder.getExpression()) != null) {
            working.where(new BPredicate((BExpression)exp.newCopy(true)));
        }
        BQueryEngine engine = BQueryEngine.make((BSpace)this.addCamDlg.videoPlaybackMultistream.getSpace());
        BOrd base = BOrd.make((String)"slot:/");
        if (this.addCamDlg.videoPlaybackMultistream.get("base") instanceof BOrd) {
            base = (BOrd)this.addCamDlg.videoPlaybackMultistream.get("base");
        }
        BOrd ord = BOrd.make((BOrd)this.addCamDlg.videoPlaybackMultistream.getSpace().getAbsoluteOrd(), (BOrd)base);
        BITable collection = engine.compile(working, ord).execute();
        QueryCollectionTableModel model = new QueryCollectionTableModel(collection, working, cx);
        this.table.setModel((TableModel)model);
        this.table.relayout();
        Command[] commands = this.getButtonCommands();
        if (commands != null) {
            BGridPane buttons = new BGridPane(commands.length);
            buttons.setUniformColumnWidth(true);
            buttons.setColumnGap(5.0);
            buttons.setColumnAlign(BHalign.fill);
            for (int i = 0; i < commands.length; ++i) {
                buttons.add(null, (BValue)new BButton(commands[i]));
            }
            this.main.setBottom((BWidget)new BBorderPane((BWidget)buttons, BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0)));
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        command.setEnabled(bindingBasedState);
    }

    public Command[] getButtonCommands() {
        Array a = new Array(Command.class);
        if (this.addCommand != null) {
            a.add((Object)this.addCommand);
        }
        if (this.closeCommand != null) {
            a.add((Object)this.closeCommand);
        }
        this.filter = new FilterCommand();
        a.add((Object)this.filter);
        return (Command[])a.trim();
    }

    public CommandBindings makeCommandBindings() {
        CommandBindings result = new CommandBindings();
        this.addCommand = new AddCommand();
        result.addCommand(this.addCommand, BCommandEnablePolicy.always);
        this.closeCommand = new CloseCommand();
        result.addCommand(this.closeCommand, BCommandEnablePolicy.always);
        return result;
    }

    public Command getDoubleClickCommand() {
        return this.addCommand;
    }

    public final CommandBindings getCommandBindings() {
        if (this.bindings == null) {
            this.bindings = this.makeCommandBindings();
        }
        return this.bindings;
    }

    public void configFilters() {
        BQuery query;
        BQuery working;
        BQueryTableOptions options = BQueryTableOptions.make();
        BFilterSet filterSet = options.getFilterSet(working = QueryUtil.getWorkingCopy(query = (BQuery)this.getCurrentValue(), this.getCurrentContext()));
        if (filterSet == null || !BQueryTableOptions.isFilterSetValid(working, filterSet)) {
            filterSet = BQueryTableOptions.rebuildFilterSet(working, filterSet, this.getCurrentContext());
            options.setFilterSet(working, filterSet);
        }
        BFilterSetEditor setEditor = new BFilterSetEditor();
        setEditor.loadValue((BObject)filterSet);
        BBorderPane borderPane = new BBorderPane((BWidget)setEditor, 10.0, 10.0, 10.0, 10.0);
        if (BDialog.open((BWidget)this, (String)"Filters", (Object)borderPane, (int)3) != 2) {
            try {
                if (setEditor.isModified()) {
                    options.setFilterSet(working, (BFilterSet)setEditor.saveValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (!(filterSet = options.getFilterSet(working)).anyActive()) {
            boolean custom = false;
            BProjectionColumn[] columns = working.getProjection().getProjectionColumns();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i].get("defaultFilter") == null) continue;
                custom = true;
            }
            if (!custom) {
                options.removeFilterSet(working);
            }
        }
    }

    protected class FilterCommand
    extends Command {
        public FilterCommand() {
            super((BWidget)BVideoCamerasQueryTableView.this, TYPE.getModule(), "command.filter");
        }

        public CommandArtifact doInvoke() throws Exception {
            BVideoCamerasQueryTableView.this.configFilters();
            BVideoCamerasQueryTableView.this.loadValue(BVideoCamerasQueryTableView.this.getCurrentValue());
            return null;
        }

        public BImage getIcon() {
            BQuery query;
            BQuery working;
            BQueryTableOptions options = BQueryTableOptions.make();
            BFilterSet filterSet = options.getFilterSet(working = QueryUtil.getWorkingCopy(query = (BQuery)BVideoCamerasQueryTableView.this.getCurrentValue(), BVideoCamerasQueryTableView.this.getCurrentContext()));
            if (filterSet == null || filterSet != null && !BQueryTableOptions.anyVisibleActive(filterSet)) {
                return super.getIcon();
            }
            return super.getIcon().getHighlightedImage();
        }
    }

    protected class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BVideoCamerasQueryTableView.this, TYPE.getModule(), "command.close");
        }

        public CommandArtifact doInvoke() {
            try {
                BVideoCamerasQueryTableView.this.addCamDlg.cancelButtonPress();
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    protected class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BVideoCamerasQueryTableView.this, TYPE.getModule(), "command.add");
        }

        public CommandArtifact doInvoke() {
            try {
                int[] queryion = BVideoCamerasQueryTableView.this.table.getSelection().getRows();
                if (queryion.length == 0) {
                    return null;
                }
                CollectionTableModel model = (CollectionTableModel)BVideoCamerasQueryTableView.this.table.getModel();
                Column[] list = model.getBITable().getColumns().list();
                BOrd[] cameraOrds = new BOrd[queryion.length];
                for (int i = 0; i < queryion.length; ++i) {
                    BOrd hyperlinkOrd;
                    BDataRow row = (BDataRow)BVideoCamerasQueryTableView.this.table.getModel().getSubject(queryion[i]);
                    String slotPath = row.cell(model.getBITable().getColumns().get(TypeSpecPath.SLOT_PATH.path)).toString();
                    cameraOrds[i] = hyperlinkOrd = BOrd.make((String)("station:|" + slotPath));
                }
                if (cameraOrds.length > 0) {
                    BVideoCamerasQueryTableView.this.addCamDlg.camerasOrdList = BOrdList.make((BOrd[])cameraOrds);
                }
                BVideoCamerasQueryTableView.this.addCamDlg.okButtonPress();
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                BDialog.error((BWidget)BVideoCamerasQueryTableView.this, (String)"Add failed.", (Object)ex);
                return null;
            }
        }
    }

    public class ResultController
    extends CommandBindings.TableController {
        public ResultController() {
            super(BVideoCamerasQueryTableView.this.bindings);
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            try {
                if (BVideoCamerasQueryTableView.this.getDoubleClickCommand() != null) {
                    BVideoCamerasQueryTableView.this.getDoubleClickCommand().invoke();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class QueryCollectionTableModel
    extends CollectionTableModel {
        private BQuery working;

        public QueryCollectionTableModel(BITable collection, BQuery working, Context cx) {
            super(collection, cx);
            this.working = working;
        }

        public int getColumnCount() {
            return super.getColumnCount() - QueryUtil.getHiddenColumnsCount(this.working);
        }
    }
}

