/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.ui.theme.Theme;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.video.PhotoIDVideoDecoder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BPen;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.util.BFormat;

public class BPhotoIDVideoPlayer
extends BVideoPlayer {
    public static final Property overlay = BPhotoIDVideoPlayer.newProperty((int)0, (BValue)BFormat.make((String)"test"), null);
    public static final Type TYPE = Sys.loadType(BPhotoIDVideoPlayer.class);
    protected BLabel overlayLabel = new BLabel();
    protected BPhotoIDNetwork network;

    public BFormat getOverlay() {
        return (BFormat)this.get(overlay);
    }

    public void setOverlay(BFormat v) {
        this.set(overlay, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void setVideoDecoder(IVideoDecoder videoDecoder) {
        this.videoDecoder = videoDecoder;
        if (videoDecoder instanceof PhotoIDVideoDecoder && ((PhotoIDVideoDecoder)videoDecoder).camera.getParent() instanceof BPhotoIDNetwork) {
            this.network = (BPhotoIDNetwork)((PhotoIDVideoDecoder)videoDecoder).camera.getParent();
            this.network.lease();
        }
    }

    public void paintDefault(Graphics g) {
        this.paintMostRecentImage(g);
        this.paintMessage(g);
        if (this.mostRecentImage != DISCONNECTED_IMAGE && this.getShowTimeIndex()) {
            this.paintMostRecentImageTime(g);
        }
        if (this.videoDecoder instanceof PhotoIDVideoDecoder) {
            PhotoIDVideoDecoder photoIdVideoDecoder = (PhotoIDVideoDecoder)this.videoDecoder;
            if (!photoIdVideoDecoder.camera.getSession().isConnected()) {
                return;
            }
            photoIdVideoDecoder.camera.lease();
            this.paintOverlay(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintOverlay(Graphics g) {
        if (this.videoDecoder != null) {
            BFormat format = this.getOverlay();
            String string = "";
            PhotoIDVideoDecoder photoIdVideoDecoder = (PhotoIDVideoDecoder)this.videoDecoder;
            string = photoIdVideoDecoder.isCameraOk ? photoIdVideoDecoder.camera.getSwipeDetails() : "Error In Reader Connection....";
            if (!string.equalsIgnoreCase("")) {
                try {
                    g.push();
                    int fontSize = this.network.getPhotoIDFontSize();
                    BFont f = BFont.make((String)Theme.label().getTextFont().getName(), (double)fontSize, (int)1);
                    this.overlayLabel.setHalign(BHalign.left);
                    this.overlayLabel.setValign(BValign.bottom);
                    this.overlayLabel.setText(string);
                    this.overlayLabel.setBackground(BBrush.NULL);
                    this.overlayLabel.setForeground(TIME_INDEX_TEXT_BRUSH);
                    this.overlayLabel.setFont(f);
                    this.overlayLabel.computePreferredSize();
                    this.overlayLabel.setBounds(2.0, 2.0, this.overlayLabel.getPreferredWidth(), this.overlayLabel.getPreferredHeight());
                    this.overlayLabel.doLayout(null);
                    g.transform(BTransform.makeTranslate((double)20.0, (double)(this.getHeight() - this.overlayLabel.getPreferredHeight() - 20.0)));
                    g.setBrush(TIME_INDEX_BACKGROUND_BRUSH);
                    g.setPen(BPen.make((double)4.0, (int)101, (int)202, null));
                    g.strokeRect(0.0, 0.0, this.overlayLabel.getPreferredWidth() + 4.0, this.overlayLabel.getPreferredHeight() + 4.0);
                    g.fillRect(2.0, 2.0, this.overlayLabel.getPreferredWidth(), this.overlayLabel.getPreferredHeight());
                    this.overlayLabel.paint(g);
                }
                finally {
                    g.pop();
                }
            }
        }
    }
}

