/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.video;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nvideo.camera.BVideoCamera;
import com.tridium.nvideo.camera.BVideoSourcePreferences;
import com.tridium.nvideo.datatypes.BVideoCameraInfo;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.videoDriver.enums.BFoxVideoStreamEnum;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.IVideoStream;
import com.tridium.videoDriver.videoStream.VideoStream;
import com.tridium.videoDriver.videoStream.decoder.IVideoDecoder;
import com.tridiumx.accessDriver.BAccessReader;
import com.tridiumx.accessDriver.BDoorController;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.photoID.video.PhotoIDVideoDecoder;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class BPhotoIDCamera
extends BVideoCamera {
    public static final Property readerUuid = BPhotoIDCamera.newProperty((int)0, (BValue)BUuid.DEFAULT, null);
    public static final Property personId = BPhotoIDCamera.newProperty((int)3, (BValue)BUuid.DEFAULT, null);
    public static final Property portraitOrd = BPhotoIDCamera.newProperty((int)3, (BValue)BOrd.DEFAULT, null);
    public static final Property validateTimestamp = BPhotoIDCamera.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    public static final Property swipeDetails = BPhotoIDCamera.newProperty((int)3, (String)"", (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Action monitorDoor = BPhotoIDCamera.newAction((int)2052, null);
    public static final Action keepAliveMonitor = BPhotoIDCamera.newAction((int)2052, null);
    public static final Action endSubscription = BPhotoIDCamera.newAction((int)2052, null);
    public static final Action validateTimeout = BPhotoIDCamera.newAction((int)2052, null);
    public static final Type TYPE = Sys.loadType(BPhotoIDCamera.class);
    public RemoteSubscriber subscriber = null;
    public BAccessReader remoteReader = null;
    private Clock.Ticket endSubscriptionTicket = null;
    private Clock.Ticket validateTimeoutTicket = null;

    public BUuid getReaderUuid() {
        return (BUuid)this.get(readerUuid);
    }

    public void setReaderUuid(BUuid v) {
        this.set(readerUuid, (BValue)v, null);
    }

    public BUuid getPersonId() {
        return (BUuid)this.get(personId);
    }

    public void setPersonId(BUuid v) {
        this.set(personId, (BValue)v, null);
    }

    public BOrd getPortraitOrd() {
        return (BOrd)this.get(portraitOrd);
    }

    public void setPortraitOrd(BOrd v) {
        this.set(portraitOrd, (BValue)v, null);
    }

    public BAbsTime getValidateTimestamp() {
        return (BAbsTime)this.get(validateTimestamp);
    }

    public void setValidateTimestamp(BAbsTime v) {
        this.set(validateTimestamp, (BValue)v, null);
    }

    public String getSwipeDetails() {
        return this.getString(swipeDetails);
    }

    public void setSwipeDetails(String v) {
        this.setString(swipeDetails, v, null);
    }

    public void monitorDoor() {
        this.invoke(monitorDoor, null, null);
    }

    public void keepAliveMonitor() {
        this.invoke(keepAliveMonitor, null, null);
    }

    public void endSubscription() {
        this.invoke(endSubscription, null, null);
    }

    public void validateTimeout() {
        this.invoke(validateTimeout, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPhotoIDCamera() {
        BVideoCameraInfo cameraInfo = this.getPtzSupport();
        cameraInfo.setSupportsFocus(false);
        cameraInfo.setSupportsIris(false);
        cameraInfo.setSupportsMoveToPreset(false);
        cameraInfo.setSupportsPanTilt(false);
        cameraInfo.setSupportsStorePreset(false);
        cameraInfo.setSupportsZoom(false);
        BVideoSourcePreferences vsp = this.getVideoPreferences();
        vsp.setPreferredVideoStreamFox(BFoxVideoStreamEnum.no);
    }

    public BAbsTime getCameraTime() {
        return BAbsTime.now();
    }

    public Type getNetworkType() {
        return BPhotoIDNetwork.TYPE;
    }

    public void videoCameraStarted() throws Exception {
    }

    protected Type getFocusCtrlReqType() {
        return null;
    }

    protected Type getIrisCtrlReqType() {
        return null;
    }

    public Action getMoveToPresetAction() {
        return moveToPreset;
    }

    protected Type getMoveToPresetReqType() {
        return null;
    }

    protected Type getPanTiltReqType() {
        return null;
    }

    public Action getStorePresetAction() {
        return null;
    }

    protected Type getStorePresetReqType() {
        return null;
    }

    protected Type getZoomReqType() {
        return null;
    }

    public void initPlaybackParams(BPlaybackParams playbackParams, IVideoSession videoSession) {
    }

    public IVideoDecoder makeVideoDecoder(BPlaybackParams playbackParams) {
        return new PhotoIDVideoDecoder(this);
    }

    public void doPing() throws Exception {
        this.pingOk();
    }

    public void streamToDestination(BPlaybackParams playbackParams, IVideoDestination videoDestination) {
        videoDestination.receiveVideoStream((IVideoStream)new VideoStream(playbackParams, (InputStream)new ByteArrayInputStream(new byte[0])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMonitorDoor() throws Exception {
        if (this.subscriber != null) {
            return;
        }
        BUuid readerUuid = this.getReaderUuid();
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        BAccessReader reader = null;
        BAccReaderRec rec = null;
        OrionSession orionSession = null;
        try {
            orionSession = network.createSession(null);
            rec = (BAccReaderRec)orionSession.read(BAccReaderRec.ORION_TYPE, (BSimple)readerUuid);
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
        if (rec == null) {
            return;
        }
        String interest = this.getType() + ".doMonitorDoor." + BUuid.make().toString();
        BFoxSession foxSession = null;
        String stationName = rec.getStationName();
        if (stationName.equals(Sys.getStation().getStationName())) {
            reader = (BAccessReader)rec.getMappedOrd().get();
        } else {
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
            if (station == null) {
                return;
            }
            foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry(interest);
            BComponent remoteComponent = RemoteUtil.getRemoteComponent(foxSession, rec.getMappedOrd().toString());
            if (remoteComponent == null) {
                return;
            }
            if (remoteComponent instanceof BAccessReader) {
                remoteComponent.lease(2);
                reader = (BAccessReader)remoteComponent;
            }
        }
        this.remoteReader = reader;
        this.updateInfo();
        this.subscriber = new RemoteSubscriber(this.remoteReader, foxSession, interest);
        this.subscriber.subscribe((BComponent)this.remoteReader);
        this.endSubscriptionTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)endSubscription, null);
    }

    public void doKeepAliveMonitor() {
        if (this.endSubscriptionTicket != null) {
            this.endSubscriptionTicket.cancel();
            this.endSubscriptionTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)10), (Action)endSubscription, null);
        }
    }

    public void doEndSubscription() {
        if (this.subscriber != null) {
            this.subscriber.unsubscribe((BComponent)this);
            this.subscriber = null;
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(validateTimestamp)) {
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
            if (!network.getPhotoIDTimeout().equals((Object)BRelTime.DEFAULT)) {
                if (this.validateTimeoutTicket != null) {
                    this.validateTimeoutTicket.cancel();
                }
                this.validateTimeoutTicket = Clock.schedule((BComponent)this, (BRelTime)network.getPhotoIDTimeout(), (Action)validateTimeout, null);
            } else {
                if (this.validateTimeoutTicket != null) {
                    this.validateTimeoutTicket.cancel();
                }
                this.validateTimeoutTicket = null;
            }
        }
        super.changed(prop, cx);
    }

    public void doValidateTimeout(Context cx) {
        this.setSwipeDetails("");
        this.setPortraitOrd(BOrd.DEFAULT);
        this.setPersonId(BUuid.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInfo() {
        if (this.remoteReader == null) {
            return;
        }
        BAbsTime time = this.remoteReader.getValidateTimestamp();
        if (time.equals((Object)this.getValidateTimestamp())) {
            return;
        }
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
        if (!network.getPhotoIDTimeout().equals((Object)BRelTime.DEFAULT) && BAbsTime.now().getMillis() - time.getMillis() > network.getPhotoIDTimeout().getMillis() + BRelTime.makeSeconds((int)20).getMillis()) {
            return;
        }
        this.setValidateTimestamp(this.remoteReader.getValidateTimestamp());
        OrionSession orionSession = null;
        try {
            orionSession = network.createSession(null);
            boolean supervisorOnly = false;
            BUuid personId = this.remoteReader.getLastPersonId();
            if (personId.equals((Object)BUuid.DEFAULT)) {
                String badgeId = this.remoteReader.getLastBadgeRead();
                BBadge testBadge = new BBadge();
                testBadge.setBadgeId(badgeId);
                BBadge dbBadge = (BBadge)orionSession.read((BIOrionObject)testBadge);
                if (dbBadge != null) {
                    personId = (BUuid)dbBadge.getOwner().getId();
                    supervisorOnly = true;
                }
            }
            OrionCursor cursor = null;
            if (!personId.equals((Object)BUuid.DEFAULT)) {
                cursor = orionSession.select(BPersonPortrait.ORION_TYPE, new PropertyValue(BPersonPortrait.person, (BValue)BRef.make((BTypeSpec)BPerson.TYPE.getTypeSpec(), (BSimple)personId)));
            }
            if (cursor != null && cursor.next()) {
                BPersonPortrait p = (BPersonPortrait)cursor.get();
                this.setPortraitOrd(p.getInMemoryImageOrd());
            } else {
                this.setPortraitOrd(BOrd.DEFAULT);
            }
            this.setPersonId(personId);
            BFormat format = network.getPhotoIDFormat();
            if (supervisorOnly) {
                String newFormatString = format.getFormat();
                if ((newFormatString = TextUtil.replace((String)newFormatString, (String)"%lastBadgeActivity%", (String)("%lastBadgeActivity% " + this.getLexicon().getText("remotely")))).indexOf("%lastPersonName%") > -1) {
                    newFormatString = TextUtil.replace((String)newFormatString, (String)"%lastPersonName%", (String)orionSession.read(BPerson.ORION_TYPE, (BSimple)personId).toDisplayString(null));
                }
                format = BFormat.make((String)newFormatString);
            }
            String strSwipeDetails = format.format((Object)this.remoteReader);
            this.setSwipeDetails(strSwipeDetails);
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
    }

    protected boolean addPlaybackView() {
        return false;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("videoHx:LiveVideoViewer");
        list.toTop("entsec:SecLiveVideo");
        list.toTop("entsecHx:PhotoIdUxCamera");
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getAgentType().is(BVideoPlayback.TYPE) && (!list.get(i).getAgentType().getModuleName().equalsIgnoreCase("videoHx") || !list.get(i).getAgentType().getTypeName().equalsIgnoreCase("HxVideoCamera"))) continue;
            list.remove(list.get(i));
        }
        return list;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box), @Transport(type=TransportType.web)}, permissions="r")
    public void monitorDoorRPC(Context cx) {
        this.monitorDoor();
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box), @Transport(type=TransportType.web)}, permissions="r")
    public void keepAliveMonitorRPC(Context cx) {
        this.keepAliveMonitor();
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.web)}, permissions="r")
    public Object getPortraitOrdRpc(Object useless, Context cx) {
        BOrd sessionOrd = this.getSession().getAbsoluteOrd();
        BOrd ord = BOrd.make((String)(sessionOrd + "|" + this.getPortraitOrd()));
        return ord;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box), @Transport(type=TransportType.web)}, permissions="r")
    public String getImageBytes(Context cx) {
        String byteString = "";
        try {
            BBlob blob = (BBlob)this.getPortraitOrd().get((BObject)BLocalHost.INSTANCE, cx);
            byteString = blob.encodeToString();
        }
        catch (Exception e) {
            Logger.getLogger("entsec").log(Level.SEVERE, "Could not get Image Bytes", e);
        }
        return byteString;
    }

    class RemoteSubscriber
    extends Subscriber {
        BAccessReader remoteReader;
        BFoxSession foxSession;
        String interest;

        public RemoteSubscriber(BAccessReader remoteReader, BFoxSession foxSession, String interest) {
            this.remoteReader = remoteReader;
            this.foxSession = foxSession;
            this.interest = interest;
        }

        public void event(BComponentEvent event) {
            if (event.getSourceComponent() == this.remoteReader && event.getId() == 0 && event.getSlotName().equals(BDoorController.validateTimestamp.getName())) {
                new Thread(new UpdateInfo()).start();
            }
        }

        protected void unsubscribed(BComponent c, Context cx) {
            if (this.foxSession != null) {
                this.foxSession.disengage(this.interest);
                this.foxSession = null;
            }
        }
    }

    class UpdateInfo
    implements Runnable {
        UpdateInfo() {
        }

        @Override
        public void run() {
            BPhotoIDCamera.this.updateInfo();
        }
    }
}

