/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.crop;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.ImageManager;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.raster.viewer.ImageUtil;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.photoID.crop.BCropArea;
import com.tridiumx.entsec.photoID.crop.BPaperRatio;
import com.tridiumx.entsec.photoID.crop.BPaperRatioEnum;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BSize;
import javax.baja.gx.Graphics;
import javax.baja.gx.ISize;
import javax.baja.gx.Point;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBlob;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.util.BUuid;
import javax.baja.workbench.BWbShell;

public class BImageCropPane
extends BCanvasPane {
    public static final Property paperRatio = BImageCropPane.newProperty((int)0, (BValue)BPaperRatio.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BImageCropPane.class);
    public static final RenderingHints highQuality = new RenderingHints(null);
    protected BFileSpace fileSpace;
    protected BWidgetShell shell;
    protected BSize viewSize;
    protected BImage scaled;
    protected BImage original;
    protected BLayout mouseDownLayout = null;
    protected Point lastPoint = new Point(0.0, 0.0);
    protected Point mouseDownPoint = new Point(0.0, 0.0);
    protected boolean moving = false;
    protected boolean newCrop = false;
    protected BCropArea cropArea;
    protected double CROP_MARGIN = 5.0;

    public BPaperRatio getPaperRatio() {
        return (BPaperRatio)this.get(paperRatio);
    }

    public void setPaperRatio(BPaperRatio v) {
        this.set(paperRatio, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BImageCropPane(BWidgetShell shell, BFileSpace fileSpace) {
        this.shell = shell;
        this.fileSpace = fileSpace;
    }

    public void initImage(BImage original, BImage scaled, double width, double height) {
        ImageManager.trimAll();
        this.original = original;
        this.scaled = scaled;
        this.viewSize = BSize.make((ISize)BSize.make((double)width, (double)height));
        this.setViewSize(this.viewSize);
        this.setBackground(BBrush.makeImage((BImage)scaled));
        BLabel cropLabel = new BLabel();
        BBorder border = BBorder.make((double)2.0, (int)3, (BBrush)BBrush.makeSolid((BColor)BColor.red));
        this.cropArea = new BCropArea((BWidget)cropLabel, border);
        this.initRatio();
        this.add("crop", (BValue)this.cropArea);
    }

    public void initRatio() {
        double width = this.viewSize.width;
        double height = this.viewSize.height;
        if (this.getPaperRatio().getUnits() == BPaperRatioEnum.freehand) {
            this.cropArea.setLayout(BLayout.makeAbs((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        } else if (this.getPaperRatio().getUnits() == BPaperRatioEnum.ratio) {
            double imageRatio = width / height;
            double ratio = (double)this.getPaperRatio().getWidth() / (double)this.getPaperRatio().getHeight();
            if (ratio < imageRatio) {
                double newWidth = height * ratio;
                double offset = (width - newWidth) / 2.0;
                this.cropArea.setLayout(BLayout.makeAbs((double)offset, (double)0.0, (double)newWidth, (double)height));
            } else if (ratio > imageRatio) {
                double newHeight = width / ratio;
                double offset = (height - newHeight) / 2.0;
                this.cropArea.setLayout(BLayout.makeAbs((double)0.0, (double)offset, (double)width, (double)newHeight));
            } else {
                this.cropArea.setLayout(BLayout.makeAbs((double)0.0, (double)0.0, (double)width, (double)height));
            }
        }
    }

    public BCropArea getCropArea() {
        return this.cropArea;
    }

    public int save() throws Exception {
        BLayout clipArea = this.getCropArea().getLayout();
        if (Double.compare(clipArea.getWidth(), 0.0) == 0 || Double.compare(clipArea.getHeight(), 0.0) == 0) {
            this.saveWithShell(this.original, this.scaled);
            return 1;
        }
        BImage croppedImage = BImage.make((double)clipArea.getWidth(), (double)clipArea.getHeight());
        Graphics g = croppedImage.getGraphics();
        g.drawImage(this.scaled, -clipArea.getX(), -clipArea.getY());
        g.dispose();
        this.saveWithShell(this.original, croppedImage);
        return 1;
    }

    public void saveWithShell(BImage original, BImage cropped) throws Exception {
        String file = null;
        if (this.shell != null && this.shell instanceof BWbShell) {
            ViewQuery viewQuery = ((BWbShell)this.shell).getActiveOrdTarget().getViewQuery();
            file = viewQuery.getParameter("file", null);
        }
        BImageCropPane.save(original, cropped, file, this.fileSpace, this.shell);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(BImage original, BImage cropped, String fileName, BFileSpace fileSpace, BWidgetShell shell) throws Exception {
        cropped.sync();
        Image image = BImageCropPane.toImage(cropped);
        BufferedImage bufferedImage = new BufferedImage((int)cropped.getWidth(), (int)cropped.getHeight(), 4);
        Graphics2D g = bufferedImage.createGraphics();
        g.setRenderingHints(highQuality);
        bufferedImage.createGraphics().drawImage(image, 0, 0, null);
        bufferedImage.getGraphics().dispose();
        if (fileName == null && (fileName = original.getOrdList().toString()).lastIndexOf("file:") > -1) {
            fileName = fileName.substring(fileName.lastIndexOf("file:") + 5, fileName.length());
        }
        if (fileName.length() == 0) {
            throw new IllegalStateException("Unknown file name for Image");
        }
        if (fileName.indexOf("orionImage") > -1) {
            fileName = TextUtil.replace((String)fileName, (String)"/", (String)".");
            String[] split = TextUtil.split((String)fileName, (char)'.');
            File tempFile = File.createTempFile("orionImage", "." + split[split.length - 1]);
            BOrd tempOrd = BFileSystem.INSTANCE.localFileToOrd(tempFile);
            BIFile newFile = (BIFile)tempOrd.get();
            ImageUtil.write((BIFile)newFile, null, (BufferedImage)bufferedImage);
            byte[] bytes = newFile.read();
            tempFile.deleteOnExit();
            tempFile.delete();
            OrdTarget ordTarget = ((BWbShell)shell).getActiveOrdTarget();
            BFoxSession session = (BFoxSession)ordTarget.getBaseOrdTarget().get();
            BAccessControlService service = (BAccessControlService)session.getService(BAccessControlService.TYPE);
            service.lease();
            OrionSession orionSession = null;
            try {
                orionSession = service.createSession(null);
                BUuid uuid = (BUuid)BUuid.DEFAULT.decodeFromString(split[split.length - 2]);
                BPersonPortrait personPortrait = new BPersonPortrait();
                personPortrait.setImageId(uuid);
                personPortrait.setImage(BBlob.make((byte[])bytes));
                orionSession.persist((BIOrionObject)personPortrait);
            }
            finally {
                if (orionSession != null) {
                    orionSession.close();
                    orionSession = null;
                }
            }
        } else {
            if (fileName.startsWith("file:")) {
                fileName = fileName.substring("file:".length());
            }
            BIFile newFile = fileSpace.makeFile(new FilePath(fileName));
            ImageUtil.write((BIFile)newFile, null, (BufferedImage)bufferedImage);
        }
        original.dispose();
        cropped.dispose();
    }

    public static void setHighQuality(BImage img) {
        Image image = BImageCropPane.toImage(img);
        ((Graphics2D)image.getGraphics()).setRenderingHints(highQuality);
    }

    public static Image toImage(BImage img) {
        ImagePeer peer = ((AwtEnv)GxEnv.get()).makeImagePeer(img);
        return ((AwtImagePeer)peer).image();
    }

    public void mouseMoved(BMouseEvent event) {
        Point cursorPoint = new Point(event.getX(), event.getY());
        this.setCursor(event);
        this.lastPoint = cursorPoint;
    }

    public void mouseReleased(BMouseEvent event) {
        this.newCrop = false;
        this.moving = false;
        this.setCursor(event);
    }

    public void mousePressed(BMouseEvent event) {
        Point cursorPoint = new Point(event.getX(), event.getY());
        if (this.getMouseCursor() != MouseCursor.crosshair && !event.isButton3Down()) {
            this.mouseDownLayout = this.getCropArea().getLayout();
            this.mouseDownPoint = cursorPoint;
            return;
        }
        if (event.isButton3Down()) {
            this.setMouseCursor(MouseCursor.crosshair);
        }
        this.mouseDownPoint = cursorPoint;
        this.mouseDownLayout = BLayout.makeAbs((double)cursorPoint.x(), (double)cursorPoint.y(), (double)0.0, (double)0.0);
        this.getCropArea().setLayout(this.mouseDownLayout);
        this.newCrop = true;
        this.getCropArea().relayout();
    }

    public void mouseDragged(BMouseEvent event) {
        Point cursorPoint = new Point(event.getX(), event.getY());
        double newX = cursorPoint.x();
        double newY = cursorPoint.y();
        double x = this.mouseDownPoint.x();
        double y = this.mouseDownPoint.y();
        if (newX < 0.0) {
            newX = 0.0;
        } else if (newX > this.viewSize.width) {
            newX = this.viewSize.width;
        }
        if (newY < 0.0) {
            newY = 0.0;
        } else if (newY > this.viewSize.height) {
            newY = this.viewSize.height;
        }
        double diffX = newX - x;
        double diffY = newY - y;
        BLayout newLayout = null;
        BLayout layout = this.mouseDownLayout;
        if (this.getMouseCursor() == MouseCursor.crosshair && this.newCrop) {
            if (this.getPaperRatio().getUnits() == BPaperRatioEnum.ratio) {
                double ratio = this.getPaperRatio().getRatio();
                diffY = diffX / ratio;
            }
            if (diffY < 0.0) {
                y += diffY;
                diffY = 0.0 - diffY;
            }
            if (diffX < 0.0) {
                x += diffX;
                diffX = 0.0 - diffX;
            }
            if (y < 0.0) {
                return;
            }
            newLayout = BLayout.makeAbs((double)x, (double)y, (double)diffX, (double)diffY);
        } else if (this.getMouseCursor() == MouseCursor.move) {
            newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)(layout.getY() + diffY), (double)layout.getWidth(), (double)layout.getHeight());
        } else if (this.getPaperRatio().getUnits() == BPaperRatioEnum.freehand) {
            if (this.getMouseCursor() == MouseCursor.nResize) {
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)(layout.getY() + diffY), (double)layout.getWidth(), (double)(layout.getHeight() - diffY));
            } else if (this.getMouseCursor() == MouseCursor.sResize) {
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)layout.getY(), (double)layout.getWidth(), (double)(layout.getHeight() + diffY));
            } else if (this.getMouseCursor() == MouseCursor.wResize) {
                newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)layout.getY(), (double)(layout.getWidth() - diffX), (double)layout.getHeight());
            } else if (this.getMouseCursor() == MouseCursor.eResize) {
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)layout.getY(), (double)(layout.getWidth() + diffX), (double)layout.getHeight());
            } else if (this.getMouseCursor() == MouseCursor.nwResize) {
                newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)(layout.getY() + diffY), (double)(layout.getWidth() - diffX), (double)(layout.getHeight() - diffY));
            } else if (this.getMouseCursor() == MouseCursor.neResize) {
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)(layout.getY() + diffY), (double)(layout.getWidth() + diffX), (double)(layout.getHeight() - diffY));
            } else if (this.getMouseCursor() == MouseCursor.swResize) {
                newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)layout.getY(), (double)(layout.getWidth() - diffX), (double)(layout.getHeight() + diffY));
            } else if (this.getMouseCursor() == MouseCursor.seResize) {
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)layout.getY(), (double)(layout.getWidth() + diffX), (double)(layout.getHeight() + diffY));
            }
        } else if (this.getPaperRatio().getUnits() == BPaperRatioEnum.ratio) {
            double ratio = this.getPaperRatio().getRatio();
            if (this.getMouseCursor() == MouseCursor.nResize) {
                diffX = diffY * ratio;
                newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)(layout.getY() + diffY), (double)(layout.getWidth() - diffX), (double)(layout.getHeight() - diffY));
            } else if (this.getMouseCursor() == MouseCursor.sResize) {
                diffX = diffY * ratio;
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)layout.getY(), (double)(layout.getWidth() + diffX), (double)(layout.getHeight() + diffY));
            } else if (this.getMouseCursor() == MouseCursor.wResize || this.getMouseCursor() == MouseCursor.nwResize || this.getMouseCursor() == MouseCursor.swResize) {
                diffY = diffX / ratio;
                newLayout = BLayout.makeAbs((double)(layout.getX() + diffX), (double)(layout.getY() + diffY), (double)(layout.getWidth() - diffX), (double)(layout.getHeight() - diffY));
            } else if (this.getMouseCursor() == MouseCursor.eResize || this.getMouseCursor() == MouseCursor.neResize || this.getMouseCursor() == MouseCursor.seResize) {
                diffY = diffX / ratio;
                newLayout = BLayout.makeAbs((double)layout.getX(), (double)layout.getY(), (double)(layout.getWidth() + diffX), (double)(layout.getHeight() + diffY));
            }
        }
        if (newLayout != null) {
            this.setCropLayout(newLayout);
        }
    }

    public void setCropLayout(BLayout layout) {
        double x = layout.getX();
        double y = layout.getY();
        double w = layout.getWidth();
        double h = layout.getHeight();
        if (this.getPaperRatio().getUnits() == BPaperRatioEnum.freehand) {
            if (x + w > this.viewSize.width) {
                w = this.viewSize.width - x;
                if (this.getMouseCursor() == MouseCursor.move) {
                    x = this.getCropArea().getLayout().getX();
                    w = this.viewSize.width - x;
                }
            } else if (x < 0.0) {
                x = 0.0;
            }
            if (y + h > this.viewSize.height) {
                h = this.viewSize.height - y;
                if (this.getMouseCursor() == MouseCursor.move) {
                    y = this.getCropArea().getLayout().getY();
                    h = this.viewSize.height - y;
                }
            } else if (y < 0.0) {
                y = 0.0;
            }
        } else if (this.getPaperRatio().getUnits() == BPaperRatioEnum.ratio) {
            double ratio = this.getPaperRatio().getRatio();
            if (x < 0.0) {
                x = 0.0;
            }
            if (x + w > this.viewSize.width) {
                if (this.getMouseCursor() == MouseCursor.move) {
                    x = this.viewSize.width - w;
                } else {
                    w = this.viewSize.width - x;
                }
            }
            if (y < 0.0) {
                y = 0.0;
            }
            if (y + h > this.viewSize.height) {
                if (this.getMouseCursor() == MouseCursor.move) {
                    y = this.viewSize.height - h;
                } else {
                    h = this.viewSize.height - y;
                    w = h * ratio;
                }
            }
        }
        this.getCropArea().setLayout(BLayout.makeAbs((double)x, (double)y, (double)w, (double)h));
        this.getCropArea().relayout();
    }

    public void setCursor(BMouseEvent event) {
        Point cursorPoint = new Point(event.getX(), event.getY());
        if (this.childAt(cursorPoint) != null) {
            if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY()) < this.CROP_MARGIN && Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.nwResize);
            } else if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY() - this.getCropArea().getLayout().getHeight()) < this.CROP_MARGIN && Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX() - this.getCropArea().getLayout().getWidth()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.seResize);
            } else if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY()) < this.CROP_MARGIN && Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX() - this.getCropArea().getLayout().getWidth()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.neResize);
            } else if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY() - this.getCropArea().getLayout().getHeight()) < this.CROP_MARGIN && Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.swResize);
            } else if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.nResize);
            } else if (Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.wResize);
            } else if (Math.abs(cursorPoint.y() - this.getCropArea().getLayout().getY() - this.getCropArea().getLayout().getHeight()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.sResize);
            } else if (Math.abs(cursorPoint.x() - this.getCropArea().getLayout().getX() - this.getCropArea().getLayout().getWidth()) < this.CROP_MARGIN) {
                this.setMouseCursor(MouseCursor.eResize);
            } else {
                this.setMouseCursor(MouseCursor.move);
            }
        } else {
            this.setMouseCursor(MouseCursor.crosshair);
        }
    }

    static {
        highQuality.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        highQuality.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        highQuality.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }
}

