/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID.asureID;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.photoID.BIPhotoIDClientDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceLeaf;
import com.tridiumx.entsec.photoID.BPhotoIDNetwork;
import com.tridiumx.entsec.photoID.BPhotoIDPrintInfo;
import com.tridiumx.entsec.photoID.BPhotoIDTemplate;
import com.tridiumx.entsec.photoID.obix.BPhotoIDLobbyAgent;
import com.tridiumx.entsec.photoID.obix.EntsecObixUtil;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import obix.Err;
import obix.Obj;
import obix.Str;

public class BAsureIDClientDevice
extends BPhotoIDDevice
implements BIPhotoIDClientDevice {
    public static final Property key = BAsureIDClientDevice.newProperty((int)65, (String)"", null);
    public static final Property hostName = BAsureIDClientDevice.newProperty((int)0, (String)"", null);
    public static final Property entsecAsureIDPort = BAsureIDClientDevice.newProperty((int)0, (int)3001, null);
    public static final Property timeout = BAsureIDClientDevice.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)60), null);
    public static final Action wakeUp = BAsureIDClientDevice.newAction((int)16, null);
    public static final Action giveUp = BAsureIDClientDevice.newAction((int)16, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BAsureIDClientDevice.class);
    Object responseCompleted = new Object();
    Object responseMonitor = new Object();
    Object captureLock = new Object();
    boolean capturing = false;
    boolean waitingForResponse = false;
    Obj objResponse;
    BValue valueRequest;
    String requestUri;
    BAbsTime lastComm = BAbsTime.DEFAULT;
    BAbsTime lastAttempt = BAbsTime.DEFAULT;
    Exception commException = null;

    @Override
    public String getKey() {
        return this.getString(key);
    }

    public void setKey(String v) {
        this.setString(key, v, null);
    }

    public String getHostName() {
        return this.getString(hostName);
    }

    public void setHostName(String v) {
        this.setString(hostName, v, null);
    }

    public int getEntsecAsureIDPort() {
        return this.getInt(entsecAsureIDPort);
    }

    public void setEntsecAsureIDPort(int v) {
        this.setInt(entsecAsureIDPort, v, null);
    }

    public BRelTime getTimeout() {
        return (BRelTime)this.get(timeout);
    }

    public void setTimeout(BRelTime v) {
        this.set(timeout, (BValue)v, null);
    }

    public void wakeUp() {
        this.invoke(wakeUp, null, null);
    }

    public void giveUp(BString event) {
        this.invoke(giveUp, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getLicenseAttribute() {
        return "asureId.limit";
    }

    @Override
    public void photoIDStarted() throws Exception {
        super.photoIDStarted();
        this.lastComm = BAbsTime.now();
    }

    public BValue getActionParameterDefault(Action action) {
        try {
            if (action == wakeUp) {
                this.wakeUpClient();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.getActionParameterDefault(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wakeUpClient() throws Exception {
        Socket clientSocket = null;
        FilterOutputStream outToServer = null;
        InputStreamReader inStreamReader = null;
        BufferedReader inFromServer = null;
        try {
            int r;
            this.lease(3);
            clientSocket = new Socket("localhost", this.getEntsecAsureIDPort());
            outToServer = new DataOutputStream(clientSocket.getOutputStream());
            inStreamReader = new InputStreamReader(clientSocket.getInputStream());
            inFromServer = new BufferedReader(inStreamReader);
            ((DataOutputStream)outToServer).writeBytes("asureIDClientPush\n");
            ((DataOutputStream)outToServer).flush();
            StringBuffer replyBuffer = new StringBuffer();
            while ((r = inFromServer.read()) != -1) {
                char ch = (char)r;
                replyBuffer.append(ch);
            }
            String reply = replyBuffer.toString();
            if (reply.equals("OK")) {
                return;
            }
            try {
                throw new Exception("Invalid response '" + reply + "'");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.giveUp(BString.make((String)e.toString()));
            }
        }
        finally {
            try {
                if (outToServer != null) {
                    outToServer.close();
                }
                if (inStreamReader != null) {
                    inStreamReader.close();
                }
                if (inFromServer != null) {
                    inFromServer.close();
                }
                if (clientSocket != null) {
                    clientSocket.close();
                }
            }
            catch (Exception e) {
                System.out.println("Error cleaning up Socket for AsureID:");
                e.printStackTrace();
            }
        }
    }

    public void doWakeUp() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGiveUp(BString cause) {
        this.updateLastAttempt();
        this.lastComm = BAbsTime.DEFAULT;
        this.pingFail("AsureIDClient cannot be reached on last attempt:" + cause);
        if (this.waitingForResponse) {
            Object object = this.responseMonitor;
            synchronized (object) {
                this.commException = new Exception(cause.toString());
                this.responseMonitor.notify();
                this.waitingForResponse = false;
            }
        }
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
    }

    @Override
    public BPhotoIDDeviceLeaf[] discoverDevices() {
        return BPhotoIDLobbyAgent.discoverDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(String hostName, Obj incomingObj, ObixEncoder out) {
        block12: {
            this.lastComm = BAbsTime.now();
            if (this.getStatus().isDown()) {
                this.ping();
            }
            this.setHostName(hostName);
            try {
                if (this.requestUri != null && this.requestUri.length() > 0) {
                    BComponent c = new BComponent();
                    c.add("commandUri", (BValue)BString.make((String)this.requestUri));
                    c.add("commandData", this.valueRequest.newCopy());
                    this.requestUri = null;
                    this.valueRequest = null;
                    out.encodeFully(OrdTarget.unmounted((BObject)c));
                } else {
                    out.encodeFully(OrdTarget.unmounted((BObject)new BComponent()));
                    this.objResponse = incomingObj;
                    if (this.waitingForResponse) {
                        Object c = this.responseMonitor;
                        synchronized (c) {
                            this.responseMonitor.notify();
                            this.waitingForResponse = false;
                        }
                    }
                }
                this.updateLastAttempt();
                this.pingOk();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.lastComm = BAbsTime.DEFAULT;
                this.pingFail("AsureIDClient cannot be reached on last attempt:" + e);
                if (!this.waitingForResponse) break block12;
                Object object = this.responseMonitor;
                synchronized (object) {
                    this.commException = e;
                    this.responseMonitor.notify();
                    this.waitingForResponse = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Obj sendCommandAndWaitForResponse(String uri, BValue commandObj) throws Exception {
        Object object = this.responseMonitor;
        synchronized (object) {
            if (this.waitingForResponse) {
                throw new IllegalStateException("Already waiting on AsureIDClient for another command");
            }
            this.commException = null;
            this.waitingForResponse = true;
            this.valueRequest = commandObj;
            this.requestUri = uri;
            long asureID_Timeout = this.getTimeout().getMillis();
            this.responseMonitor.wait(asureID_Timeout);
            this.updateLastAttempt();
            if (this.commException != null) {
                Exception exception = this.commException;
                this.commException = null;
                throw exception;
            }
            this.waitingForResponse = false;
            Obj myResponse = this.objResponse;
            if (myResponse instanceof Err) {
                Err err = (Err)myResponse;
                String message = err.getName();
                message = TextUtil.replace((String)message, (String)"   ", (String)"\n");
                message = TextUtil.replace((String)message, (String)"\\", (String)"/");
                throw new Exception(TextUtil.split((String)message, (char)'\n')[0], new Exception(message));
            }
            this.objResponse = null;
            return myResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BOrd doCaptureImage() throws Exception {
        if (this.capturing) {
            throw new Exception("Capture Window is already in use.");
        }
        Object object = this.captureLock;
        synchronized (object) {
            this.capturing = true;
            try {
                Obj invokeValue = this.sendCommandAndWaitForResponse("/obix/asureID/capture/", (BValue)BString.make((String)SlotPath.escape((String)"Default")));
                if (invokeValue != null && invokeValue.get("image") instanceof Str) {
                    String hexString = ((Str)invokeValue.get("image")).get();
                    byte[] bytes = EntsecObixUtil.hexStringToByteArray(hexString);
                    if (bytes == null || bytes.length == 0) {
                        BOrd bOrd = BOrd.DEFAULT;
                        return bOrd;
                    }
                    BUuid uuid = BUuid.make();
                    BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)BPhotoIDNetwork.TYPE);
                    BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                    OrionSession session = null;
                    session = service.createSession(null);
                    BPersonPortrait personPortrait = new BPersonPortrait();
                    personPortrait.setImageId(uuid);
                    personPortrait.setImage(BBlob.make((byte[])bytes));
                    BOrionImageFormat imageFormat = network.getDefaultImageFormat();
                    personPortrait.setImageFormat(imageFormat);
                    session.insert((BIOrionObject)personPortrait);
                    BOrd bOrd = personPortrait.getImageOrd();
                    return bOrd;
                }
                if (invokeValue == null) return BOrd.DEFAULT;
                throw new Exception("Invalid Response:" + invokeValue.toString());
            }
            catch (Exception e) {
                throw new Exception("EntsecAsureID Client is not available for capture image", e);
            }
            finally {
                this.capturing = false;
            }
        }
    }

    @Override
    public String[] discoverTemplateNames() throws Exception {
        Obj invokeValue = this.sendCommandAndWaitForResponse("/obix/asureID/templates/", (BValue)new BComponent());
        Obj[] children = invokeValue.list();
        String[] names = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            names[i] = children[i].getName();
        }
        return names;
    }

    @Override
    public BPhotoIDTemplate discoverTemplate(String templateName) throws Exception {
        Obj template = this.sendCommandAndWaitForResponse("/obix/asureID/templates/" + templateName + "/", (BValue)new BComponent());
        BPhotoIDTemplate templateComponent = (BPhotoIDTemplate)EntsecObixUtil.getValue(template, (BValue)new BPhotoIDTemplate());
        return templateComponent;
    }

    @Override
    public void doPrint(BPhotoIDPrintInfo info) throws Exception {
        BComponent sendObject = new BComponent();
        BComponent templates = new BComponent();
        sendObject.add("templates", (BValue)templates);
        BRef[] refs = info.getBadges().getRefs();
        for (int i = 0; i < refs.length; ++i) {
            templates.add(null, (BValue)this.getTemplateForBadge(refs[i]));
        }
        this.sendCommandAndWaitForResponse("/obix/asureID/printer/", (BValue)sendObject);
    }

    public void doPing() throws Exception {
        if (this.getKey().length() == 0) {
            this.pingFail("AsureIDClient has not been identified");
        } else if (this.lastComm.delta(BAbsTime.now()).getMillis() > EntsecObixUtil.STALE_TIME.getMillis()) {
            this.pingFail("AsureIDClient is down");
        } else if (this.commException == null) {
            this.pingOk();
        }
    }

    @Override
    public BAbsTime getLastAttempt() {
        return this.lastAttempt;
    }

    public void updateLastAttempt() {
        BAbsTime now = BAbsTime.now();
        this.lastAttempt = now.equals((Object)this.lastAttempt) ? this.lastAttempt.add(BRelTime.make((long)1L)) : now;
    }
}

