/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.photoID;

import com.tridium.basicdriver.util.BBasicWorker;
import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BIOrionDatabaseObject;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.BOrionSpace;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionAppSchemaManager;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.util.BOrionAppVersion;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.TableBuilder;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.LicenseChecker;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.orionTools.BIMappingService;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.OrionTypeRegistrator;
import com.tridiumx.entsec.photoID.BPhotoIDDevice;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceFolder;
import com.tridiumx.entsec.photoID.BPhotoIDDeviceLearnJob;
import com.tridiumx.entsec.photoID.crop.BPaperRatio;
import com.tridiumx.entsec.photoID.orion.BBadgeTemplate;
import com.tridiumx.entsec.photoID.orion.BMappedPhotoIDTemplateExt;
import com.tridiumx.entsec.photoID.orion.BOrionImageFormat;
import com.tridiumx.entsec.photoID.orion.BPersonPortrait;
import com.tridiumx.entsec.photoID.orion.BPhotoIDTemplateRec;
import com.tridiumx.entsec.photoID.orion.BTenantPhotoIDTemplateJoin;
import com.tridiumx.entsec.photoID.schema.Upgrade_1_0_to_1_1;
import com.tridiumx.entsec.photoID.video.BPhotoIDViewers;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.driver.loadable.BLoadableNetwork;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.RdbmsContext;
import javax.baja.rdb.ddl.DdlCommand;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;

public class BPhotoIDNetwork
extends BLoadableNetwork
implements BIService,
BIOrionApp,
BIOrionDatabaseObject,
BIMappingService {
    public static final Property defaultImageRatio = BPhotoIDNetwork.newProperty((int)0, (BValue)BPaperRatio.RATIO_3_4, null);
    public static final Property defaultImageFormat = BPhotoIDNetwork.newProperty((int)0, (BValue)BOrionImageFormat.jpg, null);
    public static final Property maxImageFileSize = BPhotoIDNetwork.newProperty((int)0, (int)5000, (BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"kilobyte")), (BFacets)BFacets.make((String)"min", (int)1)));
    public static final Property dbOrd = BPhotoIDNetwork.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"rdb:Rdbms"));
    public static final Property photoIDTimeout = BPhotoIDNetwork.newProperty((int)0, (BValue)BRelTime.make((long)0L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)0L)));
    public static final Property photoIDFormat = BPhotoIDNetwork.newProperty((int)0, (BValue)BFormat.make((String)"%lastPersonName%\n%validateTimestamp%\n%lastBadgeActivity%"), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE));
    public static final Property photoIDFontSize = BPhotoIDNetwork.newProperty((int)0, (int)17, null);
    public static final Property photoIDViewers = BPhotoIDNetwork.newProperty((int)0, (BValue)new BPhotoIDViewers(), null);
    public static final Property worker = BPhotoIDNetwork.newProperty((int)4, (BValue)new BBasicWorker(), null);
    public static final Action submitDeviceDiscoveryJob = BPhotoIDNetwork.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BPhotoIDNetwork.class);
    public OrionType[] registeredOrionTypes;
    public static final OrionType[] orionTypes = new OrionType[]{BPhotoIDTemplateRec.ORION_TYPE, BTenantPhotoIDTemplateJoin.ORION_TYPE, BBadgeTemplate.ORION_TYPE, BPersonPortrait.ORION_TYPE};
    public static final BSchemaVersion VERSION_1_1 = BSchemaVersion.make((String)"1.1");
    public static final BSchemaVersion VERSION_1_0 = BSchemaVersion.make((String)"1.0");
    public static final BSchemaVersion CURRENT_VERSION = VERSION_1_1;
    protected OrionAppSchemaManager schemaManager = new OrionAppSchemaManager((BIOrionApp)this, new ISchemaUpgrader[]{new Upgrade_1_0_to_1_1()});
    private MappingSupport mappingSupport = new MappingSupport(this);
    private boolean orionReady = false;
    public static final String VENDOR = "tridium";
    public static final String PHOTO_ID_FEATURE = "secPhotoId";

    public BPaperRatio getDefaultImageRatio() {
        return (BPaperRatio)this.get(defaultImageRatio);
    }

    public void setDefaultImageRatio(BPaperRatio v) {
        this.set(defaultImageRatio, (BValue)v, null);
    }

    public BOrionImageFormat getDefaultImageFormat() {
        return (BOrionImageFormat)this.get(defaultImageFormat);
    }

    public void setDefaultImageFormat(BOrionImageFormat v) {
        this.set(defaultImageFormat, (BValue)v, null);
    }

    public int getMaxImageFileSize() {
        return this.getInt(maxImageFileSize);
    }

    public void setMaxImageFileSize(int v) {
        this.setInt(maxImageFileSize, v, null);
    }

    public BOrd getDbOrd() {
        return (BOrd)this.get(dbOrd);
    }

    public void setDbOrd(BOrd v) {
        this.set(dbOrd, (BValue)v, null);
    }

    public BRelTime getPhotoIDTimeout() {
        return (BRelTime)this.get(photoIDTimeout);
    }

    public void setPhotoIDTimeout(BRelTime v) {
        this.set(photoIDTimeout, (BValue)v, null);
    }

    public BFormat getPhotoIDFormat() {
        return (BFormat)this.get(photoIDFormat);
    }

    public void setPhotoIDFormat(BFormat v) {
        this.set(photoIDFormat, (BValue)v, null);
    }

    public int getPhotoIDFontSize() {
        return this.getInt(photoIDFontSize);
    }

    public void setPhotoIDFontSize(int v) {
        this.setInt(photoIDFontSize, v, null);
    }

    public BPhotoIDViewers getPhotoIDViewers() {
        return (BPhotoIDViewers)this.get(photoIDViewers);
    }

    public void setPhotoIDViewers(BPhotoIDViewers v) {
        this.set(photoIDViewers, (BValue)v, null);
    }

    public BBasicWorker getWorker() {
        return (BBasicWorker)this.get(worker);
    }

    public void setWorker(BBasicWorker v) {
        this.set(worker, (BValue)v, null);
    }

    public BOrd submitDeviceDiscoveryJob() {
        return (BOrd)this.invoke(submitDeviceDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type getDeviceFolderType() {
        return BPhotoIDDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BPhotoIDDevice.TYPE;
    }

    public void started() throws Exception {
        this.getComponentSpace().enableMixIn(BMappedPhotoIDTemplateExt.TYPE);
        this.checkLicensing();
        super.started();
    }

    public BOrd doSubmitDeviceDiscoveryJob() {
        if (this.getStatus().isDisabled()) {
            return null;
        }
        BPhotoIDDeviceLearnJob job = new BPhotoIDDeviceLearnJob();
        return job.submit(null);
    }

    private void checkLicensing() {
        LicenseChecker.getChecker().register(this.getParent(), (Slot)this.getPropertyInParent(), VENDOR, PHOTO_ID_FEATURE, false);
    }

    public void stopped() throws Exception {
        LicenseChecker.getChecker().deregister(this.getParent());
        super.stopped();
    }

    public IFuture postAsync(Runnable r) {
        return this.getWorker().post(r);
    }

    public void changed(Property property, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(dbOrd) && Sys.getStation().isRunning()) {
            this.configFatal("Database ORD changed, restart required.");
        }
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value instanceof BPhotoIDDevice) {
            BPhotoIDDevice device = (BPhotoIDDevice)value;
            if (device.network != null) {
                return;
            }
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
                if (device.getLicenseAttribute() == null) {
                    return;
                }
                String attr = feature.get(device.getLicenseAttribute());
                if (attr == null) {
                    throw new IllegalStateException(attr + " is not licensed.");
                }
                if (attr.equals("none")) {
                    return;
                }
                int allowed = Integer.parseInt(attr);
                Integer currentCount = (Integer)this.fw(503, device.getLicenseAttribute(), null, null, null);
                if (currentCount >= allowed) {
                    throw new IllegalStateException("Exceeded " + attr + " of " + allowed + ".");
                }
            }
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE, BIMappingService.TYPE};
    }

    public void serviceStarted() {
        this.checkConfig();
        if (!this.getStatus().isFault()) {
            this.registerApp();
        }
    }

    public void serviceStopped() {
        this.getComponentSpace().disableMixIn(BMappedPhotoIDTemplateExt.TYPE);
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature(VENDOR, PHOTO_ID_FEATURE);
    }

    public BSchemaVersion getSchemaVersion() {
        return CURRENT_VERSION;
    }

    public void performSchemaUpgrade(BLocalOrionDatabase orionDatabase, BSchemaVersion oldVersion) throws Exception {
        this.schemaManager.performSchemaUpgrade(orionDatabase, oldVersion);
    }

    public void orionReady(BOrionDatabase db) {
        this.orionReady = true;
        BPersonPortrait.startTempCleaner();
    }

    @Override
    public boolean isOrionReady() {
        return this.orionReady;
    }

    @Override
    public void mappedRemoved(BComponent c) {
        this.mappingSupport.mappedRemoved(c);
    }

    @Override
    public void mappedAdded(BComponent c) {
        this.mappingSupport.mappedAdded(c);
    }

    @Override
    public void mappedUpdate(BComponent c) {
        this.mappingSupport.mappedUpdate(c);
    }

    @Override
    public void mappedPersist(BComponent c) {
        this.mappingSupport.mappedPersist(c);
    }

    public OrionType[] getOrionTypes() {
        if (!this.orionReady || this.registeredOrionTypes == null) {
            this.registeredOrionTypes = OrionTypeRegistrator.getDistictOrionTypes(this, orionTypes, this.registeredOrionTypes);
        }
        return this.registeredOrionTypes;
    }

    public void checkConfig() {
        if (this.getDbOrd().isNull()) {
            try {
                BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                this.setDbOrd(service.getDbOrd());
                this.configFatal("Database ORD changed, restart required.");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.configFatal("Database ORD not configured.");
            }
            return;
        }
        BRdbms rdbms = null;
        try {
            rdbms = (BRdbms)this.getDbOrd().resolve((BObject)this).get();
        }
        catch (Exception ex) {
            this.configFatal("Database ORD not configured properly.");
            ex.printStackTrace();
        }
    }

    public void registerApp() {
        BOrionService service = (BOrionService)Sys.getService((Type)BOrionService.TYPE);
        BRdbms rdbms = this.getRdbms();
        ((BLocalOrionDatabase)service.getOrionDatabase(rdbms)).registerApp((BIOrionApp)this);
    }

    public BRdbms getRdbms() {
        if (this.getDbOrd().isNull()) {
            throw new OrionException("Database ORD not configured.");
        }
        return (BRdbms)this.getDbOrd().resolve((BObject)this).get();
    }

    @Override
    public BOrionDatabase getOrionDatabase() {
        BRdbms rdbms = this.getRdbms();
        BOrionSpace orionSpace = (BOrionSpace)BOrd.make((String)"orion:").resolve((BObject)this).get();
        return orionSpace.getOrionDatabase(rdbms);
    }

    public OrionSession createSession(Context cx) {
        return this.getOrionDatabase().createSession(cx);
    }

    public static boolean isOrionAvailable() {
        try {
            BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)TYPE);
            return network.isOrionReady();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.box), @Transport(type=TransportType.web)}, permissions="r")
    public BAccReaderRec readReaderRPC(Object readerUuid, Context cx) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)TYPE);
        OrionSession orionSession = null;
        BAccReaderRec rec = null;
        try {
            orionSession = network.createSession(null);
            rec = (BAccReaderRec)orionSession.read(BAccReaderRec.ORION_TYPE, (BSimple)((BUuid)readerUuid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NiagaraRpc(transports={@Transport(type=TransportType.fox), @Transport(type=TransportType.web)}, permissions="r")
    public Object touchImageRPC(Object o, Context cx) {
        BPhotoIDNetwork network = (BPhotoIDNetwork)Sys.getService((Type)TYPE);
        OrionSession orionSession = null;
        try {
            orionSession = network.createSession(null);
            BPersonPortrait portrait = BPersonPortrait.readFromImageOrd((BOrd)o, orionSession);
            portrait.getImageOrd();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
        return null;
    }

    public void unregisterApp(OrionSession session, Context cx) {
        BEnterpriseSecurityService.LOG.info("Begin unregisterApp: " + TYPE);
        RdbmsContext rcx = session.getRdbmsContext();
        BOrionAppVersion orionAppVersion = (BOrionAppVersion)session.read(BOrionAppVersion.ORION_TYPE, new PropertyValue(BOrionAppVersion.app, (BValue)this.getType().getTypeSpec()));
        if (orionAppVersion == null) {
            BEnterpriseSecurityService.LOG.info("UnregisterApp canceled, app not registered: " + TYPE);
            return;
        }
        TableBuilder[] builders = new TableBuilder[]{new TableBuilder(session.getOrionDatabase(), BPhotoIDTemplateRec.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BTenantPhotoIDTemplateJoin.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BBadgeTemplate.ORION_TYPE), new TableBuilder(session.getOrionDatabase(), BPersonPortrait.ORION_TYPE)};
        for (int i = builders.length - 1; i >= 0; --i) {
            this.dropTable(session, builders[i]);
        }
        session.delete((BIOrionObject)orionAppVersion);
        BEnterpriseSecurityService.LOG.info("UnregisterApp complete: " + TYPE);
    }

    private void dropTable(OrionSession session, TableBuilder tb) {
        BEnterpriseSecurityService.LOG.info("dropping table " + tb.getTableName());
        DdlCommand[] ddl = tb.dropTable();
        for (int i = 0; i < ddl.length; ++i) {
            try {
                session.invokeDdl(ddl[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                BEnterpriseSecurityService.LOG.log(Level.INFO, e.getMessage(), e);
            }
        }
    }
}

