/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.ui;

import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.DynamicTableResultModel;
import com.tridium.orion.priv.ui.BDynamicTableView;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridiumx.entsec.orionTools.ui.BOrionSummary;
import javax.baja.agent.AgentFilter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;

public class BAppTableView
extends BDynamicTableView {
    public static final Type TYPE = Sys.loadType(BAppTableView.class);
    private BAbstractOrionApp service;
    protected Command addCmd;
    protected Command deleteCmd;
    protected Command refreshCmd;
    protected Command editCmd;

    public Type getType() {
        return TYPE;
    }

    public CommandBindings makeCommandBindings() {
        CommandBindings result = super.makeCommandBindings();
        this.editCmd = new EditCommand();
        result.addCommand(this.editCmd, BCommandEnablePolicy.singleSelection);
        if (!this.isMapped()) {
            this.deleteCmd = new DeleteCommand();
            result.addCommand(this.deleteCmd, BCommandEnablePolicy.anySelection);
        }
        return result;
    }

    public Command[] getButtonCommands() {
        if (this.isMapped()) {
            this.filter = new BDynamicTableView.FilterCommand((BDynamicTableView)this);
            this.refreshCmd = new RefreshCommand();
            return new Command[]{this.hyperlinkCommand, this.editCmd, this.filter, this.refreshCmd};
        }
        this.addCmd = new AddCommand();
        this.filter = new BDynamicTableView.FilterCommand((BDynamicTableView)this);
        this.refreshCmd = new RefreshCommand();
        return new Command[]{this.addCmd, this.hyperlinkCommand, this.editCmd, this.deleteCmd, this.filter, this.refreshCmd};
    }

    public boolean isMapped() {
        BDynamicTable dt = (BDynamicTable)this.getCurrentValue();
        return dt.getRowType().getTypeSpec().getTypeInfo().is(BIMappable.TYPE);
    }

    public void reloadTable() {
        this.loadValue(this.getCurrentValue(), this.getCurrentContext());
    }

    public BAbstractOrionApp getAppService() {
        if (this.service == null) {
            BDynamicTable table = (BDynamicTable)this.getCurrentValue();
            this.service = (BAbstractOrionApp)table.getAppOrd().resolve(this.getCurrentValue()).get();
        }
        return this.service;
    }

    public CommandArtifact commandDialog(BWbEditor editor, BObject value, String dialogTitle, Context cx) {
        if (editor == null) {
            editor = (BWbEditor)Sys.getRegistry().getAgents(value.getType().getTypeInfo()).filter(AgentFilter.is((Type)BWbEditor.TYPE)).getDefault().getInstance();
        }
        editor.loadValue(value, cx);
        int rc = BDialog.open((BWidget)this, (String)dialogTitle, (Object)editor, (int)3);
        if (rc == 2) {
            return null;
        }
        try {
            value = editor.saveValue(value, cx);
        }
        catch (Exception ex) {
            throw new OrionException("Cannot edit object.", (Throwable)ex);
        }
        this.reloadTable();
        return null;
    }

    public CommandArtifact addObject() throws Exception {
        BIOrionObject newObj = this.getNewSubject();
        String title = Lexicon.make((BModule)TYPE.getModule(), (Context)this.getCurrentContext()).getText("new") + " " + newObj.getType().getDisplayName(this.getCurrentContext());
        return this.commandDialog(null, (BObject)newObj, title, this.getCurrentContext());
    }

    public BIOrionObject getNewSubject() {
        BDynamicTable appTable = (BDynamicTable)this.getCurrentValue();
        BOrionTypeId typeId = appTable.getRowType();
        OrionType type = this.getAppService().getOrionDatabase().getType(typeId);
        BIOrionObject newObj = (BIOrionObject)type.getInstance();
        newObj.setOrionDatabase(this.getAppService().getOrionDatabase());
        return newObj;
    }

    public BIOrionObject getSubject() {
        int[] selection = this.table.getSelection().getRows();
        if (selection.length != 1) {
            throw new IllegalStateException("There may only be one selection, not " + selection.length + ".");
        }
        BIOrionObject editObj = ((DynamicTableResultModel)this.table.getModel()).getResolvedSubject(selection[0]);
        return editObj;
    }

    public CommandArtifact editSelection() throws Exception {
        BIOrionObject editObj = this.getSubject();
        String title = Lexicon.make((BModule)TYPE.getModule(), (Context)this.getCurrentContext()).getText("edit") + " " + editObj.getType().getDisplayName(this.getCurrentContext());
        return this.commandDialog(null, (BObject)editObj, title, this.getCurrentContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact deleteSelection() {
        int[] selection = this.table.getSelection().getRows();
        if (selection.length == 0) {
            return null;
        }
        OrionSession session = null;
        try {
            session = this.getAppService().createSession(this.getCurrentContext());
            for (int i = 0; i < selection.length; ++i) {
                BIOrionObject toDelete = ((DynamicTableResultModel)this.table.getModel()).getResolvedSubject(selection[i]);
                session.delete(toDelete);
            }
        }
        catch (Exception ex) {
            Lexicon lex = Lexicon.make((BModule)TYPE.getModule(), (Context)this.getCurrentContext());
            BDialog.error((BWidget)this, (String)lex.getText("deleteFailed"), (Object)lex.getText("deleteSelectionFailed"), (Throwable)ex);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
        this.reloadTable();
        return null;
    }

    public CommandArtifact refresh() {
        this.reloadTable();
        return null;
    }

    private void err(String msg) {
        this.setContent((BWidget)new BLabel(msg));
    }

    protected class SummaryCommand
    extends Command {
        public SummaryCommand() {
            super((BWidget)BAppTableView.this, TYPE.getModule(), "tableCmd.summary");
        }

        public CommandArtifact doInvoke() {
            BOrionSummary summary = new BOrionSummary();
            summary.setReadonly(true);
            summary.loadValue((BObject)((BComponent)BAppTableView.this.getSubject()));
            int rc = BDialog.open((BWidget)BAppTableView.this, (String)this.getLabel(), (Object)((Object)summary), (int)1);
            return null;
        }
    }

    protected class RefreshCommand
    extends Command {
        public RefreshCommand() {
            super((BWidget)BAppTableView.this, TYPE.getModule(), "tableCmd.refresh");
        }

        public CommandArtifact doInvoke() {
            return BAppTableView.this.refresh();
        }
    }

    protected class EditCommand
    extends Command {
        public EditCommand() {
            super((BWidget)BAppTableView.this, TYPE.getModule(), "tableCmd.edit");
        }

        public CommandArtifact doInvoke() {
            try {
                return BAppTableView.this.editSelection();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    protected class DeleteCommand
    extends Command {
        public DeleteCommand() {
            super((BWidget)BAppTableView.this, TYPE.getModule(), "tableCmd.delete");
        }

        public CommandArtifact doInvoke() {
            return BAppTableView.this.deleteSelection();
        }
    }

    protected class AddCommand
    extends Command {
        public AddCommand() {
            super((BWidget)BAppTableView.this, TYPE.getModule(), "tableCmd.add");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BAppTableView.this.addObject();
        }
    }
}

