/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BatchStatement;
import com.tridium.program.BProgram;
import com.tridium.util.EscUtil;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import javax.baja.fox.BFoxProxySession;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;

public abstract class Replicator
implements Comparable {
    private static final EscUtil ESC = new EscUtil(){

        public boolean isStart(int c) {
            return c != 59;
        }

        public boolean isPart(int c) {
            return c != 59;
        }
    };
    private HashSet versionSafeTypes = new HashSet();
    private static final String LAST_MODIFIED = BDeletion.lastModified.getName();
    private static final OrionType TYPE_D = BDeletion.ORION_TYPE;
    private static final String D = BAppTable.getTableName(TYPE_D);
    private static final String DEL_TYPE_SPEC = BDeletion.delTypeSpec.getName();
    protected static final String SQL_D = "select * from " + D + " where " + DEL_TYPE_SPEC + " = ? and " + LAST_MODIFIED + " > ?";
    public static String REPLICATING = "REPLICATING";
    public static int CHUNK_SIZE = 500;
    public static int EXECUTE_SIZE = 10000;
    protected BAbsTime repStartTime;
    private OrionSession supSession = null;

    protected abstract BAbstractOrionApp getSupervisorOrionApp();

    protected abstract BOrd getJaceOrionAppOrd();

    protected abstract void doReplicate(OrionSession var1, BAbsTime var2, String var3, boolean var4, BSafeSimpleJob var5, BFacets var6) throws Exception;

    protected abstract void doCleanSupervisorDeletionTable(BAbsTime var1) throws Exception;

    protected abstract void doCleanJaceDeletionTable(OrionSession var1, BAbsTime var2) throws Exception;

    public final void openSupervisorSession() {
        this.supSession = Replicator.makeOrionSession(this.getSupervisorOrionApp());
    }

    protected void beforeReplicate(BAbsTime begin) throws Exception {
        this.repStartTime = begin;
    }

    public final void closeSupervisorSession() {
        if (this.supSession != null) {
            this.supSession.close();
            this.supSession = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void replicate(BFoxProxySession jaceProxy, BAbsTime timestamp, String stationName, boolean replicateFromJace, BSafeSimpleJob job, BFacets facets) throws Exception {
        OrionSession jaceSession = null;
        try {
            BAbstractOrionApp jaceApp = (BAbstractOrionApp)this.getJaceOrionAppOrd().get((BObject)jaceProxy);
            jaceApp.lease();
            jaceSession = Replicator.makeOrionSession(jaceApp);
            this.doReplicate(jaceSession, timestamp, stationName, replicateFromJace, job, facets);
        }
        finally {
            if (jaceSession != null) {
                jaceSession.close();
                jaceSession = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanJaceDeletionTable(BFoxProxySession jaceProxy, BAbsTime timestamp) throws Exception {
        OrionSession jaceSession = null;
        try {
            BAbstractOrionApp jaceApp = (BAbstractOrionApp)this.getJaceOrionAppOrd().get((BObject)jaceProxy);
            jaceApp.lease();
            jaceSession = Replicator.makeOrionSession(jaceApp);
            this.doCleanJaceDeletionTable(jaceSession, timestamp);
        }
        finally {
            if (jaceSession != null) {
                jaceSession.close();
                jaceSession = null;
            }
        }
    }

    protected final void pullPersist(OrionSession jaceSession, BAbsTime timestamp, OrionType type, String sql, OrionSession superSession) throws Exception {
        this.logTrace("pullPersist begin " + type);
        OrionCursor jaceCursor = jaceSession.select(type, sql, new BSimple[]{timestamp, this.repStartTime});
        BatchStatement supPersist = superSession.batchPersist(type);
        supPersist.setChunkSize(CHUNK_SIZE);
        while (jaceCursor.next()) {
            BReplicableObject obj = (BReplicableObject)((Object)jaceCursor.get());
            BReplicableObject newObj = (BReplicableObject)obj.getOrionType().getInstance();
            newObj.copyFrom((BIOrionObject)obj);
            supPersist.add((BIOrionObject)newObj);
            if (supPersist.size() <= EXECUTE_SIZE) continue;
            supPersist.execute();
        }
        this.logTrace("pullPersist execute " + supPersist.size());
        supPersist.execute();
        this.logTrace("pullPersist end");
    }

    protected final void pullDelete(OrionSession jaceSession, BAbsTime timestamp, OrionType type, OrionSession superSession) throws Exception {
        this.logTrace("pullDelete begin " + type);
        OrionCursor jaceCursor = jaceSession.select(BDeletion.ORION_TYPE, SQL_D, new BSimple[]{type.getTypeSpec(), timestamp});
        BatchStatement supDelete = superSession.batchDelete(type);
        supDelete.setChunkSize(CHUNK_SIZE);
        while (jaceCursor.next()) {
            BDeletion del = (BDeletion)((Object)jaceCursor.get());
            BReplicableObject newObj = Replicator.createRecordFromDeletion(del, type);
            supDelete.add((BIOrionObject)newObj);
            if (supDelete.size() <= EXECUTE_SIZE) continue;
            supDelete.execute();
        }
        this.logTrace("pullDelete execute " + supDelete.size());
        supDelete.execute();
        this.logTrace("pullDelete end");
    }

    protected final void pushPersist(OrionSession jaceSession, BAbsTime timestamp, OrionType type, String sql, OrionSession superSession) {
        this.logTrace("pushPersist begin " + type);
        OrionCursor cursor = superSession.select(type, sql, new BSimple[]{timestamp, this.repStartTime});
        if (this.versionSafeTypes.contains(type)) {
            BProgram program = this.getVersionSafeDbOrionSession(jaceSession);
            while (cursor.next()) {
                this.persistVersionSafe((BOrionObject)cursor.get(), program);
            }
            return;
        }
        BatchStatement jacePersist = jaceSession.batchPersist(type);
        jacePersist.setChunkSize(CHUNK_SIZE);
        while (cursor.next()) {
            BIOrionObject obj = (BIOrionObject)cursor.get();
            BReplicableObject newObj = Replicator.cloneRecord(obj, type);
            jacePersist.add((BIOrionObject)newObj);
            if (jacePersist.size() <= EXECUTE_SIZE) continue;
            jacePersist.execute();
        }
        this.logTrace("pushPersist execute " + jacePersist.size());
        jacePersist.execute();
        this.logTrace("pushPersist end");
    }

    protected final void pushDelete(OrionSession jaceSession, BAbsTime timestamp, OrionType type, OrionSession superSession) throws Exception {
        this.logTrace("pushDelete begin " + type);
        OrionCursor supCursor = superSession.select(BDeletion.ORION_TYPE, SQL_D, new BSimple[]{type.getTypeSpec(), timestamp});
        if (this.versionSafeTypes.contains(type)) {
            BProgram program = this.getVersionSafeDbOrionSession(jaceSession);
            while (supCursor.next()) {
                this.deleteVersionSafe((BOrionObject)supCursor.get(), program);
            }
            return;
        }
        BatchStatement jaceDelete = jaceSession.batchDelete(type);
        jaceDelete.setChunkSize(CHUNK_SIZE);
        while (supCursor.next()) {
            BDeletion del = (BDeletion)((Object)supCursor.get());
            BReplicableObject newObj = Replicator.createRecordFromDeletion(del, type);
            jaceDelete.add((BIOrionObject)newObj);
            if (jaceDelete.size() <= EXECUTE_SIZE) continue;
            jaceDelete.execute();
        }
        this.logTrace("pushDelete execute " + jaceDelete.size());
        jaceDelete.execute();
        this.logTrace("pushDelete end");
    }

    protected void persistVersionSafe(BOrionObject o, BProgram program) {
        program.invoke(program.getAction("persist"), (BValue)o);
    }

    protected void deleteVersionSafe(BOrionObject o, BProgram program) {
        program.invoke(program.getAction("delete"), (BValue)o);
    }

    protected BProgram getVersionSafeDbOrionSession(OrionSession jaceSession) {
        try {
            BFoxOrionDatabase db = (BFoxOrionDatabase)jaceSession.getOrionDatabase();
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)((BFoxOrionSpace)db.getOrionSpace()).getFoxSession().getService(BEnterpriseSecurityService.TYPE);
            service.lease();
            BProgram program = (BProgram)service.get("DbOrionSession");
            if (program != null) {
                program.lease();
                return program;
            }
            BBogFile file = (BBogFile)BOrd.make((String)"module://entsec/rc/DbOrionSession.bog").get();
            program = (BProgram)file.readComponents().getValue(0).asComponent().newCopy();
            service.add("DbOrionSession", (BValue)program, 7);
            program = (BProgram)service.get("DbOrionSession");
            program.lease();
            return program;
        }
        catch (Exception e) {
            throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected final void pushPersistPerJace(OrionSession jaceSession, BAbsTime timestamp, int numTimestamps, String stationName, OrionType type, String sql, boolean insertOnly, OrionSession superSession) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            return;
        }
        OrionCursor supCursor = this.getCursor(timestamp, numTimestamps, stationName, type, sql, superSession);
        if (this.versionSafeTypes.contains(type)) {
            BProgram program = this.getVersionSafeDbOrionSession(jaceSession);
            while (supCursor.next()) {
                this.persistVersionSafe((BOrionObject)supCursor.get(), program);
            }
            return;
        }
        if (insertOnly) {
            this.logTrace("pushPersistPerJace schedules begin " + type);
            while (supCursor.next()) {
                BIOrionObject supRec = (BIOrionObject)supCursor.get();
                BReplicableObject clonedObj = Replicator.cloneRecord(supRec, type);
                if (jaceSession.exists((BIOrionObject)clonedObj)) continue;
                jaceSession.insert((BIOrionObject)clonedObj);
            }
            this.logTrace("pushPersistPerJace schedules end");
        } else {
            this.logTrace("pushPersistPerJace begin " + type);
            BatchStatement jacePersist = jaceSession.batchPersist(type);
            jacePersist.setChunkSize(CHUNK_SIZE);
            while (supCursor.next()) {
                BIOrionObject supRec = (BIOrionObject)supCursor.get();
                BReplicableObject clonedObj = Replicator.cloneRecord(supRec, type);
                jacePersist.add((BIOrionObject)clonedObj);
                if (jacePersist.size() <= EXECUTE_SIZE) continue;
                jacePersist.execute();
            }
            this.logTrace("pushPersistPerJace execute " + jacePersist.size());
            jacePersist.execute();
            this.logTrace("pushPersistPerJace end");
        }
    }

    protected final void pushPersistPerJace(OrionSession jaceSession, HashMap map, String stationName, OrionType type, OrionSession superSession) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            return;
        }
        if (map == null || map.isEmpty()) {
            return;
        }
        this.logTrace("pushPersistPerJace2 begin " + type);
        BatchStatement jacePersist = jaceSession.batchPersist(type);
        jacePersist.setChunkSize(CHUNK_SIZE);
        Collection collection = map.values();
        for (BReplicableObject obj : collection) {
            jacePersist.add((BIOrionObject)obj);
            if (jacePersist.size() <= EXECUTE_SIZE) continue;
            jacePersist.execute();
        }
        this.logTrace("pushPersistPerJace2 execute " + jacePersist.size());
        jacePersist.execute();
        this.logTrace("pushPersistPerJace2 end");
    }

    protected final void pushPersistPerJace(OrionSession jaceSession, Array a, String stationName, OrionType type, OrionSession superSession) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            return;
        }
        BatchStatement jacePersist = jaceSession.batchPersist(type);
        jacePersist.setChunkSize(CHUNK_SIZE);
        for (BReplicableObject obj : a) {
            jacePersist.add((BIOrionObject)obj);
            if (jacePersist.size() <= EXECUTE_SIZE) continue;
            jacePersist.execute();
        }
        jacePersist.execute();
    }

    protected final void pushPersistPerJaceNoBatch(OrionSession jaceSession, Array a, String stationName, OrionType type, OrionSession superSession) {
        if (stationName.equals(Sys.getStation().getStationName())) {
            return;
        }
        for (BReplicableObject obj : a) {
            jaceSession.persist((BIOrionObject)obj);
        }
    }

    protected static final BReplicableObject createRecordFromDeletion(BDeletion del, OrionType type) throws Exception {
        BReplicableObject obj = (BReplicableObject)type.getTypeSpec().getInstance();
        String[] kv = TextUtil.split((String)del.getDelKey(), (char)';');
        for (int j = 0; j < kv.length; ++j) {
            String[] tokens = TextUtil.split((String)kv[j], (char)'=');
            String k = tokens[0];
            String v = ESC.unescape(tokens[1]);
            Property prop = obj.getProperty(k);
            BValue val = (BValue)((BSimple)prop.getDefaultValue()).decodeFromString(v);
            obj.init(prop, val);
        }
        BReplicableObject newObj = (BReplicableObject)obj.getOrionType().getInstance();
        newObj.copyFrom((BIOrionObject)obj);
        return newObj;
    }

    protected final OrionCursor getCursor(BAbsTime timestamp, int numTimestamps, String stationName, OrionType type, String sql, OrionSession superSession) {
        int noOfParams = numTimestamps * 2 + 1;
        BSimple[] params = new BSimple[noOfParams];
        for (int i = 0; i < noOfParams; ++i) {
            params[i] = (i & 1) == 0 ? timestamp : this.repStartTime;
        }
        params[noOfParams - 1] = BString.make((String)stationName);
        return superSession.select(type, sql, params);
    }

    protected final OrionCursor getCursorForThreat(BAbsTime timestamp, int numTimestamps, String stationName, OrionType type, String sql, OrionSession superSession) {
        int noOfParams = numTimestamps * 2 + 1;
        BSimple[] params = new BSimple[noOfParams];
        for (int i = 0; i < noOfParams; ++i) {
            params[i] = (i & 1) == 0 ? timestamp : this.repStartTime;
        }
        params[noOfParams - 1] = BString.make((String)stationName);
        params[0] = BAbsTime.DEFAULT;
        return superSession.select(type, sql, params);
    }

    public static final OrionSession makeOrionSession(BAbstractOrionApp app) {
        return app.createSession((Context)new BasicContext((Context)null, BFacets.make((String)REPLICATING, (boolean)true)));
    }

    public static final OrionSession makeOrionSession(BAbstractOrionApp app, String stationName) {
        return app.createSession((Context)new BasicContext((Context)null, BFacets.make((String)(REPLICATING + stationName), (boolean)true)));
    }

    protected static final BReplicableObject cloneRecord(BIOrionObject from, OrionType type) {
        BReplicableObject to = (BReplicableObject)type.getInstance();
        Property[] frozen = to.getFrozenPropertiesArray();
        for (int i = 0; i < frozen.length; ++i) {
            to.set(frozen[i], from.get(frozen[i].getName()));
        }
        return to;
    }

    public int getSupervisorDeletionTableCount() {
        return CountingUtil.getCount((OrionType)BDeletion.ORION_TYPE, (OrionSession)this.supSession);
    }

    protected static final void cleanDeletionTable(OrionSession session, BAbsTime timestamp) {
        String sql = Replicator.makeCleanSql();
        BSimple[] params = new BSimple[]{timestamp};
        session.delete(sql, params);
    }

    private static final String makeCleanSql() {
        String tableName = BAppTable.getTableName(BDeletion.ORION_TYPE);
        String lastModified = BDeletion.lastModified.getName();
        StringBuffer sb = new StringBuffer();
        sb.append("delete from " + tableName + " where ");
        sb.append(lastModified).append(" < ?");
        return sb.toString();
    }

    protected final void logTrace(String msg) {
        if (BReplicationService.LOG.isLoggable(Level.FINE)) {
            BReplicationService.LOG.fine(msg);
        }
    }

    public void clearVersionSafe() {
        this.versionSafeTypes.clear();
    }

    public void addVersionSafeType(OrionType orionType) {
        this.versionSafeTypes.add(orionType);
    }

    protected void setRepStartTime(BAbsTime startTime) {
        this.repStartTime = startTime;
    }

    protected final OrionSession getSupervisorSession() {
        return this.supSession;
    }
}

