/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.platform.BSystemPlatformService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationService;
import com.tridiumx.entsec.orionTools.replicate.BReplicationStationRunner;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.baja.driver.BDevice;
import javax.baja.fox.BFoxProxySession;
import javax.baja.job.JobCancelException;
import javax.baja.license.Feature;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.security.BIUserCredentials;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

public class ReplicationManager {
    private static final BFacets noMillis = BFacets.make((String)"showMilliseconds", (boolean)false);
    private static final BOrd SYS_PLATFORM_ORD = BOrd.make((String)"service:platform:SystemPlatformService");
    private static final BOrd REPLICATION_ORD = BOrd.make((String)"service:entsec:ReplicationService");
    private static Version supervisorSoftwareVersion = new Version(((BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE)).getSoftwareVersion());
    private static final int REV_DIFFERENCE = 1;
    private boolean missingSubordinate = false;
    private BSafeSimpleJob job;
    private BReplicationService rs;
    private Replicator[] replicators;
    private BFacets facets;

    public ReplicationManager(BReplicationService rs, BFacets facets) {
        this(rs, null, facets);
    }

    public ReplicationManager(BReplicationService rs, BSafeSimpleJob job, BFacets facets) {
        this.rs = rs;
        this.replicators = rs.getReplicators();
        this.job = job;
        this.facets = facets;
    }

    boolean replicateAllStations() throws Exception {
        boolean succeeded = true;
        BAbsTime begin = BAbsTime.now();
        try {
            int i;
            this.logMessage("Begin replicating all subordinate stations.");
            int num_of_threads = this.rs.getReplicationExecutorLimit();
            this.logMessage("Num of Replication Executors..." + num_of_threads);
            ExecutorService pool = Executors.newFixedThreadPool(num_of_threads);
            for (int i2 = 0; i2 < this.replicators.length; ++i2) {
                this.replicators[i2].openSupervisorSession();
                this.replicators[i2].beforeReplicate(begin);
            }
            if (this.job != null) {
                this.job.checkCancel(null);
            }
            BNiagaraStation[] stations = this.lookupAllStations();
            this.checkLicensing();
            Runnable[] runnable = new Runnable[stations.length];
            BAbsTime leastTimestamp = null;
            for (i = 0; i < stations.length; ++i) {
                if (this.job != null) {
                    this.job.checkCancel(null);
                    this.job.progress((int)(100.0 * (double)i / (double)stations.length));
                }
                runnable[i] = new BReplicationStationRunner(this.job, stations[i], begin, this, leastTimestamp, succeeded, this.rs);
                pool.submit(runnable[i]);
                continue;
            }
            pool.shutdown();
            while (!pool.isTerminated()) {
            }
            for (i = 0; i < stations.length; ++i) {
                succeeded &= ((BReplicationStationRunner)runnable[i]).isSucceeded();
                BAbsTime leastTimestampOfStation = ((BReplicationStationRunner)runnable[i]).getLeastTimestamp();
                if (leastTimestamp != null && leastTimestamp.compareTo((Object)leastTimestampOfStation) <= 0) continue;
                leastTimestamp = leastTimestampOfStation;
            }
            if (succeeded && !this.missingSubordinate) {
                if (succeeded && leastTimestamp != null) {
                    this.logMessage("Clean BDeletion records upto: " + leastTimestamp.getMillis());
                    for (int j = 0; j < this.replicators.length; ++j) {
                        this.replicators[j].doCleanSupervisorDeletionTable(leastTimestamp);
                    }
                }
            } else if (succeeded) {
                String msg = "At least one joined station could not be replicated because it was skipped.";
                this.logWarning(msg);
                int count = this.replicators[0].getSupervisorDeletionTableCount();
                if (count > this.rs.getReplicationOverrunLimit()) {
                    msg = "All stations need to replicate, Replication Overrun Limit has been reached: " + count + " > " + this.rs.getReplicationOverrunLimit();
                    this.logError(msg, null);
                    this.rs.generateOverrunAlarm(msg);
                }
            }
        }
        catch (JobCancelException e) {
            throw e;
        }
        catch (Exception e) {
            succeeded = false;
            e.printStackTrace();
            String msg = "Failed replicating all stations: " + e.getMessage();
            this.logError(msg, e);
            this.rs.generateFailureAlarm(msg);
            throw e;
        }
        finally {
            for (int i = 0; i < this.replicators.length; ++i) {
                try {
                    this.replicators[i].closeSupervisorSession();
                    continue;
                }
                catch (Exception e) {
                    this.logError("Error During Connection Cleanup", e);
                }
            }
            long ms = BAbsTime.now().getMillis() - begin.getMillis();
            this.logMessage("End replicating all stations [" + BRelTime.make((long)ms).toString((Context)noMillis) + "]");
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinStation(BNiagaraStation station) {
        boolean succeeded = true;
        BAbsTime begin = BAbsTime.now();
        try {
            this.logMessage("Begin joining " + station.getStationName());
            for (int i = 0; i < this.replicators.length; ++i) {
                this.replicators[i].openSupervisorSession();
                this.replicators[i].beforeReplicate(begin);
            }
            BAbsTime timestamp = this.replicateStation(station, true);
            if (timestamp == null) {
                succeeded = false;
            }
        }
        catch (Exception e) {
            succeeded = false;
            e.printStackTrace();
            String msg = "Failed joining " + station.getStationName() + ": " + e.getMessage();
            this.logError(msg, e);
            this.rs.generateFailureAlarm(msg);
        }
        finally {
            for (int i = 0; i < this.replicators.length; ++i) {
                try {
                    this.replicators[i].closeSupervisorSession();
                    continue;
                }
                catch (Exception e) {
                    this.logError("Error During Supervisor Session Cleanup", e);
                }
            }
            long ms = BAbsTime.now().getMillis() - begin.getMillis();
            this.logMessage("End joining " + station.getStationName() + ": [" + BRelTime.make((long)ms).toString((Context)noMillis) + "]");
        }
        return succeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime replicateStation(BNiagaraStation station, boolean isJoin) {
        BAbsTime begin = BAbsTime.now();
        boolean replicateFromJace = false;
        BFoxSession foxSession = null;
        BNiagaraReplicationDeviceExt rd = null;
        try {
            int i;
            rd = BNiagaraReplicationDeviceExt.getForStation(station);
            rd.setLastAttempt(begin);
            BAbsTime timestamp = null;
            if (isJoin) {
                timestamp = BAbsTime.NULL;
            } else {
                timestamp = rd.getLastReplication();
                if (!timestamp.equals((Object)BAbsTime.NULL)) {
                    timestamp = timestamp.subtract(this.rs.getTimeSyncOverlap());
                }
            }
            this.logMessage("Begin replicating station " + station.getStationName() + ", Replication Timestamp is " + timestamp);
            foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry("replication");
            BAccessControlService accessControlService = (BAccessControlService)foxSession.getService(BAccessControlService.TYPE);
            accessControlService.lease();
            String jaceSoftwareVersion = accessControlService.getSoftwareVersion();
            this.checkTimeOverlap(station.getStationName(), foxSession);
            try {
                replicateFromJace = this.replicateFromJaceRequired(foxSession);
            }
            catch (Exception e) {
                e.printStackTrace();
                replicateFromJace = true;
            }
            for (i = 0; i < this.replicators.length; ++i) {
                if (!isJoin && this.job != null) {
                    this.job.checkCancel(null);
                }
                this.replicators[i].replicate((BFoxProxySession)foxSession, timestamp, station.getStationName(), replicateFromJace, this.job, this.facets);
            }
            if (replicateFromJace) {
                for (i = 0; i < this.replicators.length; ++i) {
                    this.replicators[i].cleanJaceDeletionTable((BFoxProxySession)foxSession, timestamp);
                }
            }
            rd.setLastReplication(begin);
            rd.setStatus(BStatus.ok);
            BAbsTime i2 = timestamp;
            return i2;
        }
        catch (Exception e) {
            e.printStackTrace();
            rd.setLastFailure(begin);
            rd.setStatus(BStatus.fault);
            String msg = "Failed replicating station " + station.getStationName() + ": " + e.getMessage();
            this.logError(msg, e);
            this.rs.generateFailureAlarm(msg);
            if (replicateFromJace && foxSession != null) {
                this.setReplicateFromJaceRequired(foxSession, true);
            }
            if (e instanceof JobCancelException) {
                throw (JobCancelException)((Object)e);
            }
            BAbsTime bAbsTime = null;
            return bAbsTime;
        }
        finally {
            if (foxSession != null) {
                foxSession.disengage("replication");
            }
            long ms = BAbsTime.now().getMillis() - begin.getMillis();
            this.logMessage("End replicating station " + station.getStationName() + " [" + BRelTime.make((long)ms).toString((Context)noMillis) + "]");
        }
    }

    private boolean isValidSoftwareVersion(String version, String stationName) {
        Version jaceSoftwareVersion = new Version(version);
        if (supervisorSoftwareVersion.compareTo(jaceSoftwareVersion) == -1) {
            this.logMessage("Skipping replication for " + stationName + ": The supervisor's software version (" + supervisorSoftwareVersion + ") cannot be less than the station's version (" + jaceSoftwareVersion + ")");
            return false;
        }
        if (jaceSoftwareVersion.major() < supervisorSoftwareVersion.major()) {
            this.logMessage("Skipping replication for " + stationName + ": The station's major software revision (" + jaceSoftwareVersion.major() + ") must equal the supervisor's major software revision (" + supervisorSoftwareVersion.major() + ")");
            return false;
        }
        if (supervisorSoftwareVersion.minor() - jaceSoftwareVersion.minor() > 1) {
            this.logMessage("Skipping replication for " + stationName + ": The station's minor software revision (" + jaceSoftwareVersion.minor() + ") must be within " + 1 + " revision(s) of the supervisor's minor software revision (" + supervisorSoftwareVersion.minor() + ")");
            return false;
        }
        return true;
    }

    private void checkTimeOverlap(String stationName, BFoxSession jaceProxy) {
        BSystemPlatformService remoteService = (BSystemPlatformService)SYS_PLATFORM_ORD.get((BObject)jaceProxy);
        remoteService.lease();
        BAbsTime remoteTime = remoteService.getSystemTime();
        BAbsTime localTime = Clock.time();
        BRelTime delta = localTime.delta(remoteTime).abs();
        if (delta.compareTo((Object)this.rs.getTimeSyncOverlap()) > 0) {
            throw new BajaRuntimeException("Station " + stationName + ": Time Sync variance is too wide: localTime: " + localTime + ", remoteTime: " + remoteTime);
        }
    }

    private boolean replicateFromJaceRequired(BFoxSession jaceProxy) {
        BReplicationService remoteService = (BReplicationService)REPLICATION_ORD.get((BObject)jaceProxy);
        remoteService.lease();
        boolean value = remoteService.getReplicationRequired();
        if (value) {
            remoteService.setReplicationRequired(false);
        }
        return value;
    }

    private void setReplicateFromJaceRequired(BFoxSession jaceProxy, boolean value) {
        BReplicationService remoteService = (BReplicationService)REPLICATION_ORD.get((BObject)jaceProxy);
        remoteService.lease();
        remoteService.setReplicationRequired(value);
    }

    private BNiagaraStation[] lookupAllStations() {
        BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] stations = niagaraNetwork.getDevices();
        Array arr = new Array(BNiagaraStation.class);
        for (int i = 0; i < stations.length; ++i) {
            BNiagaraStation station = (BNiagaraStation)stations[i];
            if (!station.getSysDef().getRoleManager().getDesiredRole().equals((Object)BStationRole.subordinate)) continue;
            BNiagaraReplicationDeviceExt rd = BNiagaraReplicationDeviceExt.getForStation(station);
            if (rd.getAutomaticReplicationEnabled() && rd.getJoined()) {
                if (!station.getEnabled()) {
                    this.logMessage("Skipping replication for " + station.getName() + ": station is disabled.");
                    this.missingSubordinate = true;
                    continue;
                }
                arr.add((Object)station);
                continue;
            }
            if (!rd.getAutomaticReplicationEnabled() && rd.getJoined()) {
                this.logMessage("Skipping replication for " + station.getName() + ": automatic replication is disabled.");
                this.missingSubordinate = true;
                continue;
            }
            this.logMessage("Skipping replication for " + station.getName() + ": station is not joined.");
        }
        return (BNiagaraStation[])arr.trim();
    }

    private static BFoxProxySession makeProxy(BNiagaraStation station) {
        BFoxClientConnection conn = station.getClientConnection();
        BIUserCredentials credentials = conn.getCredentials();
        conn.lease(1);
        BFoxProxySession sess = BFoxProxySession.make((BHost)conn.getRemoteHost(), (int)conn.getPort(), (boolean)station.getClientConnection().getUseFoxs(), (BIUserCredentials)credentials);
        return sess;
    }

    public void reinitDbCache(BNiagaraStation station) throws Exception {
        this.logMessage("reinitDbCache for " + station.getStationName());
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest("ReplicationManager.reinitDbCache" + BUuid.make().toString());
        try {
            station.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
            station.invokeAction(BOrd.make((String)"station:|service:entsec:AccessControlService"), "reinitDbCache", null);
        }
        finally {
            station.getClientConnection().disengage((BFoxClientConnection.Interest)interest);
        }
    }

    private void logMessage(String msg) {
        if (this.job != null) {
            this.job.log().message(msg);
        }
        BReplicationService.LOG.info(msg);
    }

    private void logWarning(String msg) {
        if (this.job != null) {
            this.job.log().message(msg);
        }
        BReplicationService.LOG.warning(msg);
    }

    private void logError(String msg, Exception e) {
        if (this.job != null) {
            this.job.log().failed(msg, (Throwable)e);
        }
        BReplicationService.LOG.log(Level.SEVERE, msg, e);
    }

    private void checkLicensing() throws Exception {
        Feature f = Sys.getLicenseManager().checkFeature("Tridium", "entSecurity");
        String maxReadersString = f.get("reader.limit", "0");
        if (maxReadersString.equals("none")) {
            return;
        }
        OrionSession session = Replicator.makeOrionSession((BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE));
        int readers = CountingUtil.getCount((OrionType)BAccReaderRec.ORION_TYPE, (OrionSession)session);
        session.close();
        int maxReaders = Integer.parseInt(maxReadersString);
        if (readers > maxReaders) {
            throw new BajaRuntimeException("LICENSE VIOLATION: found " + readers + " readers, but only licensed for " + maxReaders + " readers.");
        }
    }
}

