/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

public class BReplicationWorker
extends BThreadPoolWorker {
    public static final Property maxThreads = BReplicationWorker.newProperty((int)0, (int)1, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)1)));
    public static final Property maxQueueSize = BReplicationWorker.newProperty((int)0, (int)1000, (BFacets)BFacets.makeInt(null, (int)1, (int)Integer.MAX_VALUE));
    public static final Type TYPE = Sys.loadType(BReplicationWorker.class);
    CoalesceQueue queue;
    ThreadPoolWorker worker;

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BReplicationWorker() {
    }

    public BReplicationWorker(int maxThreads) {
        super(maxThreads);
    }

    public IFuture postAsync(Runnable r) {
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new CoalesceQueue(this.getMaxQueueSize());
            this.worker = new ThreadPoolWorker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    protected String getWorkerThreadName() {
        return "BReplicationWorker:" + this.getParent().getName();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(maxQueueSize) && this.queue != null) {
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }
}

