/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.replicate;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.util.ThrowableUtil;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.orionTools.replicate.BNiagaraReplicationDeviceExt;
import com.tridiumx.entsec.orionTools.replicate.BReplicationJob;
import com.tridiumx.entsec.orionTools.replicate.BReplicationWorker;
import com.tridiumx.entsec.orionTools.replicate.ReplicationManager;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BReplicationService
extends BAbstractService
implements BIAlarmSource {
    public static final Property state = BReplicationService.newProperty((int)1, (BValue)BDescriptorState.idle, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property executionTime = BReplicationService.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make()), null);
    public static final Property lastAttempt = BReplicationService.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property lastReplication = BReplicationService.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property lastFailure = BReplicationService.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property timeSyncOverlap = BReplicationService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), null);
    public static final Property eventDrivenInterval = BReplicationService.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), null);
    public static final Property replicationWorker = BReplicationService.newProperty((int)4, (BValue)new BReplicationWorker(), null);
    public static final Property alarmInfo = BReplicationService.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Property replicationOverrunAlarm = BReplicationService.newProperty((int)0, (BValue)new BAlarmSourceInfo(), null);
    public static final Property replicationOverrunLimit = BReplicationService.newProperty((int)0, (int)5000, null);
    public static final Property replicationRequired = BReplicationService.newProperty((int)2053, (boolean)true, null);
    public static final Property instantReplicatorInterval = BReplicationService.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    public static final Property replicationExecutorLimit = BReplicationService.newProperty((int)0, (int)5, null);
    public static final Action execute = BReplicationService.newAction((int)16, (BValue)BBoolean.make((boolean)false), null);
    public static final Action executeAsJob = BReplicationService.newAction((int)0, null);
    public static final Action schedule = BReplicationService.newAction((int)2064, (BValue)BBoolean.make((boolean)false), null);
    public static final Action clearLastReplication = BReplicationService.newAction((int)132, null);
    public static final Action clearDescriptorState = BReplicationService.newAction((int)132, null);
    public static final Action invokeRemoteAction = BReplicationService.newAction((int)20, (BValue)new BComponent(), null);
    public static final Action ackAlarm = BReplicationService.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BReplicationService.class);
    private static Type[] TYPES = new Type[]{TYPE};
    public static final BIcon ICON = BIcon.std((String)"reorder.png");
    public static final Logger LOG = Logger.getLogger("orionTools.replicate");
    private static final BOrd REMOTE_ORD = BOrd.make((String)"station:|service:entsec:ReplicationService");
    private Clock.Ticket ticket = null;
    private Clock.Ticket instantReplicationTicket = null;
    private static boolean instantReplicationRunning = false;
    private Set replicatorSet = new TreeSet();
    private boolean scheduleOnStationStarted = false;
    private static BSafeSimpleJob runningJob;
    private static final Object lock;
    private static final Object ticketLock;
    private AlarmSupport failureAlarmSupport;
    private AlarmSupport overrunAlarmSupport;

    public BDescriptorState getState() {
        return (BDescriptorState)this.get(state);
    }

    public void setState(BDescriptorState v) {
        this.set(state, (BValue)v, null);
    }

    public BTimeTrigger getExecutionTime() {
        return (BTimeTrigger)this.get(executionTime);
    }

    public void setExecutionTime(BTimeTrigger v) {
        this.set(executionTime, (BValue)v, null);
    }

    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    public BAbsTime getLastReplication() {
        return (BAbsTime)this.get(lastReplication);
    }

    public void setLastReplication(BAbsTime v) {
        this.set(lastReplication, (BValue)v, null);
    }

    public BAbsTime getLastFailure() {
        return (BAbsTime)this.get(lastFailure);
    }

    public void setLastFailure(BAbsTime v) {
        this.set(lastFailure, (BValue)v, null);
    }

    public BRelTime getTimeSyncOverlap() {
        return (BRelTime)this.get(timeSyncOverlap);
    }

    public void setTimeSyncOverlap(BRelTime v) {
        this.set(timeSyncOverlap, (BValue)v, null);
    }

    public BRelTime getEventDrivenInterval() {
        return (BRelTime)this.get(eventDrivenInterval);
    }

    public void setEventDrivenInterval(BRelTime v) {
        this.set(eventDrivenInterval, (BValue)v, null);
    }

    public BReplicationWorker getReplicationWorker() {
        return (BReplicationWorker)this.get(replicationWorker);
    }

    public void setReplicationWorker(BReplicationWorker v) {
        this.set(replicationWorker, (BValue)v, null);
    }

    public BAlarmSourceInfo getAlarmInfo() {
        return (BAlarmSourceInfo)this.get(alarmInfo);
    }

    public void setAlarmInfo(BAlarmSourceInfo v) {
        this.set(alarmInfo, (BValue)v, null);
    }

    public BAlarmSourceInfo getReplicationOverrunAlarm() {
        return (BAlarmSourceInfo)this.get(replicationOverrunAlarm);
    }

    public void setReplicationOverrunAlarm(BAlarmSourceInfo v) {
        this.set(replicationOverrunAlarm, (BValue)v, null);
    }

    public int getReplicationOverrunLimit() {
        return this.getInt(replicationOverrunLimit);
    }

    public void setReplicationOverrunLimit(int v) {
        this.setInt(replicationOverrunLimit, v, null);
    }

    public boolean getReplicationRequired() {
        return this.getBoolean(replicationRequired);
    }

    public void setReplicationRequired(boolean v) {
        this.setBoolean(replicationRequired, v, null);
    }

    public BRelTime getInstantReplicatorInterval() {
        return (BRelTime)this.get(instantReplicatorInterval);
    }

    public void setInstantReplicatorInterval(BRelTime v) {
        this.set(instantReplicatorInterval, (BValue)v, null);
    }

    public int getReplicationExecutorLimit() {
        return this.getInt(replicationExecutorLimit);
    }

    public void setReplicationExecutorLimit(int v) {
        this.setInt(replicationExecutorLimit, v, null);
    }

    public void execute(BBoolean instantReplicationRequired) {
        this.invoke(execute, (BValue)instantReplicationRequired, null);
    }

    public BOrd executeAsJob() {
        return (BOrd)this.invoke(executeAsJob, null, null);
    }

    public void schedule(BBoolean instantReplicationRequired) {
        this.invoke(schedule, (BValue)instantReplicationRequired, null);
    }

    public void clearLastReplication() {
        this.invoke(clearLastReplication, null, null);
    }

    public void clearDescriptorState() {
        this.invoke(clearDescriptorState, null, null);
    }

    public void invokeRemoteAction(BComponent arg) {
        this.invoke(invokeRemoteAction, (BValue)arg, null);
    }

    public BBoolean ackAlarm(BAlarmRecord arg) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)arg, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return TYPES;
    }

    public void started() {
        this.add("replicationLink", (BValue)new BLink(this.getExecutionTime().getOrdInSession(), "fireTrigger", "execute", true), 6);
        this.failureAlarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmInfo());
        this.overrunAlarmSupport = new AlarmSupport((BIAlarmSource)this, this.getReplicationOverrunAlarm());
    }

    public void stationStarted() {
        if (this.scheduleOnStationStarted) {
            this.schedule(BBoolean.make((boolean)false));
        }
    }

    public void stopped() {
        this.remove("replicationLink");
    }

    public void serviceStarted() {
        this.setState(BDescriptorState.idle);
        this.getComponentSpace().enableMixIn(BNiagaraReplicationDeviceExt.TYPE);
    }

    public void serviceStopped() {
        this.getComponentSpace().disableMixIn(BNiagaraReplicationDeviceExt.TYPE);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.equals((Object)alarmInfo)) {
            return Lexicon.make(BReplicationService.class).getText("ReplicationService.alarmInfo");
        }
        return super.getDisplayName(slot, cx);
    }

    public IFuture postAsync(Action action, BValue arg, Context cx) {
        this.getReplicationWorker().postAsync((Runnable)((Object)new ReplicationInvocation((BComponent)this, action, arg, cx)));
        return null;
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(execute)) {
            if (this.getStatus().isDown() || this.getStatus().isDisabled()) {
                return null;
            }
            return this.postAsync(action, arg, cx);
        }
        if (action.equals(schedule)) {
            return this.postAsync(action, arg, cx);
        }
        if (action.equals(invokeRemoteAction)) {
            return this.postAsync(action, arg, cx);
        }
        return super.post(action, arg, cx);
    }

    public BOrd doExecuteAsJob(Context cx) {
        return new BReplicationJob().submit(cx);
    }

    public void doExecute(BBoolean instantReplicationRequired, Context cx) {
        if (instantReplicationRequired == null) {
            instantReplicationRequired = BBoolean.FALSE;
        }
        if (instantReplicationRequired.getBoolean()) {
            instantReplicationRunning = instantReplicationRequired.getBoolean();
        }
        if (this.isRunningReplication()) {
            this.schedule(instantReplicationRequired);
        } else if (RemoteUtil.isSubordinate()) {
            try {
                this.setReplicationRequired(true);
                this.invokeRemoteAction(this.getArgument(this.getSupervisor(), "execute", (BValue)BBoolean.make((boolean)false)));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.executeFail(e, null);
            }
        } else {
            this.doExecuteAsJob(cx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReplication(BSafeSimpleJob job) throws Exception {
        if (job == null) {
            throw new IllegalStateException("Replication requires a BJob");
        }
        if (!this.getEnabled()) {
            return;
        }
        boolean reschedule = true;
        try {
            boolean available = this.obtainRunningLock(job);
            if (!available) {
                throw new JobCancelException("Job has been canceled");
            }
            this.setLastAttempt(Clock.time());
            this.setState(BDescriptorState.pending);
            BAbsTime begin = BAbsTime.now();
            if (!RemoteUtil.isStandalone()) {
                if (RemoteUtil.isSubordinate()) {
                    this.setReplicationRequired(true);
                    this.invokeRemoteAction(this.getArgument(this.getSupervisor(), "execute", (BValue)BBoolean.make((boolean)false)));
                    reschedule = false;
                } else if (RemoteUtil.isSupervisor()) {
                    ReplicationManager mgr;
                    Object object = ticketLock;
                    synchronized (object) {
                        if (this.ticket != null) {
                            if (!this.ticket.isExpired()) {
                                this.ticket.cancel();
                            }
                            this.ticket = null;
                        }
                        if (this.instantReplicationTicket != null) {
                            if (!this.instantReplicationTicket.isExpired()) {
                                this.instantReplicationTicket.cancel();
                            }
                            this.instantReplicationTicket = null;
                        }
                    }
                    job.checkCancel(null);
                    this.setState(BDescriptorState.inProgress);
                    BFacets facets = BFacets.DEFAULT;
                    if (BEnterpriseSecurityService.isThreatAvailable()) {
                        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
                        if (!entsecService.getThreatLevelSetup().getThreatReplicationRequired()) {
                            facets = BFacets.make((BFacets)facets, (String)"noThreatRequired", (BIDataValue)BBoolean.TRUE);
                        } else {
                            entsecService.getThreatLevelSetup().setThreatReplicationRequired(false);
                        }
                    }
                    ReplicationManager replicationManager = mgr = job == null ? new ReplicationManager(this, facets) : new ReplicationManager(this, job, facets);
                    if (!mgr.replicateAllStations()) {
                        this.executeFail("At least one station could not be replicated.", (BJob)job);
                        BEnterpriseSecurityService.threatReplicationRequired();
                        return;
                    }
                } else {
                    this.executeFail("Could not replicate.  Unknown sysdef status.", (BJob)job);
                    return;
                }
            }
            this.executeOk(begin);
            reschedule = false;
        }
        catch (Exception e) {
            BEnterpriseSecurityService.threatReplicationRequired();
            if (!(e instanceof JobCancelException)) {
                e.printStackTrace();
            }
            this.executeFail(e, (BJob)job);
            throw e;
        }
        finally {
            this.releaseRunningLock((BJob)job);
            this.setState(BDescriptorState.idle);
            if (reschedule) {
                if (instantReplicationRunning) {
                    this.schedule(BBoolean.make((boolean)true));
                } else {
                    this.schedule(BBoolean.make((boolean)false));
                    instantReplicationRunning = false;
                }
            } else {
                instantReplicationRunning = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSchedule(BBoolean instantReplicationRequired) {
        if (instantReplicationRequired == null) {
            instantReplicationRequired = BBoolean.FALSE;
        }
        if (!RemoteUtil.isStandalone()) {
            if (!this.isRunning() || !Sys.isStationStarted()) {
                this.scheduleOnStationStarted = true;
                return;
            }
            if (RemoteUtil.isSubordinate()) {
                try {
                    this.setReplicationRequired(true);
                    this.invokeRemoteAction(this.getArgument(this.getSupervisor(), "schedule", null));
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            } else if (RemoteUtil.isSupervisor()) {
                if (this.getState().equals((Object)BDescriptorState.idle) || instantReplicationRequired.getBoolean()) {
                    Object object = ticketLock;
                    synchronized (object) {
                        if (!instantReplicationRequired.getBoolean()) {
                            if (this.ticket == null && this.instantReplicationTicket == null) {
                                LOG.fine("****************************************************************************");
                                LOG.fine("%%%%%%%%%%%%%%% creating regular replication ticket, scheduled for " + this.getEventDrivenInterval() + " %%%%%%%%%%%%%%%");
                                LOG.fine("****************************************************************************");
                                this.ticket = Clock.schedule((BComponent)this, (BRelTime)this.getEventDrivenInterval(), (Action)execute, (BValue)BBoolean.make((boolean)false));
                            }
                        } else {
                            if (this.ticket != null) {
                                if (!this.ticket.isExpired()) {
                                    this.ticket.cancel();
                                }
                                this.ticket = null;
                            }
                            if (this.instantReplicationTicket == null) {
                                LOG.fine("===============================================================================");
                                LOG.fine("*==========  creating instant replication ticket, scheduled for " + this.getInstantReplicatorInterval() + " ================");
                                LOG.fine("===============================================================================");
                                this.instantReplicationTicket = Clock.schedule((BComponent)this, (BRelTime)this.getInstantReplicatorInterval(), (Action)execute, (BValue)BBoolean.make((boolean)true));
                            }
                        }
                    }
                }
            } else {
                LOG.warning("Could not schedule replication.  Unknown sysdef status.");
            }
        }
    }

    private BDevice[] getNiagaraStations() {
        BNiagaraNetwork niagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        return niagaraNetwork.getDevices();
    }

    private BNiagaraStation getSupervisor() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySupervisorStations();
        if (stations.length > 0) {
            return stations[0];
        }
        return null;
    }

    public void doClearLastReplication() {
        this.setLastReplication(BAbsTime.NULL);
    }

    public void doClearDescriptorState() {
        this.setState(BDescriptorState.idle);
    }

    private BComponent getArgument(BNiagaraStation station, String actionName, BValue arg) {
        BComponent c = new BComponent();
        c.add("stationName", (BValue)BString.make((String)station.getName()));
        c.add("actionName", (BValue)BString.make((String)actionName));
        if (arg != null) {
            c.add("arg", arg);
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeRemoteAction(BComponent c) throws Exception {
        String stationName = c.get("stationName").toString();
        BNiagaraStation station = null;
        BDevice[] stations = this.getNiagaraStations();
        for (int i = 0; i < stations.length; ++i) {
            if (!stations[i].getName().equals(stationName)) continue;
            station = (BNiagaraStation)stations[i];
            break;
        }
        String actionName = c.get("actionName").toString();
        BValue arg = c.get("arg");
        LOG.fine("invoke remote action: " + actionName);
        BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest(TYPE + ".invokeRemoteAction." + BUuid.make().toString());
        try {
            station.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
            station.invokeAction(REMOTE_ORD, actionName, arg);
        }
        finally {
            station.getClientConnection().disengage((BFoxClientConnection.Interest)interest);
        }
    }

    public void executeOk(BAbsTime timestamp) {
        this.configOk();
        this.setLastReplication(timestamp);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
    }

    public void executeFail(BJob job) {
        this.executeFail("", job);
    }

    public void executeFail(String reason, BJob job) {
        if (reason == null) {
            reason = "";
        }
        this.setLastFailure(Clock.time());
        this.configFail(reason);
        this.setState(BDescriptorState.idle);
        this.updateStatus();
        if (job != null) {
            job.log().failed(reason);
        }
    }

    public void executeFail(Throwable ex, BJob job) {
        this.executeFail(ex == null ? "" : ThrowableUtil.dumpToString((Throwable)ex, (int)1), job);
    }

    public BBoolean doAckAlarm(BAlarmRecord rec) {
        try {
            return BBoolean.make((this.failureAlarmSupport.ackAlarm(rec) || this.overrunAlarmSupport.ackAlarm(rec) ? 1 : 0) != 0);
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    void generateFailureAlarm(String msg) {
        try {
            this.failureAlarmSupport.newAlert(BFacets.make((String)"msgText", (String)msg));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    void generateOverrunAlarm(String msg) {
        try {
            this.overrunAlarmSupport.newAlert(BFacets.make((String)"msgText", (String)msg));
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public void changed(Property property, Context context) {
        if (property.equals(alarmInfo)) {
            this.failureAlarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmInfo());
        } else if (property.equals(replicationOverrunAlarm)) {
            this.overrunAlarmSupport = new AlarmSupport((BIAlarmSource)this, this.getReplicationOverrunAlarm());
        }
        super.changed(property, context);
    }

    public void addListener(Replicator repl) {
        this.replicatorSet.add(repl);
    }

    public void removeListener(Replicator repl) {
        this.replicatorSet.remove(repl);
    }

    public Replicator[] getReplicators() {
        return this.replicatorSet.toArray(new Replicator[this.replicatorSet.size()]);
    }

    public BIcon getIcon() {
        return ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean obtainRunningLock(BSafeSimpleJob job) {
        Object object = lock;
        synchronized (object) {
            if (job == null) {
                return false;
            }
            if (runningJob == null) {
                runningJob = job;
                return true;
            }
            if (job == runningJob) {
                return true;
            }
            if (job != null) {
                job.log().failed("Replication is already running: " + runningJob.getSlotPath());
                job.cancel();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunningReplication() {
        Object object = lock;
        synchronized (object) {
            return runningJob != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRunningLock(BJob job) {
        Object object = lock;
        synchronized (object) {
            if (job == runningJob) {
                runningJob = null;
            }
        }
    }

    public boolean hasPendingReplication() {
        return this.ticket != null && !this.ticket.isExpired();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        out.startTable(true);
        out.tr((Object)"Replication Ticket", (Object)this.ticket);
        out.endTable();
    }

    static {
        lock = new Object();
        ticketLock = new Object();
    }

    private static class ReplicationInvocation
    extends Invocation {
        private ReplicationInvocation(BComponent instance, Action action, BValue argument, Context context) {
            super(instance, action, argument, context);
        }

        public Object getCoalesceKey() {
            return this.action.getName();
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return this;
        }
    }
}

