/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryChannel;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.orionTools.history.BOrionNiagaraHistoryExport;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Cursor;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BOrionNiagaraHistoryTypeExport
extends BOrionNiagaraHistoryExport {
    public static final Property historyId = BOrionNiagaraHistoryTypeExport.newProperty((int)7, (BValue)BHistoryId.NULL, null);
    public static final Property recordType = BOrionNiagaraHistoryTypeExport.newProperty((int)0, (BValue)BTypeSpec.make((String)"history:HistoryRecord"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"history:HistoryRecord"), (String)"showAbstract", (BIDataValue)BBoolean.TRUE));
    public static final Type TYPE = Sys.loadType(BOrionNiagaraHistoryTypeExport.class);

    public BHistoryId getHistoryId() {
        return (BHistoryId)this.get(historyId);
    }

    public void setHistoryId(BHistoryId v) {
        this.set(historyId, (BValue)v, null);
    }

    public BTypeSpec getRecordType() {
        return (BTypeSpec)this.get(recordType);
    }

    public void setRecordType(BTypeSpec v) {
        this.set(recordType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() {
        if (this.getRecordType().equals((Object)BAuditRecord.TYPE.getTypeSpec())) {
            if (!Flags.isUserDefined3((BComplex)this, (Slot)executeOnAppend)) {
                this.setExecuteOnAppend(true);
                this.setFlags((Slot)executeOnAppend, this.getFlags((Slot)executeOnAppend) | 0x40000000);
            }
            if (!Flags.isUserDefined3((BComplex)this, (Slot)minExecuteTime)) {
                this.setMinExecuteTime(BRelTime.makeMinutes((int)30));
                this.setFlags((Slot)minExecuteTime, this.getFlags((Slot)minExecuteTime) | 0x40000000);
            }
        }
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute() {
        this.executeInProgress();
        BNiagaraHistoryDeviceExt devicelet = null;
        try {
            devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
            devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
        }
        catch (Exception e) {
            this.executeFail(e);
            if (devicelet != null && devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
            }
            Object object = this.lock;
            synchronized (object) {
                this.lastLocalUpdateTicks = -1L;
            }
            return;
        }
        try {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            if (db == null) {
                this.executeFail("Could not find History Database");
                Object object = this.lock;
                synchronized (object) {
                    this.lastLocalUpdateTicks = -1L;
                }
                return;
            }
            BOrionHistoryChannel channel = BOrionNiagaraHistoryTypeExport.channel(devicelet);
            BIHistory[] histories = db.getHistories();
            Type recType = this.getRecordType().getResolvedType();
            Exception failure = null;
            for (int i = 0; i < histories.length; ++i) {
                try {
                    BTypeSpec historyRecType = histories[i].getRecordType();
                    if (!historyRecType.getResolvedType().is(recType)) continue;
                    BHistoryId id = histories[i].getId();
                    BAbsTime startTime = null;
                    BOrionHistoryRecord[] previouslyExported = null;
                    try {
                        previouslyExported = channel.getLastExports(id, historyRecType);
                        if (previouslyExported != null && previouslyExported.length > 0) {
                            startTime = previouslyExported[0].getTimestamp();
                        }
                    }
                    catch (Exception e) {
                        startTime = channel.getLastTimestamp(id, historyRecType);
                    }
                    if (startTime != null && !startTime.isNull()) {
                        startTime = startTime.add(BRelTime.make((long)1L));
                    }
                    Object c = null;
                    try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                        c = conn.timeQuery(histories[i], startTime, null).cursor();
                    }
                    if (previouslyExported != null && previouslyExported.length > 0) {
                        c = new BOrionNiagaraHistoryExport.OrionHistoryExportCursor((Cursor)c, previouslyExported);
                    }
                    channel.consolidate(id, (Cursor)c);
                    continue;
                }
                catch (Exception ex) {
                    failure = ex;
                }
            }
            if (failure != null) {
                throw failure;
            }
            this.executeOk();
        }
        catch (Exception e) {
            this.executeFail(e);
            Object object = this.lock;
            synchronized (object) {
                this.lastLocalUpdateTicks = -1L;
            }
        }
        finally {
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
    }

    @Override
    public void historyEvent(BHistoryEvent event) {
        BHistoryService service;
        BHistoryDatabase db;
        if (this.getExecuteOnAppend() && event.getId() == 2 && (db = (service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase()).getConfig(event.getHistoryId()).getRecordType().getResolvedType().is(this.getRecordType().getResolvedType())) {
            this.execute();
        }
    }
}

