/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools.history;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.history.io.RecordOutput;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryConsolidator;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.orionTools.history.SecHistoryInput;
import com.tridiumx.entsec.orionTools.history.SecRecordInput;
import com.tridiumx.entsec.orionTools.history.SecRecordInputCursor;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryException;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

public class BOrionHistoryChannel
extends BFoxChannel {
    public static final Type TYPE = Sys.loadType(BOrionHistoryChannel.class);

    public Type getType() {
        return TYPE;
    }

    public BOrionHistoryChannel() {
        super("orionHistory");
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command = request.command;
        throw new InvalidCommandException(command);
    }

    public void circuitOpened(FoxCircuit circuit) throws Exception {
        String command = circuit.command;
        if (command == "getLastExports") {
            this.getLastExports(circuit);
            return;
        }
        if (command == "getLastTimestamp") {
            this.getLastTimestamp(circuit);
            return;
        }
        if (command == "consolidate") {
            this.consolidate(circuit);
            return;
        }
        throw new InvalidCommandException(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BOrionHistoryRecord[] getLastExports(BHistoryId id, BTypeSpec recordType) throws Exception {
        try (FoxCircuit circuit = this.openCircuit("getLastExports");){
            FoxMessage query = new FoxMessage();
            query.add("id", id.encodeToString());
            query.add("recType", recordType.encodeToString());
            circuit.writeMessage(query);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (!resp.getBoolean("success", true)) {
                throw new HistoryException(resp.getString("error"));
            }
            int len = resp.getInt("count");
            BOrionHistoryRecord[] result = new BOrionHistoryRecord[len];
            if (len > 0) {
                DataInputStream dataIn = new DataInputStream(circuit.getInputStream());
                BOrionHistoryRecord template = BOrionHistoryRecord.make(id, (BHistoryRecord)recordType.getInstance());
                for (int i = 0; i < len; ++i) {
                    result[i] = (BOrionHistoryRecord)template.read(dataIn).newCopy();
                }
            }
            BOrionHistoryRecord[] bOrionHistoryRecordArray = result;
            return bOrionHistoryRecordArray;
        }
    }

    public void getLastExports(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make((String)req.getString("id"));
        Context cx = this.getSessionContext();
        FoxMessage resp = new FoxMessage();
        try {
            BTypeSpec recTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(req.getString("recType"));
            BOrionHistoryConsolidator consolidator = BOrionHistoryConsolidator.getConsolidator(id, recTypeSpec, false, cx);
            if (consolidator == null) {
                throw new HistoryException("Matching OrionHistoryConsolidator not found for: " + id.toString());
            }
            BOrionHistoryRecord[] lastExports = consolidator.getLastExports(id, (BHistoryRecord)recTypeSpec.getInstance(), cx);
            int len = lastExports != null ? lastExports.length : 0;
            resp.add("success", true);
            resp.add("count", len);
            circuit.writeMessage(resp);
            circuit.flush();
            if (len > 0) {
                DataOutputStream dataOut = new DataOutputStream(circuit.getOutputStream());
                for (int i = 0; i < len; ++i) {
                    lastExports[i].write(dataOut);
                }
                dataOut.flush();
                dataOut.close();
            }
        }
        catch (Exception e) {
            resp.add("success", false);
            resp.add("error", "Failed to find most recent exported records for: " + id.toString() + ", " + e.toString());
            circuit.writeMessage(resp);
            circuit.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getLastTimestamp(BHistoryId id, BTypeSpec recordType) throws Exception {
        try (FoxCircuit circuit = this.openCircuit("getLastTimestamp");){
            FoxMessage query = new FoxMessage();
            query.add("id", id.encodeToString());
            query.add("recType", recordType.encodeToString());
            circuit.writeMessage(query);
            circuit.flush();
            FoxMessage resp = circuit.readMessage();
            if (!resp.getBoolean("success", true)) {
                throw new HistoryException(resp.getString("error"));
            }
            BAbsTime bAbsTime = BAbsTime.make((long)resp.getTime("lastTs"));
            return bAbsTime;
        }
    }

    public void getLastTimestamp(FoxCircuit circuit) throws Exception {
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make((String)req.getString("id"));
        Context cx = this.getSessionContext();
        FoxMessage resp = new FoxMessage();
        try {
            BTypeSpec recTypeSpec = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(req.getString("recType"));
            BOrionHistoryConsolidator consolidator = BOrionHistoryConsolidator.getConsolidator(id, recTypeSpec, false, cx);
            if (consolidator == null) {
                throw new HistoryException("Matching OrionHistoryConsolidator not found for: " + id.toString());
            }
            BAbsTime lastTimestamp = consolidator.readLastTimestamp(id, (BHistoryRecord)recTypeSpec.getInstance(), cx);
            resp.add("success", true);
            resp.add("lastTs", lastTimestamp.getMillis());
        }
        catch (Exception e) {
            resp.add("success", false);
            resp.add("error", "Failed to find most recent timestamp for: " + id.toString() + ", " + e.toString());
        }
        circuit.writeMessage(resp);
        circuit.flush();
    }

    public void consolidate(BHistoryId id, Cursor records) throws Exception {
        if (!records.next()) {
            return;
        }
        FoxCircuit circuit = this.openCircuit("consolidate");
        FoxMessage query = new FoxMessage();
        query.add("id", id.encodeToString());
        query.add("recType", ((BObject)records.get()).getType().getTypeSpec().encodeToString());
        circuit.writeMessage(query);
        circuit.flush();
        FoxMessage resp = circuit.readMessage();
        if (!resp.getBoolean("continue", true)) {
            throw new HistoryException(resp.getString("error"));
        }
        RecordOutput out = new RecordOutput((DataOutput)new DataOutputStream(circuit.getOutputStream()));
        do {
            out.write((BObject)records.get());
        } while (records.next());
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consolidate(FoxCircuit circuit) throws Exception {
        Version version = Version.NULL;
        FoxMessage req = circuit.readMessage();
        BHistoryId id = BHistoryId.make((String)req.getString("id"));
        String interest = TYPE + ".consolidate." + id + "." + BUuid.make().toString();
        Object session = null;
        try {
            BFoxServerConnection serConn = (BFoxServerConnection)this.getParent().getParent();
            BString stringVersion = (BString)BOrd.make((BOrd)serConn.getSession().getAbsoluteOrd(), (String)"service:entsec:AccessControlService|slot:softwareVersion").get();
            version = new Version(stringVersion.toString());
        }
        catch (Exception e) {
            Logger.getLogger("entsec").log(Level.SEVERE, "Cannot get Sofware Version for consolidatation for " + id, e);
        }
        finally {
            if (session != null) {
                session.disengage(interest);
            }
        }
        FoxMessage resp = new FoxMessage();
        BOrionHistoryConsolidator consolidator = null;
        Context cx = this.getSessionContext();
        try {
            BTypeSpec recType = (BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(req.getString("recType"));
            consolidator = BOrionHistoryConsolidator.getConsolidator(id, recType, false, cx);
            if (consolidator == null) {
                resp.add("continue", false);
                resp.add("error", "Matching OrionHistoryConsolidator not found for: " + id.toString());
                circuit.writeMessage(resp);
                return;
            }
        }
        catch (Exception e) {
            resp.add("continue", false);
            resp.add("error", "Consolidation failure for: " + id.toString() + ", " + e.toString());
            circuit.writeMessage(resp);
            return;
        }
        resp.add("continue", true);
        circuit.writeMessage(resp);
        circuit.flush();
        try (SecHistoryInput in = null;){
            in = new SecRecordInput(new DataInputStream(circuit.getInputStream()));
            SecRecordInputCursor c = new SecRecordInputCursor((SecRecordInput)in, (Context)BFacets.make((String)"version", (String)version.toString()));
            consolidator.appendOrionRecords(id, (Cursor)c, cx);
        }
    }
}

