/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.filter.BFilterSet;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.dt.BDynamicTable;
import com.tridium.orion.priv.dt.BDynamicTableColumn;
import com.tridium.orion.priv.dt.BDynamicTableReportType;
import com.tridium.orion.priv.dt.DynamicTableResultModel;
import com.tridium.orion.priv.ui.BDynamicTableOptions;
import com.tridium.orion.sql.BPage;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.filter.BSecAbsTimeFilter;
import com.tridiumx.entsec.orionTools.BDisplayRef;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedHashMap;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BQuery;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;

public class SecDynamicTableResultModel
extends DynamicTableResultModel {
    public SecDynamicTableResultModel() {
    }

    public SecDynamicTableResultModel(OrionType rowType, BDynamicTableColumn[] cols, BIOrionObject[] rows, BDynamicTable dt, Context cx) {
        super(rowType, cols, rows, dt, cx);
    }

    public void calculateResults(BDynamicTable dt, BQuery query, OrionType dynamicRowType, OrionCursor c, OrionSession session, Context cx, BFilterSet filterSet) {
        this.calculateResults(dt, query, dynamicRowType, c, -1, session, cx, filterSet);
    }

    public void calculateResults(BDynamicTable dt, BQuery query, OrionType dynamicRowType, OrionCursor c, int maxRows, OrionSession session, Context cx, BFilterSet filterSet) {
        if (!dt.supportsPaginatedQuery(cx) || dt.getWorkingReportType(cx) == BDynamicTableReportType.fullReport) {
            this.coalesce(dt, dynamicRowType, c, maxRows, cx, filterSet);
            return;
        }
        Property[] dynamicProps = dynamicRowType.getProperties();
        BDynamicTableColumn[] cols = dt.getWorkingColumns(cx);
        Array a = new Array(BIOrionObject.class);
        int advancedFilterLength = 0;
        if (filterSet != null) {
            advancedFilterLength = ((BFilterEntry[])filterSet.getChildren(BFilterEntry.class)).length;
        }
        BSecAbsTimeFilter[] advanceFilters = new BSecAbsTimeFilter[dynamicProps.length];
        for (int j = 0; j < advancedFilterLength; ++j) {
            BSecAbsTimeFilter filter;
            BFilterEntry entry = ((BFilterEntry[])filterSet.getChildren(BFilterEntry.class))[j];
            if (!entry.getActive() || !(entry.getFilter() instanceof BSecAbsTimeFilter) || (filter = (BSecAbsTimeFilter)entry.getFilter()).isAdvancedDefault()) continue;
            advanceFilters[j] = filter;
        }
        int maxReturnable = maxRows;
        int totalCount = 0;
        int returnCount = 0;
        boolean checkThreshold = maxRows > 0;
        boolean requiresMoreResults = false;
        boolean sortAsc = true;
        int resortByDisplayRefColumn = -1;
        boolean firstRow = true;
        boolean paginated = false;
        BSqlQuery q = (BSqlQuery)query;
        if (q.hasPage()) {
            paginated = true;
            int recordsPerPage = q.getPage().getLimit();
            if (maxReturnable > recordsPerPage) {
                maxReturnable = recordsPerPage;
            }
        }
        boolean next = c.next();
        while (!(!next && !requiresMoreResults || checkThreshold && returnCount >= maxReturnable)) {
            if (!next && requiresMoreResults) {
                requiresMoreResults = false;
                BPage page = q.getPage();
                if (page.getLimit() + page.getOffset() >= maxRows) {
                    throw new OutOfMemoryError("Advanced Filtering too strict (Exceeded " + maxRows + " rows)");
                }
                page.setOffset(page.getOffset() + page.getLimit());
                page.setLimit(page.getLimit() * 10);
                if (page.getLimit() + page.getOffset() > maxRows) {
                    page.setLimit(maxRows - page.getOffset());
                }
                if (!(c = session.select((BQuery)q)).next()) break;
            }
            ++totalCount;
            boolean skip = false;
            BIOrionObject current = (BIOrionObject)c.get();
            for (int j = 0; j < dynamicProps.length; ++j) {
                BSecAbsTimeFilter filter;
                BValue currentValue = current.get(dynamicProps[j]);
                if (!(!(currentValue instanceof BRef) || dynamicProps[j].getDeclaringType().equals(dt.getRowType().getTypeSpec().getResolvedType()) && BOrionObject.isKey((Property)dynamicProps[j]))) {
                    int sortIndex;
                    BDynamicTableOptions options;
                    BRef ref = (BRef)currentValue;
                    BDisplayRef displayRef = new BDisplayRef(ref, SecDynamicTableResultModel.toTableDisplayString(ref, c.getSession()));
                    current.set(dynamicProps[j], (BValue)displayRef);
                    if (!firstRow || resortByDisplayRefColumn != -1 || (options = dt.getOptions(cx)) == null || (sortIndex = options.getSortColumnIndex(dt, cx)) != j) continue;
                    resortByDisplayRefColumn = sortIndex;
                    sortAsc = options.getSortColumnAsc(dt, cx);
                    continue;
                }
                if (!(currentValue instanceof BAbsTime)) continue;
                BAbsTime time = (BAbsTime)currentValue;
                if (advanceFilters[j] == null || (filter = advanceFilters[j]).advancedAccept(time)) continue;
                skip = true;
            }
            firstRow = false;
            next = c.next();
            if (skip) {
                if (!paginated) continue;
                requiresMoreResults = true;
                continue;
            }
            a.add((Object)current);
            ++returnCount;
        }
        Object[] returnValue = (BIOrionObject[])a.trim();
        if (resortByDisplayRefColumn != -1) {
            a = new Array(returnValue);
            a = a.sort((Comparator)new ToStringComparator(resortByDisplayRefColumn, sortAsc));
            returnValue = (BIOrionObject[])a.trim();
        }
        this.rows = returnValue;
    }

    public void coalesce(BDynamicTable dt, OrionType dynamicRowType, OrionCursor c, int maxRows, Context cx, BFilterSet filterSet) {
        Property[] keys = dt.getOrionDatabase().getType(dt.getRowType()).getKey();
        Property[] dynamicProps = dynamicRowType.getProperties();
        Array canCoalesceProps = new Array(Property.class);
        BDynamicTableColumn[] cols = dt.getWorkingColumns(cx);
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].canCoalesce(dt.getRowType())) continue;
            canCoalesceProps.add((Object)dynamicProps[i]);
        }
        Property[] props = (Property[])canCoalesceProps.trim();
        LinkedHashMap<String, BIOrionObject> map = new LinkedHashMap<String, BIOrionObject>();
        Array a = new Array(BIOrionObject.class);
        boolean coalesce = dt.getCoalesce() && props.length > 0;
        boolean checkThreshold = maxRows > 0;
        int count = 0;
        int advancedFilterLength = 0;
        if (filterSet != null) {
            advancedFilterLength = ((BFilterEntry[])filterSet.getChildren(BFilterEntry.class)).length;
        }
        BSecAbsTimeFilter[] advanceFilters = new BSecAbsTimeFilter[dynamicProps.length];
        for (int j = 0; j < advancedFilterLength; ++j) {
            BSecAbsTimeFilter filter;
            BFilterEntry entry = ((BFilterEntry[])filterSet.getChildren(BFilterEntry.class))[j];
            if (!entry.getActive() || !(entry.getFilter() instanceof BSecAbsTimeFilter) || (filter = (BSecAbsTimeFilter)entry.getFilter()).isAdvancedDefault()) continue;
            advanceFilters[j] = filter;
        }
        boolean sortAsc = true;
        int resortByDisplayRefColumn = -1;
        boolean firstRow = true;
        while (c.next()) {
            if (checkThreshold) {
                if (count >= maxRows) {
                    Object[] returnValue = null;
                    returnValue = coalesce ? map.values().toArray(new BIOrionObject[0]) : (BIOrionObject[])a.trim();
                    if (resortByDisplayRefColumn != -1) {
                        a = new Array(returnValue);
                        a = a.sort((Comparator)new ToStringComparator(resortByDisplayRefColumn, sortAsc));
                        returnValue = (BIOrionObject[])a.trim();
                    }
                    this.rows = returnValue;
                    this.reachedMax = true;
                    return;
                }
                ++count;
            }
            boolean skip = false;
            BIOrionObject current = (BIOrionObject)c.get();
            for (int j = 0; j < dynamicProps.length; ++j) {
                BSecAbsTimeFilter filter;
                BValue currentValue = current.get(dynamicProps[j]);
                if (!(!(currentValue instanceof BRef) || dynamicProps[j].getDeclaringType().equals(dt.getRowType().getTypeSpec().getResolvedType()) && BOrionObject.isKey((Property)dynamicProps[j]))) {
                    BDynamicTableOptions options;
                    int sortIndex;
                    BRef ref = (BRef)currentValue;
                    BDisplayRef displayRef = new BDisplayRef(ref, SecDynamicTableResultModel.toTableDisplayString(ref, c.getSession()));
                    current.set(dynamicProps[j], (BValue)displayRef);
                    if (!firstRow || resortByDisplayRefColumn != -1 || (sortIndex = (options = dt.getOptions(cx)).getSortColumnIndex(dt, cx)) != j) continue;
                    resortByDisplayRefColumn = sortIndex;
                    sortAsc = options.getSortColumnAsc(dt, cx);
                    continue;
                }
                if (!(currentValue instanceof BAbsTime)) continue;
                BAbsTime time = (BAbsTime)currentValue;
                if (advanceFilters[j] == null || (filter = advanceFilters[j]).advancedAccept(time)) continue;
                skip = true;
            }
            firstRow = false;
            if (skip) continue;
            if (!coalesce) {
                a.add((Object)current);
                continue;
            }
            String handle = BOrionScheme.encodePropertiesToString((BIOrionObject)current, (Property[])keys);
            Object entry = map.get(handle);
            if (entry == null) {
                map.put(handle, current);
                continue;
            }
            BIOrionObject o = (BIOrionObject)entry;
            for (int j = 0; j < props.length; ++j) {
                BValue entryValue = o.get(props[j]);
                String entryString = entryValue.toString();
                BValue currentValue = current.get(props[j]);
                String currentString = currentValue.toString(cx);
                if (entryValue.equals((Object)currentValue)) continue;
                if (entryValue instanceof BString && entryString.indexOf("; ") > -1) {
                    String[] split = TextUtil.split((String)entryString, (char)';');
                    if (split.length > COALESCE_LIMIT) {
                        if (split[split.length - 1].equals(" ...")) continue;
                        o.set(props[j], (BValue)BString.make((String)("" + entryString + "; ...")));
                        continue;
                    }
                    boolean foundSplit = false;
                    for (int k = 0; k < split.length; ++k) {
                        if (!split[k].trim().equals(currentString)) continue;
                        foundSplit = true;
                    }
                    if (foundSplit) continue;
                    o.set(props[j], (BValue)BString.make((String)("" + entryString + "; " + currentString)));
                    continue;
                }
                o.set(props[j], (BValue)BString.make((String)("" + entryString + "; " + currentString)));
            }
            map.put(handle, o);
        }
        Object[] returnValue = null;
        returnValue = coalesce ? map.values().toArray(new BIOrionObject[0]) : (BIOrionObject[])a.trim();
        if (resortByDisplayRefColumn != -1) {
            a = new Array(returnValue);
            a = a.sort((Comparator)new ToStringComparator(resortByDisplayRefColumn, sortAsc));
            returnValue = (BIOrionObject[])a.trim();
        }
        this.rows = returnValue;
    }

    public static String toTableDisplayString(BRef ref, OrionSession session) {
        if (ref.isBound()) {
            BIOrionObject target = ref.getTarget(session);
            if (target != null) {
                return target.toDisplayString((Context)session);
            }
            return "";
        }
        return "";
    }

    public static class ToStringComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int columnSortId;
        private boolean sortAsc;

        public ToStringComparator(int columnSortId, boolean sortAsc) {
            this.columnSortId = columnSortId;
            this.sortAsc = sortAsc;
        }

        public int compare(Object o1, Object o2) {
            BIOrionObject oo1 = (BIOrionObject)o1;
            BIOrionObject oo2 = (BIOrionObject)o2;
            Property prop = oo1.getOrionType().getProperties()[this.columnSortId];
            if (this.sortAsc) {
                return oo1.get(prop).toString().compareTo(oo2.get(prop).toString());
            }
            return oo2.get(prop).toString().compareTo(oo1.get(prop).toString());
        }
    }
}

