/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.securityUtil.monitorSysDef.BMonitorSysDefSecurity;
import com.tridiumx.entsec.securityUtil.query.consolidated.BConsolidatedDataChannel;
import java.net.ConnectException;
import javax.baja.driver.BDevice;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BIpHost;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.Version;

public abstract class RemoteUtil {
    public static Context getUserContext(BComponent baseComponent, Context cx) {
        if (cx == null) {
            return null;
        }
        BUser user = cx.getUser();
        if (user != null) {
            return cx;
        }
        if (cx instanceof BFacets) {
            BFacets facets = (BFacets)cx;
            String username = facets.gets("username", null);
            if (username == null) {
                return null;
            }
            BISession isession = baseComponent.getSession();
            try {
                BUserService userService = (BUserService)BOrd.make((String)"station:|service:baja:UserService").get((BObject)isession);
                userService.lease();
                user = userService.getUser(username);
                user.lease(2);
                return new BasicContext(user, facets);
            }
            catch (Exception e) {
                return cx;
            }
        }
        return cx;
    }

    public static BValue invokeRemote(String stationName, BOrd remoteOrd, Action action, BValue param) throws Exception {
        return RemoteUtil.invokeRemote(stationName, remoteOrd, action.getName(), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BValue invokeRemote(String stationName, BOrd remoteOrd, String action, BValue param) throws Exception {
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = network.getDevices();
        for (int k = 0; k < devices.length; ++k) {
            BNiagaraStation station;
            if (!devices[k].getName().equals(stationName) || (station = (BNiagaraStation)devices[k]).isDown() || station.isDisabled() || station.isFatalFault()) continue;
            String interest = "RemoteUtil.invokeRemote." + remoteOrd + "." + action + BUuid.make().toString();
            BFoxSession foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry(interest);
            try {
                BComponent remoteComponent = RemoteUtil.getRemoteComponent(foxSession, remoteOrd.toString());
                if (remoteComponent == null) {
                    throw new BajaRuntimeException("Remote Component not available: " + remoteOrd.toString() + " on " + stationName);
                }
                remoteComponent.lease();
                Action remoteAction = remoteComponent.getAction(action);
                BValue bValue = remoteComponent.invoke(remoteAction, param);
                return bValue;
            }
            finally {
                foxSession.disengage(interest);
            }
        }
        throw new BajaRuntimeException("Station not available: " + stationName);
    }

    public static BFoxSession getFoxSession(BNiagaraStation station) {
        BFoxSession foxSession = null;
        try {
            if (station.getSession() instanceof BFoxSession) {
                throw new ConnectException("The password cannot be retrieved from session.");
            }
            BIpHost host = (BIpHost)station.getRemoteHost();
            foxSession = BFoxSession.make((String)station.getName(), (BHost)host, (int)station.getFoxPort(), (boolean)station.getClientConnection().getUseFoxs());
            if (foxSession != null) {
                BIUserCredentials credentials = station.getClientConnection().getCredentials();
                foxSession.getConnection().setCredentials(credentials);
                foxSession.getConnection().setAuthenticationClient((AuthenticationClient)station.getClientConnection());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return foxSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jobSafePing(final BNiagaraStation station) throws Exception {
        ThreadInfo info;
        block7: {
            info = new ThreadInfo();
            try {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            station.doPing();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            info.exception = e;
                        }
                        finally {
                            info.attemptComplete = true;
                            Object object = info.monitor;
                            synchronized (object) {
                                info.monitor.notify();
                            }
                        }
                    }
                }.start();
                if (info.attemptComplete) break block7;
                Object object = info.monitor;
                synchronized (object) {
                    info.monitor.wait();
                }
            }
            finally {
                info.complete = true;
            }
        }
        if (info.exception != null) {
            throw info.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jobSafeEngageNoRetry(final BFoxSession session, final String interest) throws Exception {
        ThreadInfo info;
        block7: {
            info = new ThreadInfo();
            try {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            session.engageNoRetry(interest, 0L);
                            if (info.complete) {
                                session.disengage(interest);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            info.exception = e;
                        }
                        finally {
                            info.attemptComplete = true;
                            Object object = info.monitor;
                            synchronized (object) {
                                info.monitor.notify();
                            }
                        }
                    }
                }.start();
                if (info.attemptComplete) break block7;
                Object object = info.monitor;
                synchronized (object) {
                    info.monitor.wait();
                }
            }
            finally {
                info.complete = true;
            }
        }
        if (info.exception != null) {
            throw info.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jobSafeManualConnect(final BNiagaraStation station, long maxWait) throws Exception {
        final ThreadInfo info = new ThreadInfo();
        try {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        station.lease();
                        station.getClientConnection().lease();
                        station.getClientConnection().manualConnect();
                        info.attemptSuccess = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.exception = e;
                    }
                    finally {
                        info.attemptComplete = true;
                        Object object = info.monitor;
                        synchronized (object) {
                            info.monitor.notify();
                        }
                    }
                }
            }.start();
            if (!info.attemptComplete) {
                Object object = info.monitor;
                synchronized (object) {
                    info.monitor.wait(maxWait);
                }
            }
            if (!info.attemptSuccess) {
                throw new IllegalStateException("Cannot reach station " + station.getStationName() + " with address " + station.getAddress());
            }
        }
        finally {
            info.complete = true;
        }
        if (info.exception != null) {
            throw info.exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jobSafeConsolidatedDataChannelSetIp(final BFoxSession remoteSession, final String myStationName, long maxWait) throws Exception {
        final ThreadInfo info = new ThreadInfo();
        try {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object channel = (BConsolidatedDataChannel)remoteSession.getConnection().getChannels().get("consolidatedData", BConsolidatedDataChannel.TYPE);
                        channel.setRemoteIp(myStationName);
                        info.attemptSuccess = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        info.exception = e;
                    }
                    finally {
                        info.attemptComplete = true;
                        Object object = info.monitor;
                        synchronized (object) {
                            info.monitor.notify();
                        }
                    }
                }
            }.start();
            if (!info.attemptComplete) {
                Object object = info.monitor;
                synchronized (object) {
                    info.monitor.wait(maxWait);
                }
            }
            if (!info.attemptSuccess) {
                throw new IllegalStateException("Cannot complete data channel ip set");
            }
        }
        finally {
            info.complete = true;
        }
        if (info.exception != null) {
            throw info.exception;
        }
    }

    public static BNiagaraStation findStation(BComponent parent, String stationName) {
        parent.lease();
        BValue slot = parent.get(stationName);
        if (slot instanceof BNiagaraStation) {
            return (BNiagaraStation)slot;
        }
        BComponent[] children = parent.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            BNiagaraStation station = RemoteUtil.findStation(children[i], stationName);
            if (station == null) continue;
            return station;
        }
        return null;
    }

    public static boolean isStationConfigured(String stationName) {
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
        return station != null;
    }

    public static boolean isStationValid(String stationName) {
        BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
        if (station == null) {
            return false;
        }
        try {
            station.doPing();
        }
        catch (Exception e) {
            return false;
        }
        return station.getStatus().isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BComponent getRemoteComponent(BFoxSession foxSession, String remoteSlotPathOrd) {
        BComponent remoteComponent = null;
        BOrd remoteOrd = null;
        try {
            String fixedRemoteSlotPathOrd = TextUtil.replace((String)remoteSlotPathOrd, (String)" ", (String)"$20");
            remoteOrd = fixedRemoteSlotPathOrd.indexOf("station:|") == -1 ? BOrd.make((String)("station:|" + fixedRemoteSlotPathOrd)) : BOrd.make((String)fixedRemoteSlotPathOrd);
            remoteOrd = BOrd.make((BOrd)foxSession.getAbsoluteOrd(), (BOrd)remoteOrd);
            remoteComponent = RemoteUtil.isSupervisor() && foxSession.getConnection().session().isLegacyConnection() ? remoteOrd.get().asComponent() : remoteOrd.resolve((BObject)BLocalHost.INSTANCE, null, foxSession.getConnection().getAuthenticationClient()).getComponent();
        }
        catch (UnresolvedException fixedRemoteSlotPathOrd) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            remoteOrd = null;
        }
        return remoteComponent;
    }

    public static boolean isSubordinate() {
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BMonitorSysDefSecurity sysDef = entsecService.getMonitorSysDefSecurity();
        return sysDef.getHasSecuritySupervisor() && !sysDef.getHasSecuritySubordinate();
    }

    public static boolean isSupervisor() {
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BMonitorSysDefSecurity sysDef = entsecService.getMonitorSysDefSecurity();
        return !sysDef.getHasSecuritySupervisor() && sysDef.getHasSecuritySubordinate();
    }

    public static boolean isStandalone() {
        BEnterpriseSecurityService entsecService = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BMonitorSysDefSecurity sysDef = entsecService.getMonitorSysDefSecurity();
        return !sysDef.getHasSecuritySupervisor() && !sysDef.getHasSecuritySubordinate();
    }

    public static BNiagaraStation getSupervisorStation() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BNiagaraStation[] supervisorStations = service.getMonitorSysDefSecurity().getSecuritySupervisorStations();
        if (supervisorStations.length > 0) {
            return supervisorStations[0];
        }
        return null;
    }

    public static BFoxSession getFoxSession(OrionSession session) {
        BFoxOrionDatabase db = (BFoxOrionDatabase)session.getOrionDatabase();
        return ((BFoxOrionSpace)db.getOrionSpace()).getFoxSession();
    }

    public static Version getRemoteSoftwareVersion(OrionSession session) {
        return RemoteUtil.getRemoteSoftwareVersion(RemoteUtil.getFoxSession(session));
    }

    public static Version getRemoteSoftwareVersion(BFoxSession session) {
        BAccessControlService remoteService = (BAccessControlService)session.getService(BAccessControlService.TYPE);
        remoteService.lease();
        Version remoteVersion = new Version(remoteService.getSoftwareVersion());
        return remoteVersion;
    }

    static class ThreadInfo {
        Object monitor = new Object();
        boolean attemptSuccess = false;
        boolean attemptComplete = false;
        Exception exception = null;
        boolean complete = false;

        ThreadInfo() {
        }
    }
}

