/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import java.util.HashSet;
import java.util.logging.Level;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;

public abstract class OrionSessionCleaner {
    static HashSet hashSet = new HashSet();
    static long THIRTY_SECONDS = 30000L;
    private static Cleaner cleaner;
    static BRelTime DEFAULT_OPEN_TIME;

    public static void manage(OrionSession session) {
        OrionSessionCleaner.manage(session, DEFAULT_OPEN_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manage(OrionSession session, BRelTime openTime) {
        HashSet hashSet = OrionSessionCleaner.hashSet;
        synchronized (hashSet) {
            OrionSessionCleaner.hashSet.add(new OrionSessionContainer(session, BAbsTime.now().add(openTime)));
            OrionSessionCleaner.startCleaner();
        }
    }

    static void startCleaner() {
        if (cleaner == null) {
            if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                BEnterpriseSecurityService.LOG.fine("start cleaner: ");
            }
            cleaner = new Cleaner();
            cleaner.start();
        }
    }

    static void removeCleaner() {
        if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
            BEnterpriseSecurityService.LOG.fine("remove cleaner: ");
        }
        cleaner = null;
    }

    static {
        DEFAULT_OPEN_TIME = BRelTime.makeSeconds((int)59);
    }

    static class OrionSessionContainer {
        OrionSession session;
        BAbsTime timestamp;

        OrionSessionContainer(OrionSession session, BAbsTime timestamp) {
            this.session = session;
            this.timestamp = timestamp;
        }
    }

    static class Cleaner
    extends Thread {
        Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(THIRTY_SECONDS);
                        if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                            BEnterpriseSecurityService.LOG.fine("run cleaner: ");
                        }
                        HashSet hashSet = OrionSessionCleaner.hashSet;
                        synchronized (hashSet) {
                            Object[] values = OrionSessionCleaner.hashSet.toArray();
                            boolean keepAlive = false;
                            for (int i = 0; i < values.length; ++i) {
                                OrionSessionContainer container = (OrionSessionContainer)values[i];
                                if (!container.session.isOpen()) {
                                    OrionSessionCleaner.hashSet.remove(container);
                                    continue;
                                }
                                if (container.timestamp.getMillis() < BAbsTime.now().getMillis()) {
                                    if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                                        BEnterpriseSecurityService.LOG.fine("session forced closed: " + container.session.hashCode());
                                    }
                                    container.session.close();
                                    OrionSessionCleaner.hashSet.remove(container);
                                    continue;
                                }
                                keepAlive = true;
                            }
                            if (!keepAlive) {
                                OrionSessionCleaner.removeCleaner();
                                return;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

