/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BIMappable;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.BTypeDependency;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BMappedExt;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public abstract class MergeSupport {
    public static boolean changeUuidForComponent(BUuid newUuid, BComponent oldComponent, OrionSession session) {
        Type type = oldComponent.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt oldExt = (BMappedExt)oldComponent.getMixIn(mappedExtType);
        BUuid oldUuid = oldExt.getUuid();
        if (newUuid.equals((Object)oldUuid)) {
            return false;
        }
        info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BIOrdMappable.TYPE)).getDefault();
        OrionType orionType = (OrionType)info.getAgentType().getTypeSpec().getResolvedType();
        BOrionObject oldOrionObject = (BOrionObject)session.mappedRead((BObject)oldComponent);
        BOrionObject newOrionObject = (BOrionObject)orionType.getInstance();
        if (newOrionObject instanceof BIMappable) {
            ((BIMappable)newOrionObject).mapFrom((BObject)oldComponent);
        }
        newOrionObject.init(newOrionObject.getProperty("uuid"), (BValue)newUuid);
        newOrionObject.set("stationName", oldOrionObject.get("stationName"));
        if (!session.exists((BIOrionObject)newOrionObject)) {
            session.insert((BIOrionObject)newOrionObject);
        }
        MergeSupport.mergeRecords((BIOrionObject)newOrionObject, (BIOrionObject)oldOrionObject, session);
        oldExt.setUuid(newUuid);
        session.mappedUpdate((BObject)oldComponent);
        return true;
    }

    public static void mergeRecords(BIOrionObject newRec, BIOrionObject oldRec, OrionSession session) {
        BOrionDatabase db = oldRec.getOrionDatabase();
        if (db == null) {
            db = session.getOrionDatabase();
        }
        OrionType recordOrionType = oldRec.getOrionType();
        BTypeDependency[] typeDep = session.getOrionDatabase().getDependentTypes(recordOrionType);
        for (int i = 0; i < typeDep.length; ++i) {
            int j;
            BOrionTypeId fromId = typeDep[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            Property fromProp = orionType.getProperty(typeDep[i].getFromProperty());
            BIOrionObject[] matches = session.select(orionType, new PropertyValue(fromProp, (BValue)BRef.make((BIOrionObject)oldRec))).toArray();
            boolean isKey = false;
            Property[] keys = orionType.getKey();
            for (j = 0; j < keys.length; ++j) {
                if (!keys[j].equals(fromProp)) continue;
                isKey = true;
            }
            for (j = 0; j < matches.length; ++j) {
                if (!isKey) {
                    matches[j].set(fromProp, (BValue)BRef.make((BIOrionObject)newRec));
                    session.update(matches[j]);
                    continue;
                }
                session.delete(matches[j]);
                matches[j].init(fromProp, (BValue)BRef.make((BIOrionObject)newRec));
                session.persist(matches[j]);
            }
        }
        session.delete(oldRec);
    }

    public static void setReferencesToNull(BIOrionObject toDelete, OrionSession session) {
        BOrionDatabase db = session.getOrionDatabase();
        OrionType recordOrionType = toDelete.getOrionType();
        BTypeDependency[] typeDep = session.getOrionDatabase().getDependentTypes(recordOrionType);
        for (int i = 0; i < typeDep.length; ++i) {
            BOrionTypeId fromId = typeDep[i].getFromTypeId();
            OrionType orionType = db.getType(fromId);
            Property fromProp = orionType.getProperty(typeDep[i].getFromProperty());
            if (!toDelete.getSlotFacets((Slot)fromProp).getb("allowNull", false)) continue;
            MergeSupport.setReferencesToNull(toDelete, orionType, fromProp, session);
        }
    }

    public static void setReferencesToNull(BIOrionObject toDelete, OrionType orionType, Property property, OrionSession session) {
        BRef unboundRef = BRef.make((BOrionTypeId)toDelete.getOrionType().getOrionTypeId());
        OrionCursor c = session.select(orionType, new PropertyValue(property, (BValue)BRef.make((BIOrionObject)toDelete)));
        while (c.next()) {
            BIOrionObject match = (BIOrionObject)c.get();
            match.set(property, (BValue)unboundRef);
            session.update(match);
        }
    }
}

