/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.bql.cursor.BogCursor;
import com.tridium.orion.BIOrionAssociation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridium.orion.sql.BSqlExtent;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlJoin;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BITenantControlled;
import com.tridiumx.entsec.orionTools.BITenantJoin;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.BTenantFilter;
import com.tridiumx.entsec.orionTools.BTenantFilterOptions;
import com.tridiumx.entsec.orionTools.BinaryTreeExpressionBuilder;
import com.tridiumx.entsec.user.BEntsecUserConfig;
import javax.baja.hx.HxOp;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

public abstract class EntsecTenantUtil {
    public static final String USER_TENANTS = "userTenants";
    public static final String SUPER_USER_TENANT_REQUIRED = "suTenantRequired";
    public static final String TENANT_REQUIRED = "tenantRequired";
    public static final BTenantFilter filter = new BTenantFilter();

    public static BRefList getTenantList(Context cx) {
        if (cx == null || cx.getUser() == null) {
            return null;
        }
        BRefList sessionTenantList = BTenantFilterOptions.getOptions(cx).getTenants();
        if (sessionTenantList.isBound() && !cx.getFacets().getb(USER_TENANTS, false)) {
            return sessionTenantList;
        }
        BRefList tenantList = EntsecTenantUtil.getUserTenantList(cx);
        return tenantList;
    }

    public static BRefList getUserTenantList(Context cx) {
        if (cx == null || cx.getUser() == null) {
            return null;
        }
        return EntsecTenantUtil.getUserTenantList(cx.getUser());
    }

    public static BRefList getUserTenantList(BUser user) {
        BEntsecUserConfig config = (BEntsecUserConfig)user.getMixIn(BEntsecUserConfig.TYPE);
        if (config == null) {
            throw new IllegalStateException("BEntsecUserConfig not found");
        }
        BRefList tenantList = config.getTenants();
        return tenantList;
    }

    public static boolean hasAllTenants(Context cx) {
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        return tenantList == null || !tenantList.isBound();
    }

    public static boolean hasAllUserTenants(Context cx) {
        BRefList tenantList = EntsecTenantUtil.getUserTenantList(cx);
        return tenantList == null || !tenantList.isBound();
    }

    public static boolean hasAllAvailableTenants(Context cx) {
        if (cx == null || cx.getUser() == null) {
            return true;
        }
        BRefList sessionTenantList = BTenantFilterOptions.getOptions(cx).getTenants();
        return !sessionTenantList.isBound();
    }

    public static boolean hasSingleTenant(Context cx) {
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        return tenantList != null && tenantList.isBound() && tenantList.getIds().length == 1;
    }

    public static boolean hasSingleUserTenant(Context cx) {
        BRefList tenantList = EntsecTenantUtil.getUserTenantList(cx);
        return tenantList != null && tenantList.isBound() && tenantList.getIds().length == 1;
    }

    public static boolean hasTenants(Context cx) {
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        return tenantList != null && tenantList.isBound();
    }

    public static boolean isMissingTenant(BComponent c, Context cx) {
        return EntsecTenantUtil.isMissingTenant(c, false, cx);
    }

    public static boolean isMissingTenant(BComponent c, boolean checkMounted, Context cx) {
        BRefList requiredList = EntsecTenantUtil.getRequiredTenants(c, cx);
        BRefList matchableList = EntsecTenantUtil.getMatchableTenants(c, cx);
        if (requiredList == null && matchableList == null) {
            return false;
        }
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        return tenantList != null && tenantList.isBound() && !tenantList.containsAll(requiredList) && !tenantList.contains(matchableList) && (!checkMounted || EntsecTenantUtil.isMounted(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BRefList getMatchableTenants(BComponent c, Context cx) {
        if (c instanceof BITenantControlled) {
            OrionType tenantJoinType = ((BITenantControlled)c).getTenantControllerType();
            BITenantJoin tenantJoin = (BITenantJoin)tenantJoinType.getInstance();
            OrionSession session = null;
            try {
                session = ((BIOrionObject)c).getOrionDatabase().createSession(null);
                OrionCursor cursor = session.select(tenantJoinType, new PropertyValue(tenantJoin.getReferenceProperty(), (BValue)BRef.make((BIOrionObject)((BIOrionObject)c))));
                BIOrionObject[] joins = cursor.toArray();
                Array ids = new Array(BSimple.class);
                for (int i = 0; i < joins.length; ++i) {
                    BRef tenantRef = ((BITenantJoin)joins[i]).getTenant();
                    ids.add((Object)tenantRef.getId());
                }
                BRefList bRefList = BRefList.make(BTenant.ORION_TYPE.getOrionTypeId(), (BSimple[])ids.trim());
                return bRefList;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        return null;
    }

    public static BRefList getRequiredTenants(BComponent c, Context cx) {
        if (c instanceof BITenantObject) {
            return BRefList.make(((BITenantObject)c).getTenant());
        }
        if (c instanceof BTenant) {
            return BRefList.make((BIOrionObject)((BTenant)c));
        }
        if (c instanceof BUser) {
            return EntsecTenantUtil.getUserTenantList((BUser)c);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMounted(BComponent c) {
        if (c instanceof BIOrionObject) {
            BIOrionObject o = (BIOrionObject)c;
            OrionSession session = null;
            try {
                session = o.getOrionDatabase().createSession(null);
                boolean bl = session.exists(o);
                return bl;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        return c.isMounted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMissingTenantWarning(BComponent c, HxOp op) {
        BRefList requiredList = EntsecTenantUtil.getRequiredTenants(c, (Context)op);
        BRefList matchableList = EntsecTenantUtil.getMatchableTenants(c, (Context)op);
        if (requiredList == null && matchableList == null) {
            return null;
        }
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        OrionSession session = null;
        try {
            session = service.createSession(null);
            if (requiredList != null && !requiredList.isBound() || matchableList != null && !matchableList.isBound()) {
                String string = BEnterpriseSecurityService.lex.getText("restrictedByTenantNone");
                return string;
            }
            if (requiredList != null) {
                String string = BEnterpriseSecurityService.lex.getText("restrictedTenantWarning", new Object[]{requiredList.toDisplayString(session, (Context)op)});
                return string;
            }
            String string = BEnterpriseSecurityService.lex.getText("restrictedTenantWarning", new Object[]{matchableList.toDisplayString(session, (Context)op)});
            return string;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public static BIOrionObject[] filter(BIOrionObject[] o, Type type, Context cx) {
        if (o == null) {
            return null;
        }
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        Array a = new Array(type.getTypeClass());
        for (int i = 0; i < o.length; ++i) {
            if (EntsecTenantUtil.isMissingTenant((BComponent)o[i], cx)) continue;
            a.add((Object)o[i]);
        }
        return (BIOrionObject[])a.trim();
    }

    public static BQuery filter(BQuery q, Context cx) {
        if (q instanceof BSqlQuery) {
            throw new IllegalStateException("EntsecTenantUtil.filter must provide an OrionDatabase to filter tenant for a  BSqlQuery.");
        }
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        BFunctionExpression baseTenantExpresssion = Funcs.make((String)(BTenantFilterOptions.TYPE + ".hasTenants"), (Type)BBoolean.TYPE, (BExpression)Exprs.simple((BSimple)tenantList));
        if (q.hasPredicate()) {
            BExpression e = q.getPredicate().getPredicateExpr().newExprCopy();
            e = Predicates.and((BExpression)e, (BExpression)baseTenantExpresssion);
            q.where(e);
        } else {
            q.where((BExpression)baseTenantExpresssion);
        }
        return q;
    }

    public static BSqlQuery filter(BSqlQuery q, BOrionDatabase db, Context cx) {
        BRefList tenantList = EntsecTenantUtil.getTenantList(cx);
        if (tenantList == null || !tenantList.isBound()) {
            return q;
        }
        BSqlExtent extent = (BSqlExtent)q.getExtent();
        BTypeSpec baseExtent = extent.getBaseExtent();
        BIOrionObject o = (BIOrionObject)baseExtent.getInstance();
        OrionType rowType = o.getOrionType();
        BRef[] refs = tenantList.getRefs();
        if (o instanceof BTenant) {
            BSqlField field = new BSqlField(extent, rowType.getKey()[0]);
            BExpression baseTenantExpresssion = Predicates.in((BExpression)field, (BSimple[])refs);
            if (q.hasPredicate()) {
                BExpression e = q.getPredicate().getPredicateExpr().newExprCopy();
                e = Predicates.and((BExpression)e, (BExpression)baseTenantExpresssion);
                q.where(e);
            } else {
                q.where(baseTenantExpresssion);
            }
        } else if (o instanceof BITenantObject) {
            BITenantObject tenantObject = (BITenantObject)o;
            BSqlField field = new BSqlField(extent, tenantObject.getTenantProperty());
            BExpression baseTenantExpresssion = Predicates.in((BExpression)field, (BSimple[])refs);
            if (q.hasPredicate()) {
                BExpression e = q.getPredicate().getPredicateExpr().newExprCopy();
                e = Predicates.and((BExpression)e, (BExpression)baseTenantExpresssion);
                q.where(e);
            } else {
                q.where(baseTenantExpresssion);
            }
        } else if (o instanceof BITenantControlled) {
            BITenantControlled tenantControlled = (BITenantControlled)o;
            OrionType tenantJoinType = tenantControlled.getTenantControllerType();
            BITenantJoin tenantJoin = (BITenantJoin)tenantJoinType.getInstance();
            BSqlJoin join = new BSqlJoin(o.getOrionType(), o.getOrionType().getKey()[0], tenantJoinType, tenantJoin.getReferenceProperty());
            join.getJoinTable().alias(extent.getExtentAlias());
            EntsecTenantUtil.join(q, join);
        }
        BSqlJoin[] joins = q.getJoins();
        for (int i = 0; i < joins.length; ++i) {
            BIOrionObject joinObject = (BIOrionObject)joins[i].getJoinTable().getBaseExtent().getInstance();
            OrionType joinType = joinObject.getOrionType();
            if (joinObject instanceof BITenantControlled && !rowType.equals(BTenant.ORION_TYPE) || !(joinObject instanceof BITenantObject) || rowType.equals(BTenant.ORION_TYPE)) continue;
            BITenantObject tenantObject = (BITenantObject)joinObject;
            BSqlField field = new BSqlField(joinType, tenantObject.getTenantProperty());
            field.alias(joins[i].getJoinTable().getExtentAlias());
            BinaryTreeExpressionBuilder b = new BinaryTreeExpressionBuilder(true);
            for (int j = 0; j < refs.length; ++j) {
                b.add(Predicates.eq((BExpression)field.newExprCopy(), (BSimple)refs[j]));
            }
            boolean complete = EntsecTenantUtil.addExpressionToSubQueryPredicate(joins[i].getOnExpr(), b.getExpression());
            if (complete) continue;
            joins[i].setOnExpr(Predicates.and((BExpression)joins[i].getOnExpr().newExprCopy(), (BExpression)b.getExpression()));
        }
        return q;
    }

    public static boolean addExpressionToSubQueryPredicate(BExpression onExpression, BExpression additionalExpression) {
        if (onExpression == null || additionalExpression == null) {
            return false;
        }
        BogCursor c = new BogCursor((BComplex)onExpression, 100, new Type[]{BSqlQuery.TYPE}, false, null);
        if (c.next()) {
            BSqlQuery subquery = (BSqlQuery)c.get();
            BExpression e = subquery.getPredicate().getPredicateExpr().newExprCopy();
            e = Predicates.and((BExpression)e, (BExpression)additionalExpression);
            subquery.where(e);
            return true;
        }
        return false;
    }

    public static void join(BSqlQuery query, BSqlJoin join) {
        BSqlJoin[] joins = query.getJoins();
        for (int i = 0; i < joins.length; ++i) {
            BSqlExtent extent = joins[i].getJoinTable();
            if (!extent.getBaseExtent().equals((Object)join.getJoinTable().getBaseExtent())) continue;
            query.remove(joins[i].getName());
        }
        query.join(join);
    }

    public static OrionCursor select(OrionType orionType, OrionSession session) {
        BSqlQuery q = BSqlQuery.make((OrionType)orionType);
        return EntsecTenantUtil.select(q, session);
    }

    public static OrionCursor select(OrionType orionType, BExpression e, OrionSession session) {
        BSqlQuery q = BSqlQuery.make((OrionType)orionType);
        q.where(e);
        return EntsecTenantUtil.select(q, session);
    }

    public static OrionCursor select(BSqlQuery q, OrionSession session) {
        q = filter.filter(q, session.getOrionDatabase(), (Context)session);
        return session.select((BQuery)q);
    }

    public static OrionCursor select(OrionType orionType, PropertyValue propertyValue, OrionSession session) {
        return session.select((BQuery)EntsecTenantUtil.selectQuery(orionType, propertyValue));
    }

    public static BSqlQuery selectQuery(OrionType orionType, BExpression e) {
        BSqlQuery q = BSqlQuery.make((OrionType)orionType);
        q.where(e);
        return q;
    }

    public static BSqlQuery selectQuery(OrionType orionType, PropertyValue propertyValue) {
        Property property = propertyValue.getProperty();
        BValue value = propertyValue.getValue();
        BSqlField recField = new BSqlField(orionType, property);
        BExpression e = Predicates.eq((BExpression)recField, (BSimple)value.asSimple());
        if (value instanceof BRef && orionType.is(BIOrionAssociation.TYPE)) {
            BRef otherRef = null;
            OrionType otherRefType = null;
            Property otherProperty = null;
            BRef ref = (BRef)value;
            OrionType refOrionType = (OrionType)ref.getTargetTypeSpec().getResolvedType();
            Property[] key = orionType.getKey();
            for (int i = 0; i < key.length; ++i) {
                BRef currentRef;
                OrionType currentOrionType;
                if (!key[i].getType().equals(BRef.TYPE) || (currentOrionType = (OrionType)(currentRef = (BRef)key[i].getDefaultValue()).getTargetTypeSpec().getResolvedType()).equals(refOrionType)) continue;
                otherRefType = currentOrionType;
                otherRef = currentRef;
                otherProperty = key[i];
                break;
            }
            BSqlQuery q = BSqlQuery.make((OrionType)orionType);
            q.where(e);
            BSqlField from = new BSqlField(orionType, otherProperty);
            BSqlField to = new BSqlField(otherRefType, otherRefType.getKey()[0]);
            BSqlJoin join = new BSqlJoin(from, to);
            EntsecTenantUtil.join(q, join);
            return q;
        }
        return EntsecTenantUtil.selectQuery(orionType, e);
    }

    public static int getCount(OrionType orionType, OrionSession session) {
        BSqlQuery q = BSqlQuery.make((OrionType)orionType);
        return EntsecTenantUtil.getCount(q, session);
    }

    public static int getCount(OrionType orionType, Property property, BSimple value, OrionSession session) {
        BSqlField recField = new BSqlField(orionType, property);
        BExpression e = Predicates.eq((BExpression)recField, (BSimple)value);
        if (value instanceof BRef && orionType.is(BIOrionAssociation.TYPE)) {
            BRef otherRef = null;
            OrionType otherRefType = null;
            Property otherProperty = null;
            BRef ref = (BRef)value;
            OrionType refOrionType = (OrionType)ref.getTargetTypeSpec().getResolvedType();
            Property[] key = orionType.getKey();
            for (int i = 0; i < key.length; ++i) {
                BRef currentRef;
                OrionType currentOrionType;
                if (!key[i].getType().equals(BRef.TYPE) || (currentOrionType = (OrionType)(currentRef = (BRef)key[i].getDefaultValue()).getTargetTypeSpec().getResolvedType()).equals(refOrionType)) continue;
                otherRefType = currentOrionType;
                otherRef = currentRef;
                otherProperty = key[i];
                break;
            }
            BSqlQuery q = BSqlQuery.make((OrionType)orionType);
            q.where(e);
            if (otherRef == null) {
                return EntsecTenantUtil.getCount(q, session);
            }
            BSqlField from = new BSqlField(orionType, otherProperty);
            BSqlField to = new BSqlField(otherRefType, otherRefType.getKey()[0]);
            BSqlJoin join = new BSqlJoin(from, to);
            EntsecTenantUtil.join(q, join);
            return EntsecTenantUtil.getCount(q, session);
        }
        return EntsecTenantUtil.getCount(orionType, e, session);
    }

    public static int getCount(OrionType orionType, BExpression e, OrionSession session) {
        BSqlQuery q = BSqlQuery.make((OrionType)orionType);
        q.where(e);
        return EntsecTenantUtil.getCount(q, session);
    }

    public static int getCount(BSqlQuery q, OrionSession session) {
        q = filter.filter(q, session.getOrionDatabase(), (Context)session);
        q.select(SqlColumns.projection((BProjectionColumn)SqlColumns.make((BExpression)Funcs.count((String)"*"))));
        if (q.hasOrdering()) {
            q.remove((BComplex)q.getOrdering());
        }
        OrionCursor c = session.select((BQuery)q);
        c.next();
        BDynamicOrionObject result = (BDynamicOrionObject)c.get();
        if (result == null) {
            return 0;
        }
        OrionType type = result.getOrionType();
        Property[] dps = type.getProperties();
        int count = ((BInteger)result.get(dps[0])).getInt();
        return count;
    }
}

