/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BRefList;
import com.tridiumx.entsec.orionTools.BTenant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public final class BTenantCache
extends BSimple {
    static final int CACHE_THRESHOLD = Integer.getInteger("niagara.entsec.tenantCache.threshold", 6);
    public static final BTenantCache DEFAULT = new BTenantCache();
    public static final Type TYPE = Sys.loadType(BTenantCache.class);
    private HashMap map = new HashMap();
    private BOrionDatabase db;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayString(BRefList refList) {
        if (!refList.isBound()) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        BSimple[] ids = refList.getIds();
        if (ids.length > CACHE_THRESHOLD) {
            return refList.toString();
        }
        for (int i = 0; i < ids.length; ++i) {
            String displayString = (String)this.map.get(ids[i]);
            if (displayString != null) {
                if (b.length() > 0) {
                    b.append("; ");
                }
                b.append(displayString);
                continue;
            }
            OrionSession session = null;
            try {
                session = this.getOrionDatabase().createSession(null);
                BTenant tenant = (BTenant)BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec(), (BSimple)ids[i]).getTarget(session);
                if (tenant == null) continue;
                displayString = tenant.getTenantName();
                this.map.put(ids[i], displayString);
                if (b.length() > 0) {
                    b.append("; ");
                }
                b.append(displayString);
                continue;
            }
            finally {
                if (session != null) {
                    session.close();
                    session = null;
                }
            }
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        return "null";
    }

    public BObject decodeFromString(String s) throws IOException {
        return DEFAULT;
    }

    public BOrionDatabase getOrionDatabase() {
        if (this.db == null) {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            this.db = service.getOrionDatabase();
        }
        return this.db;
    }

    public Type getType() {
        return TYPE;
    }
}

