/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.BIOrdMappable;
import com.tridiumx.entsec.orionTools.BMappedScheduleExt;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class BScheduleRec
extends BReplicableObject
implements BIOrdMappable {
    public static final Property uuid = BScheduleRec.newProperty((int)1, (BValue)BUuid.NULL, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property stationName = BScheduleRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property scheduleName = BScheduleRec.newProperty((int)9, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"displayId", (boolean)true)));
    public static final Property scheduleDisplayPath = BScheduleRec.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"width", (int)256));
    public static final Property scheduleTypeSpec = BScheduleRec.newProperty((int)1, (BValue)BTypeSpec.DEFAULT, (BFacets)BFacets.make((String)"width", (int)64));
    public static final Property scheduleUsage = BScheduleRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property trueText = BScheduleRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property falseText = BScheduleRec.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BScheduleRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    private static final BIcon ICON = BIcon.std((String)"schedule.png");
    public static final String USAGE = "usage";

    public BUuid getUuid() {
        return (BUuid)this.get(uuid);
    }

    public void setUuid(BUuid v) {
        this.set(uuid, (BValue)v, null);
    }

    @Override
    public String getStationName() {
        return this.getString(stationName);
    }

    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    public String getScheduleName() {
        return this.getString(scheduleName);
    }

    public void setScheduleName(String v) {
        this.setString(scheduleName, v, null);
    }

    public String getScheduleDisplayPath() {
        return this.getString(scheduleDisplayPath);
    }

    public void setScheduleDisplayPath(String v) {
        this.setString(scheduleDisplayPath, v, null);
    }

    public BTypeSpec getScheduleTypeSpec() {
        return (BTypeSpec)this.get(scheduleTypeSpec);
    }

    public void setScheduleTypeSpec(BTypeSpec v) {
        this.set(scheduleTypeSpec, (BValue)v, null);
    }

    public String getScheduleUsage() {
        return this.getString(scheduleUsage);
    }

    public void setScheduleUsage(String v) {
        this.setString(scheduleUsage, v, null);
    }

    public String getTrueText() {
        return this.getString(trueText);
    }

    public void setTrueText(String v) {
        this.setString(trueText, v, null);
    }

    public String getFalseText() {
        return this.getString(falseText);
    }

    public void setFalseText(String v) {
        this.setString(falseText, v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public void afterInsert(OrionSession session) {
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertScheduleRec(this);
        if (!Sys.getStation().getStationName().equals(this.getStationName())) {
            BMappedScheduleExt.importSchedule(this);
        }
        super.afterInsert(session);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateScheduleRec(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteScheduleRec(this);
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        if (this.getScheduleName().length() == 0) {
            return false;
        }
        try {
            BBooleanSchedule schedule = (BBooleanSchedule)this.getMappedOrd().get();
            if (Flags.isReadonly((BComplex)schedule.getParent(), (Slot)schedule.getPropertyInParent())) {
                return super.beforeUpdate(session);
            }
            BScheduleRec rec = (BScheduleRec)session.read((BIOrionObject)this.newCopy());
            String displayOrd = rec.getScheduleDisplayPath();
            if (!this.getScheduleDisplayPath().equals(displayOrd)) {
                Logger.getLogger(TYPE.getModule().getModuleName()).info("update schedule path from " + displayOrd + " to " + this.getScheduleDisplayPath());
                BMappedScheduleExt.updateSchedulePath(rec, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.beforeUpdate(session);
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        BScheduleRec rec = (BScheduleRec)session.read((BIOrionObject)this.newCopy());
        if (rec == null) {
            return false;
        }
        MergeSupport.setReferencesToNull((BIOrionObject)this, session);
        Logger.getLogger(TYPE.getModule().getModuleName()).info("deleting a schedule: " + rec.getMappedDisplayPath());
        try {
            BMappedScheduleExt.deleteSchedule(rec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.beforeDelete(session);
    }

    public void mapFrom(BObject source) {
        BBooleanSchedule schedule = (BBooleanSchedule)source;
        BMappedScheduleExt ext = (BMappedScheduleExt)schedule.getMixIn(BMappedScheduleExt.TYPE);
        this.setUuid(ext.getUuid());
        this.setScheduleTypeSpec(schedule.getType().getTypeSpec());
        if (schedule.isRunning()) {
            this.setStationName(Sys.getStation().getStationName());
        } else {
            BStation station = this.getConfigStation((BComponent)schedule);
            if (station == null) {
                return;
            }
            this.setStationName(station.getStationName());
        }
        this.setScheduleUsage(schedule.getFacets().gets(USAGE, ""));
        this.setTrueText(schedule.getFacets().gets("trueText", "true"));
        this.setFalseText(schedule.getFacets().gets("falseText", "false"));
        String displayName = schedule.getDisplayName(null);
        if (displayName != null) {
            this.setScheduleName(displayName);
        } else if (schedule.getName() != null) {
            this.setScheduleName(schedule.getName());
        } else {
            throw new IllegalStateException("need a name when running");
        }
        this.setSlotPathOrd((BObject)schedule);
    }

    @Override
    public BOrd getMappedOrd() {
        return MappingSupport.getMappedOrd(this);
    }

    @Override
    public void setSlotPathOrd(BObject source) {
        this.setScheduleDisplayPath(MappingSupport.getDisplayPath(source));
    }

    @Override
    public String getMappedDisplayPath() {
        return this.getScheduleDisplayPath();
    }

    public String getMappedSupervisorId() {
        return MappingSupport.displayPathToSlotOrd(this.getScheduleDisplayPath());
    }

    public String toString(Context cx) {
        return this.toDisplayString(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BStation getConfigStation(BComponent pObject) {
        BStation object = null;
        BComplex parent = null;
        try {
            if (pObject == null) {
                BStation bStation = null;
                return bStation;
            }
            if (pObject instanceof BStation) {
                BStation bStation = object = (BStation)pObject;
                return bStation;
            }
            for (parent = pObject.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BStation)) continue;
                object = (BStation)parent;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            parent = null;
        }
        return object;
    }

    public BIcon getIcon() {
        return ICON;
    }
}

