/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.orionTools;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.nd.schedule.BNiagaraScheduleExport;
import com.tridium.nd.schedule.BNiagaraScheduleImportExt;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.BMappedExt;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.util.logging.Level;
import javax.baja.driver.BDevice;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BMappedScheduleExt
extends BMappedExt {
    public static final Type TYPE = Sys.loadType(BMappedScheduleExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        this.importUuid();
        super.started();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importUuid() {
        BNiagaraScheduleImportExt ext;
        BAbstractSchedule schedule = (BAbstractSchedule)this.getParent();
        BComplex parent = schedule.getParent();
        if (parent instanceof BNiagaraScheduleDeviceExt && this.getUuid().equals((Object)BUuid.DEFAULT) && (ext = (BNiagaraScheduleImportExt)this.getParent().get("ext")) != null) {
            BNiagaraScheduleDeviceExt devicelet = (BNiagaraScheduleDeviceExt)parent;
            BNiagaraStation station = (BNiagaraStation)devicelet.getParent();
            String stringInterest = TYPE + ".importUuid." + BUuid.make().toString();
            BFoxClientConnection.StringInterest interest = new BFoxClientConnection.StringInterest(stringInterest);
            BDataChannel dataChannel = (BDataChannel)station.getClientConnection().getChannels().get("data", BDataChannel.TYPE);
            try {
                station.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)interest);
                BOrd ord = BOrd.make((String)("station:|" + ext.getSupervisorId() + "/entsec_MappedScheduleExt/uuid"));
                BString s = (BString)dataChannel.resolve(ord);
                BUuid mappedUuid = BUuid.make((String)s.toString());
                this.setUuid(mappedUuid);
            }
            catch (Exception e) {
                BEnterpriseSecurityService.LOG.log(Level.SEVERE, "Cannot import uuid for remote schedule: " + schedule.getSlotPath(), e);
            }
            finally {
                station.getClientConnection().disengage((BFoxClientConnection.Interest)interest);
            }
        }
    }

    public static void importSchedule(BScheduleRec rec) {
        BAbstractSchedule schedule = (BAbstractSchedule)rec.getScheduleTypeSpec().getInstance();
        BMappedScheduleExt mappedExt = new BMappedScheduleExt();
        mappedExt.setUuid(rec.getUuid());
        schedule.add("entsec_MappedScheduleExt", (BValue)mappedExt, 1);
        BNiagaraScheduleImportExt importExt = new BNiagaraScheduleImportExt();
        importExt.setSupervisorId(rec.getMappedSupervisorId());
        schedule.add("ext", (BValue)importExt);
        String stationName = rec.getStationName();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].getName().equals(stationName)) continue;
            BNiagaraStation station = (BNiagaraStation)devices[i];
            BNiagaraScheduleDeviceExt niagaraExt = station.getSchedules();
            Property property = niagaraExt.add(rec.getScheduleName() + "?", (BValue)schedule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSchedulePath(BScheduleRec oldRec, BScheduleRec newRec) throws Exception {
        String interest = oldRec.getUuid().toString();
        String stationName = Sys.getStation().getStationName();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            BNiagaraStation station = (BNiagaraStation)devices[i];
            if (station.isDown() || station.isDisabled() || station.isFatalFault()) continue;
            BNiagaraScheduleDeviceExt niagaraExt = station.getSchedules();
            BNiagaraScheduleExport[] exports = (BNiagaraScheduleExport[])niagaraExt.getChildren(BNiagaraScheduleExport.class);
            for (int j = 0; j < exports.length; ++j) {
                if (!exports[j].getSupervisorId().equals(oldRec.getMappedSupervisorId())) continue;
                exports[j].setSupervisorId(newRec.getMappedSupervisorId());
                niagaraExt.rename(exports[j].getPropertyInParent(), SlotPath.escape((String)(newRec.getScheduleName() + "Export")));
                BFoxSession foxSession = RemoteUtil.getFoxSession(station);
                try {
                    foxSession.engageNoRetry(interest);
                    BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)foxSession.getService(BNiagaraNetwork.TYPE);
                    remoteNetwork.lease();
                    BNiagaraStation remoteStation = (BNiagaraStation)remoteNetwork.get(stationName);
                    remoteStation.lease();
                    BNiagaraScheduleDeviceExt remoteNiagaraExt = remoteStation.getSchedules();
                    remoteNiagaraExt.lease();
                    BAbstractSchedule[] remoteSchedules = (BAbstractSchedule[])remoteNiagaraExt.getChildren(BAbstractSchedule.class);
                    for (int k = 0; k < remoteSchedules.length; ++k) {
                        BAbstractSchedule remoteSchedule = remoteSchedules[k];
                        remoteSchedule.lease(2);
                        BNiagaraScheduleImportExt[] imports = (BNiagaraScheduleImportExt[])remoteSchedule.getChildren(BNiagaraScheduleImportExt.class);
                        for (int m = 0; m < imports.length; ++m) {
                            if (!imports[m].getSupervisorId().equals(oldRec.getMappedSupervisorId())) continue;
                            imports[m].setSupervisorId(newRec.getMappedSupervisorId().toString());
                            remoteSchedule.getParent().asComponent().rename(remoteSchedule.getPropertyInParent(), SlotPath.escape((String)newRec.getScheduleName()));
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    foxSession.disengage(interest);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteSchedule(BScheduleRec oldRec) throws Exception {
        String interest = oldRec.getUuid().toString();
        String stationName = Sys.getStation().getStationName();
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String networkOrd = network.toDisplayPathString(null);
        if (oldRec.getMappedDisplayPath().startsWith(networkOrd)) {
            return;
        }
        BDevice[] devices = network.getDevices();
        for (int i = 0; i < devices.length; ++i) {
            BNiagaraStation station = (BNiagaraStation)devices[i];
            if (station.isDown() || station.isDisabled() || station.isFatalFault()) continue;
            BNiagaraScheduleDeviceExt niagaraExt = station.getSchedules();
            BNiagaraScheduleExport[] exports = (BNiagaraScheduleExport[])niagaraExt.getChildren(BNiagaraScheduleExport.class);
            for (int j = 0; j < exports.length; ++j) {
                if (!exports[j].getSupervisorId().equals(oldRec.getMappedSupervisorId())) continue;
                niagaraExt.remove(exports[j].getPropertyInParent());
                BFoxSession foxSession = RemoteUtil.getFoxSession(station);
                try {
                    foxSession.engageNoRetry(interest);
                    BNiagaraNetwork remoteNetwork = (BNiagaraNetwork)foxSession.getService(BNiagaraNetwork.TYPE);
                    remoteNetwork.lease();
                    BNiagaraStation remoteStation = (BNiagaraStation)remoteNetwork.get(stationName);
                    remoteStation.lease();
                    BNiagaraScheduleDeviceExt remoteNiagaraExt = remoteStation.getSchedules();
                    remoteNiagaraExt.lease();
                    BAbstractSchedule[] remoteSchedules = (BAbstractSchedule[])remoteNiagaraExt.getChildren(BAbstractSchedule.class);
                    for (int k = 0; k < remoteSchedules.length; ++k) {
                        BAbstractSchedule remoteSchedule = remoteSchedules[k];
                        remoteSchedule.lease(2);
                        BNiagaraScheduleImportExt[] imports = (BNiagaraScheduleImportExt[])remoteSchedule.getChildren(BNiagaraScheduleImportExt.class);
                        for (int m = 0; m < imports.length; ++m) {
                            if (!imports[m].getSupervisorId().equals(oldRec.getMappedSupervisorId())) continue;
                            remoteSchedule.getParent().asComponent().remove(remoteSchedule.getPropertyInParent());
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    foxSession.disengage(interest);
                }
            }
        }
    }

    @Override
    public Type getMappedType() {
        return BBooleanSchedule.TYPE;
    }

    @Override
    public int getSubscriptionDepth() {
        return 1;
    }

    @Override
    public Property[] getSubscribedProperties() {
        return new Property[]{BControlSchedule.facets};
    }
}

