/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.util;

import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.access.orion.BBadgeLdapServerJoin;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.BLdapAttributeProperties;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import com.tridiumx.ldapDriver.users.BLdapUserOperationResponse;
import com.tridiumx.ldapDriver.users.BLdapUserOperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.baja.job.BJob;
import javax.baja.nre.util.Array;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

public class LdapValidationUtil {
    private static final int IMPORT_CATEGORY_INDEX = 23;
    private static final int EXPORT_CATEGORY_INDEX = 24;
    private static final String SUCCESS = "Success";

    public static boolean checkDistinguishNamesExists(ArrayList distinguishNames) {
        return distinguishNames.size() >= 1;
    }

    public static boolean checkForAttributesMappingExists(String ldapServerName) {
        BLdapNetwork ldapNetwork = (BLdapNetwork)Sys.getService((Type)BLdapNetwork.TYPE);
        ldapNetwork.lease();
        BLdapServer selectedLdapServer = (BLdapServer)ldapNetwork.get(ldapServerName);
        BLdapAttributesDeviceExt attributeList = selectedLdapServer.getAttributes();
        BLdapAttributeProperties[] attrProperties = (BLdapAttributeProperties[])attributeList.getChildren(BLdapAttributeProperties.class);
        return attrProperties.length > 0;
    }

    public static void validatePersonsAddToLdapServer(BJob job, BLdapUserOperationResponse[] userResult, HashMap<String, BPersonLdapServerJoin> personLdapJoinMap, List<BLDAPAuditRecord> auditRecords, HashMap<String, BBadgeLdapServerJoin> badgeLdapServerJoin) {
        HashMap<String, BPersonLdapServerJoin> personLdapJoinHashMap = personLdapJoinMap;
        for (int i = 0; i < userResult.length; ++i) {
            BLdapUserOperationStatus status = userResult[i].getStatus();
            BLDAPAuditRecord ldapAuditRecord = auditRecords.get(i);
            ldapAuditRecord.setStatus(userResult[i].getStatus().toString());
            if (userResult[i].getStatus().toString().equals(SUCCESS)) continue;
            personLdapJoinHashMap.remove(userResult[i].getDistinguishedName());
            badgeLdapServerJoin.remove(userResult[i].getDistinguishedName());
            String faultCause = "Failed to add Person: " + userResult[i].getDistinguishedName();
            job.log().failed(faultCause, (Throwable)new Exception(userResult[i].getStatus().toString()));
            ldapAuditRecord.setDetails(faultCause);
        }
    }

    public static Array validatePersonsDeleteFromLdapServer(BJob job, BLdapUserOperationResponse[] userResult) {
        Array deletedUsersList = new Array(BSimple.class);
        for (int i = 0; i < userResult.length; ++i) {
            BLdapUserOperationStatus status = userResult[i].getStatus();
            if (!userResult[i].getStatus().toString().equals(SUCCESS)) {
                job.log().failed("Failed to delete Person " + userResult[i].getDistinguishedName(), (Throwable)new Exception(userResult[i].getStatus().toString()));
                continue;
            }
            deletedUsersList.add((Object)BString.make((String)userResult[i].getDistinguishedName()));
        }
        return deletedUsersList;
    }

    public static boolean hasExportPrivileges(BUser user) {
        BPermissionsMap permissionsMap = user.getPermissions();
        BPermissions permissions = permissionsMap.getPermissions(24);
        return permissions.hasAdminInvoke();
    }

    public static boolean hasImportPrivileges(BUser user) {
        BPermissionsMap permissionsMap = user.getPermissions();
        BPermissions permissions = permissionsMap.getPermissions(23);
        return permissions.hasAdminInvoke();
    }

    public static String validateMandatoryAttributes(HashMap attributesMap, BLdapServer selectedLdapServer) {
        StringBuilder builder = new StringBuilder();
        BLdapAttributesDeviceExt attributeExt = selectedLdapServer.getAttributes();
        String mandatoryAttributes = attributeExt.getMandatoryAttributes();
        String[] attr = mandatoryAttributes.split(";");
        ArrayList<String> mandAttrList = new ArrayList<String>(Arrays.asList(attr));
        for (int i = 0; i < mandAttrList.size(); ++i) {
            if (attributesMap.containsKey(mandAttrList.get(i))) continue;
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(mandAttrList.get(i));
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return "";
    }
}

